/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.bloomingnature.core.block;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.item.FallingBlockEntity;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SandLayerBlock
extends Block {
    public static final IntegerProperty LAYERS = BlockStateProperties.f_61417_;
    protected static final VoxelShape[] SHAPE_BY_LAYER = new VoxelShape[]{Shapes.m_83040_(), Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0), Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)4.0, (double)16.0), Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)6.0, (double)16.0), Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)8.0, (double)16.0), Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)10.0, (double)16.0), Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)12.0, (double)16.0), Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)14.0, (double)16.0), Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0)};

    public SandLayerBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)LAYERS, (Comparable)Integer.valueOf(1)));
    }

    public boolean m_7357_(BlockState blockState, BlockGetter blockGetter, BlockPos blockPos, PathComputationType pathComputationType) {
        return switch (pathComputationType) {
            default -> throw new IncompatibleClassChangeError();
            case PathComputationType.LAND -> {
                if ((Integer)blockState.m_61143_((Property)LAYERS) < 5) {
                    yield true;
                }
                yield false;
            }
            case PathComputationType.WATER, PathComputationType.AIR -> false;
        };
    }

    @NotNull
    public VoxelShape m_5940_(BlockState blockState, BlockGetter blockGetter, BlockPos blockPos, CollisionContext collisionContext) {
        return SHAPE_BY_LAYER[(Integer)blockState.m_61143_((Property)LAYERS)];
    }

    @NotNull
    public VoxelShape m_5939_(BlockState blockState, BlockGetter blockGetter, BlockPos blockPos, CollisionContext collisionContext) {
        return SHAPE_BY_LAYER[(Integer)blockState.m_61143_((Property)LAYERS) - 1];
    }

    @NotNull
    public VoxelShape m_7947_(BlockState blockState, BlockGetter blockGetter, BlockPos blockPos) {
        return SHAPE_BY_LAYER[(Integer)blockState.m_61143_((Property)LAYERS)];
    }

    @NotNull
    public VoxelShape m_5909_(BlockState blockState, BlockGetter blockGetter, BlockPos blockPos, CollisionContext collisionContext) {
        return SHAPE_BY_LAYER[(Integer)blockState.m_61143_((Property)LAYERS)];
    }

    public boolean m_7923_(BlockState blockState) {
        return true;
    }

    public float m_7749_(BlockState blockState, BlockGetter blockGetter, BlockPos blockPos) {
        return (Integer)blockState.m_61143_((Property)LAYERS) == 8 ? 0.2f : 1.0f;
    }

    @NotNull
    public BlockState m_7417_(BlockState blockState, Direction direction, BlockState blockState2, LevelAccessor levelAccessor, BlockPos blockPos, BlockPos blockPos2) {
        return !blockState.m_60710_((LevelReader)levelAccessor, blockPos) ? Blocks.f_50016_.m_49966_() : super.m_7417_(blockState, direction, blockState2, levelAccessor, blockPos, blockPos2);
    }

    public void m_213898_(BlockState blockState, ServerLevel serverLevel, BlockPos blockPos, RandomSource randomSource) {
        if (serverLevel.m_45517_(LightLayer.BLOCK, blockPos) > 11) {
            SandLayerBlock.m_49950_((BlockState)blockState, (Level)serverLevel, (BlockPos)blockPos);
            serverLevel.m_7471_(blockPos, false);
        }
        if (!this.canFall((LevelAccessor)serverLevel, blockPos)) {
            return;
        }
        if (!serverLevel.m_5776_()) {
            FallingBlockEntity.m_201971_((Level)serverLevel, (BlockPos)blockPos, (BlockState)blockState);
        }
    }

    public boolean m_6864_(BlockState blockState, BlockPlaceContext blockPlaceContext) {
        int i = (Integer)blockState.m_61143_((Property)LAYERS);
        if (blockPlaceContext.m_43722_().m_150930_(this.m_5456_()) && i < 8) {
            if (blockPlaceContext.m_7058_()) {
                return blockPlaceContext.m_43719_() == Direction.UP;
            }
            return true;
        }
        return i == 1;
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext blockPlaceContext) {
        BlockState blockState = blockPlaceContext.m_43725_().m_8055_(blockPlaceContext.m_8083_());
        if (blockState.m_60713_((Block)this)) {
            int i = (Integer)blockState.m_61143_((Property)LAYERS);
            return (BlockState)blockState.m_61124_((Property)LAYERS, (Comparable)Integer.valueOf(Math.min(8, i + 1)));
        }
        return super.m_5573_(blockPlaceContext);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{LAYERS});
    }

    private boolean canFall(LevelAccessor level, BlockPos pos) {
        BlockPos below = pos.m_7495_();
        BlockState stateBelow = level.m_8055_(below);
        return !stateBelow.m_60783_((BlockGetter)level, below, Direction.UP);
    }
}

