/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.beachparty.core.block;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.satisfy.beachparty.core.block.entity.RadioBlockEntity;
import net.satisfy.beachparty.core.registry.EntityTypeRegistry;
import net.satisfy.beachparty.core.registry.SoundEventRegistry;
import net.satisfy.beachparty.core.util.BeachpartyUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RadioBlock
extends BaseEntityBlock {
    public static final BooleanProperty ON = BooleanProperty.m_61465_((String)"on");
    public static final BooleanProperty SEARCHING = BooleanProperty.m_61465_((String)"searching");
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;
    private static final Supplier<VoxelShape> voxelShapeSupplier = () -> Shapes.m_83048_((double)0.125, (double)0.0, (double)0.3125, (double)0.875, (double)0.5, (double)0.6875);
    public static final Map<Direction, VoxelShape> SHAPE = (Map)Util.m_137469_(new HashMap(), map -> {
        for (Direction direction : Direction.Plane.HORIZONTAL.m_122557_().toList()) {
            map.put(direction, BeachpartyUtil.rotateShape(Direction.NORTH, direction, voxelShapeSupplier.get()));
        }
    });

    public RadioBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)ON, (Comparable)Boolean.valueOf(false))).m_61124_((Property)SEARCHING, (Comparable)Boolean.valueOf(false))).m_61124_((Property)FACING, (Comparable)Direction.NORTH));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{ON, SEARCHING, FACING});
    }

    @NotNull
    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new RadioBlockEntity(pos, state);
    }

    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> type) {
        return type == EntityTypeRegistry.RADIO_BLOCK_ENTITY.get() ? (lvl, pos, st, be) -> RadioBlockEntity.tick(lvl, pos, (RadioBlockEntity)be) : null;
    }

    @NotNull
    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return SHAPE.get(state.m_61143_((Property)FACING));
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)context.m_8125_().m_122424_())).m_61124_((Property)ON, (Comparable)Boolean.valueOf(false))).m_61124_((Property)SEARCHING, (Comparable)Boolean.valueOf(false));
    }

    @NotNull
    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (!(blockEntity instanceof RadioBlockEntity)) {
            return InteractionResult.PASS;
        }
        RadioBlockEntity radio = (RadioBlockEntity)blockEntity;
        level.m_7731_(pos, (BlockState)state.m_61124_((Property)SEARCHING, (Comparable)Boolean.valueOf(true)), 3);
        level.m_186460_(pos, (Block)this, 10);
        level.m_5594_(null, pos, (SoundEvent)SoundEventRegistry.RADIO_CLICK.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
        if (player.m_6144_()) {
            radio.stop();
            level.m_7731_(pos, (BlockState)((BlockState)state.m_61124_((Property)ON, (Comparable)Boolean.valueOf(false))).m_61124_((Property)SEARCHING, (Comparable)Boolean.valueOf(true)), 3);
        } else {
            boolean started = radio.toggleOrNext();
            if (started) {
                level.m_5594_(null, pos, (SoundEvent)SoundEventRegistry.RADIO_TUNE.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
            }
            level.m_7731_(pos, (BlockState)((BlockState)state.m_61124_((Property)ON, (Comparable)Boolean.valueOf(started))).m_61124_((Property)SEARCHING, (Comparable)Boolean.valueOf(true)), 3);
        }
        return InteractionResult.m_19078_((boolean)level.f_46443_);
    }

    public void m_213897_(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        level.m_7731_(pos, (BlockState)state.m_61124_((Property)SEARCHING, (Comparable)Boolean.valueOf(false)), 3);
    }

    public void m_6810_(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        if (!state.m_60713_(newState.m_60734_())) {
            BlockEntity blockEntity = level.m_7702_(pos);
            if (blockEntity instanceof RadioBlockEntity) {
                RadioBlockEntity radio = (RadioBlockEntity)blockEntity;
                radio.stop();
            }
            super.m_6810_(state, level, pos, newState, isMoving);
        }
    }
}

