/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.beachparty.core.block;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.BedBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BedPart;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.satisfy.beachparty.core.util.BeachpartyUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BeachSunLounger
extends BedBlock {
    public static final EnumProperty<BedPart> PART = BlockStateProperties.f_61391_;
    public static final BooleanProperty DOWN = BooleanProperty.m_61465_((String)"down");
    public static final BooleanProperty OCCUPIED = BlockStateProperties.f_61445_;
    private static final Supplier<VoxelShape> bottomShapeSupplier = () -> {
        VoxelShape shape = Shapes.m_83040_();
        shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.0, (double)0.25, (double)0.0, (double)1.0, (double)0.375, (double)1.0));
        shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.0625, (double)0.36875, (double)0.0625, (double)1.0, (double)0.49375, (double)0.9375));
        shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.0625, (double)0.0, (double)0.0, (double)0.1875, (double)0.25, (double)0.125));
        shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.0625, (double)0.0, (double)0.875, (double)0.1875, (double)0.25, (double)1.0));
        return shape;
    };
    public static final Map<Direction, VoxelShape> BOTTOM_SHAPE = (Map)Util.m_137469_(new HashMap(), map -> {
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            map.put(direction, BeachpartyUtil.rotateShape(Direction.EAST, direction, bottomShapeSupplier.get()));
        }
    });
    private static final Supplier<VoxelShape> topShapeSupplier = () -> {
        VoxelShape shape = Shapes.m_83040_();
        shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.0, (double)0.25, (double)0.0, (double)0.3125, (double)0.375, (double)1.0));
        shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.0, (double)0.36875, (double)0.0625, (double)0.25, (double)0.49375, (double)0.9375));
        shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.1875, (double)0.0, (double)0.0, (double)0.3125, (double)0.25, (double)0.125));
        shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.1875, (double)0.0, (double)0.875, (double)0.3125, (double)0.25, (double)1.0));
        return shape;
    };
    public static final Map<Direction, VoxelShape> TOP_SHAPE = (Map)Util.m_137469_(new HashMap(), map -> {
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            map.put(direction, BeachpartyUtil.rotateShape(Direction.EAST, direction, topShapeSupplier.get()));
        }
    });
    private static final Supplier<VoxelShape> topShapeDownSupplier = () -> {
        VoxelShape shape = Shapes.m_83040_();
        shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.0, (double)0.25, (double)0.0, (double)0.375, (double)0.375, (double)1.0));
        shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.0, (double)0.36875, (double)0.0625, (double)0.25, (double)0.49375, (double)0.9375));
        shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.1875, (double)0.0, (double)0.0, (double)0.3125, (double)0.25, (double)0.125));
        shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.1875, (double)0.0, (double)0.875, (double)0.3125, (double)0.25, (double)1.0));
        shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.25, (double)0.36875, (double)0.0625, (double)0.9375, (double)0.49375, (double)0.9375));
        shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.375, (double)0.25, (double)0.0, (double)1.0, (double)0.375, (double)1.0));
        return shape;
    };
    public static final Map<Direction, VoxelShape> TOP_SHAPE_DOWN = (Map)Util.m_137469_(new HashMap(), map -> {
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            map.put(direction, BeachpartyUtil.rotateShape(Direction.EAST, direction, topShapeDownSupplier.get()));
        }
    });

    public BeachSunLounger(DyeColor dyeColor, BlockBehaviour.Properties properties) {
        super(dyeColor, properties.m_280606_());
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)f_54117_, (Comparable)Direction.NORTH)).m_61124_(PART, (Comparable)BedPart.FOOT)).m_61124_((Property)DOWN, (Comparable)Boolean.valueOf(false))).m_61124_((Property)OCCUPIED, (Comparable)Boolean.valueOf(false)));
    }

    private static Direction getDirectionTowardsOtherPart(BedPart part, Direction direction) {
        return part == BedPart.FOOT ? direction : direction.m_122424_();
    }

    public static Direction getOppositePartDirection(BlockState state) {
        Direction direction = (Direction)state.m_61143_((Property)f_54117_);
        return state.m_61143_(PART) == BedPart.HEAD ? direction.m_122424_() : direction;
    }

    @NotNull
    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        Direction direction = (Direction)state.m_61143_((Property)f_54117_);
        if (state.m_61143_(PART) == BedPart.HEAD) {
            return (Boolean)state.m_61143_((Property)DOWN) != false ? TOP_SHAPE_DOWN.get(direction) : TOP_SHAPE.get(direction);
        }
        return BOTTOM_SHAPE.get(direction);
    }

    @NotNull
    public BlockState m_7417_(BlockState state, Direction direction, BlockState neighborState, LevelAccessor world, BlockPos pos, BlockPos neighborPos) {
        if (direction == BeachSunLounger.getDirectionTowardsOtherPart((BedPart)state.m_61143_(PART), (Direction)state.m_61143_((Property)f_54117_))) {
            return neighborState.m_60713_((Block)this) && neighborState.m_61143_(PART) != state.m_61143_(PART) ? state : Blocks.f_50016_.m_49966_();
        }
        return super.m_7417_(state, direction, neighborState, world, pos, neighborPos);
    }

    public void m_5707_(Level world, BlockPos pos, BlockState state, Player player) {
        if (!world.f_46443_ && player.m_7500_()) {
            this.removeOtherPart(world, pos, state, player);
        }
        super.m_5707_(world, pos, state, player);
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext ctx) {
        Direction direction = ctx.m_8125_().m_122427_();
        BlockPos blockPos = ctx.m_8083_();
        BlockPos blockPos2 = blockPos.m_121945_(direction);
        Level world = ctx.m_43725_();
        return world.m_8055_(blockPos2).m_60629_(ctx) && world.m_6857_().m_61937_(blockPos2) ? (BlockState)this.m_49966_().m_61124_((Property)f_54117_, (Comparable)direction) : null;
    }

    public void m_6402_(Level world, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack itemStack) {
        super.m_6402_(world, pos, state, placer, itemStack);
        if (!world.f_46443_) {
            this.placeOtherPart(world, pos, state);
        }
    }

    private void placeOtherPart(Level world, BlockPos pos, BlockState state) {
        BlockPos blockPos = pos.m_121945_((Direction)state.m_61143_((Property)f_54117_));
        world.m_7731_(blockPos, (BlockState)state.m_61124_(PART, (Comparable)BedPart.HEAD), 3);
        world.m_6289_(pos, Blocks.f_50016_);
        state.m_60701_((LevelAccessor)world, pos, 3);
    }

    private void removeOtherPart(Level world, BlockPos pos, BlockState state, Player player) {
        BlockPos blockPos;
        BlockState blockState;
        BedPart bedPart = (BedPart)state.m_61143_(PART);
        if (bedPart == BedPart.FOOT && (blockState = world.m_8055_(blockPos = pos.m_121945_(BeachSunLounger.getDirectionTowardsOtherPart(bedPart, (Direction)state.m_61143_((Property)f_54117_))))).m_60713_((Block)this) && blockState.m_61143_(PART) == BedPart.HEAD) {
            world.m_7731_(blockPos, Blocks.f_50016_.m_49966_(), 35);
            if (player != null) {
                world.m_5898_(player, 2001, blockPos, Block.m_49956_((BlockState)blockState));
            }
        }
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{f_54117_, PART, DOWN, OCCUPIED});
    }

    public void m_142072_(Level level, BlockState state, BlockPos pos, Entity entity, float factor) {
        super.m_142072_(level, state, pos, entity, factor * 0.5f);
    }

    public void m_5548_(BlockGetter getter, Entity entity) {
        if (entity.m_20162_()) {
            super.m_5548_(getter, entity);
        } else {
            this.bounceUp(entity);
        }
    }

    private void bounceUp(Entity entity) {
        Vec3 deltaMovement = entity.m_20184_();
        if (deltaMovement.f_82480_ < 0.0) {
            double bounceFactor = entity instanceof LivingEntity ? 0.75 : 0.8;
            entity.m_20334_(deltaMovement.f_82479_, -deltaMovement.f_82480_ * 0.3300000262260437 * bounceFactor, deltaMovement.f_82481_);
        }
    }

    private boolean kickVillagerOutOfBed(Level level, BlockPos pos) {
        List villagers = level.m_6443_(Villager.class, new AABB(pos), LivingEntity::m_5803_);
        if (villagers.isEmpty()) {
            return false;
        }
        ((Villager)villagers.get(0)).m_5796_();
        return true;
    }

    @NotNull
    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }

    @NotNull
    public InteractionResult m_6227_(BlockState blockState, Level level, BlockPos blockPos, Player player, InteractionHand interactionHand, BlockHitResult blockHitResult) {
        if (level.f_46443_) {
            return InteractionResult.CONSUME;
        }
        if (blockState.m_61143_(PART) == BedPart.HEAD && player.m_6144_()) {
            level.m_7731_(blockPos, (BlockState)blockState.m_61124_((Property)DOWN, (Comparable)Boolean.valueOf((Boolean)blockState.m_61143_((Property)DOWN) == false)), 3);
            level.m_5594_(null, blockPos, SoundEvents.f_243699_, SoundSource.BLOCKS, 1.0f, 1.0f);
            return InteractionResult.SUCCESS;
        }
        if (blockState.m_61143_(PART) != BedPart.HEAD && !(blockState = level.m_8055_(blockPos = blockPos.m_121945_((Direction)blockState.m_61143_((Property)f_54117_)))).m_60713_((Block)this)) {
            return InteractionResult.CONSUME;
        }
        if (!((Boolean)blockState.m_61143_((Property)DOWN)).booleanValue()) {
            return InteractionResult.CONSUME;
        }
        if (!BeachSunLounger.m_49488_((Level)level)) {
            level.m_7471_(blockPos, false);
            BlockPos blockPos2 = blockPos.m_121945_(((Direction)blockState.m_61143_((Property)f_54117_)).m_122424_());
            if (level.m_8055_(blockPos2).m_60713_((Block)this)) {
                level.m_7471_(blockPos2, false);
            }
            Vec3 vec3 = blockPos.m_252807_();
            level.m_254951_(null, level.m_269111_().m_269488_(vec3), null, vec3, 5.0f, true, Level.ExplosionInteraction.BLOCK);
            return InteractionResult.SUCCESS;
        }
        if (((Boolean)blockState.m_61143_((Property)OCCUPIED)).booleanValue()) {
            if (!this.kickVillagerOutOfBed(level, blockPos)) {
                player.m_5661_((Component)Component.m_237115_((String)"block.minecraft.bed.occupied"), true);
            }
            return InteractionResult.SUCCESS;
        }
        BlockState finalBlockState = blockState;
        BlockPos finalBlockPos = blockPos;
        player.m_7720_(finalBlockPos).ifRight(success -> level.m_7731_(finalBlockPos, (BlockState)finalBlockState.m_61124_((Property)OCCUPIED, (Comparable)Boolean.valueOf(true)), 3)).ifLeft(bedSleepingProblem -> {
            if (bedSleepingProblem.m_36423_() != null) {
                player.m_5661_(bedSleepingProblem.m_36423_(), true);
            }
        });
        return InteractionResult.SUCCESS;
    }
}

