/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.beachparty.client.model;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.ListModel;
import net.minecraft.client.model.WaterPatchModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
public class FloatyBoatModel
extends ListModel<Boat>
implements WaterPatchModel {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(new ResourceLocation("beachparty", "floaty_boat"), "main");
    private static final String LEFT_PADDLE = "left_paddle";
    private static final String RIGHT_PADDLE = "right_paddle";
    private static final String WATER_PATCH = "water_patch";
    private static final String BOTTOM = "bottom";
    private static final String BACK = "back";
    private static final String FRONT = "front";
    private static final String RIGHT = "right";
    private static final String LEFT = "left";
    private final ModelPart leftPaddle;
    private final ModelPart rightPaddle;
    private final ModelPart waterPatch;
    private final ImmutableList<ModelPart> parts;

    public FloatyBoatModel(ModelPart modelPart) {
        this.leftPaddle = modelPart.m_171324_(LEFT_PADDLE);
        this.rightPaddle = modelPart.m_171324_(RIGHT_PADDLE);
        this.waterPatch = modelPart.m_171324_(WATER_PATCH);
        this.parts = this.createPartsBuilder(modelPart).build();
    }

    protected ImmutableList.Builder<ModelPart> createPartsBuilder(ModelPart modelPart) {
        ImmutableList.Builder builder = new ImmutableList.Builder();
        builder.add((Object[])new ModelPart[]{modelPart.m_171324_(BOTTOM), modelPart.m_171324_(BACK), modelPart.m_171324_(FRONT), modelPart.m_171324_(RIGHT), modelPart.m_171324_(LEFT), this.leftPaddle, this.rightPaddle});
        return builder;
    }

    public static void createChildren(PartDefinition partDefinition) {
        partDefinition.m_171599_(BOTTOM, CubeListBuilder.m_171558_().m_171514_(0, 0).m_171480_().m_171488_(-14.0f, -7.0f, -17.0f, 28.0f, 16.0f, 3.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171423_((float)0.0f, (float)6.0f, (float)0.0f, (float)1.5708f, (float)0.0f, (float)0.0f));
        partDefinition.m_171599_(FRONT, CubeListBuilder.m_171558_().m_171514_(0, 29).m_171480_().m_171488_(-8.0f, 14.0f, -3.0f, 14.0f, 6.0f, 4.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171423_((float)15.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)1.5708f, (float)0.0f));
        partDefinition.m_171599_(BACK, CubeListBuilder.m_171558_().m_171514_(0, 19).m_171480_().m_171488_(-6.0f, 14.0f, -3.0f, 14.0f, 6.0f, 4.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171423_((float)-15.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-1.5708f, (float)0.0f));
        partDefinition.m_171599_(RIGHT, CubeListBuilder.m_171558_().m_171514_(0, 39).m_171480_().m_171488_(-14.0f, 14.0f, -3.0f, 28.0f, 6.0f, 4.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)-9.0f, (float)0.0f, (float)-3.1416f, (float)0.0f));
        partDefinition.m_171599_(LEFT, CubeListBuilder.m_171558_().m_171514_(0, 49).m_171480_().m_171488_(-14.0f, 14.0f, -1.0f, 28.0f, 6.0f, 4.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)9.0f));
        partDefinition.m_171599_(LEFT_PADDLE, CubeListBuilder.m_171558_().m_171514_(62, 0).m_171481_(-1.0f, 0.0f, -5.0f, 2.0f, 2.0f, 18.0f).m_171481_(-1.001f, -3.0f, 8.0f, 1.0f, 6.0f, 7.0f), PartPose.m_171423_((float)3.0f, (float)-5.0f, (float)9.0f, (float)0.0f, (float)0.0f, (float)0.19634955f));
        partDefinition.m_171599_(RIGHT_PADDLE, CubeListBuilder.m_171558_().m_171514_(62, 0).m_171481_(-1.0f, 0.0f, -5.0f, 2.0f, 2.0f, 18.0f).m_171481_(0.001f, -3.0f, 8.0f, 1.0f, 6.0f, 7.0f), PartPose.m_171423_((float)3.0f, (float)-5.0f, (float)-9.0f, (float)0.0f, (float)((float)Math.PI), (float)0.19634955f));
        partDefinition.m_171599_(WATER_PATCH, CubeListBuilder.m_171558_().m_171514_(0, 0).m_171481_(-14.0f, -9.0f, -3.0f, 28.0f, 16.0f, 3.0f), PartPose.m_171423_((float)0.0f, (float)-3.0f, (float)1.0f, (float)1.5707964f, (float)0.0f, (float)0.0f));
    }

    public static LayerDefinition createBodyModel() {
        MeshDefinition meshDefinition = new MeshDefinition();
        PartDefinition partDefinition = meshDefinition.m_171576_();
        FloatyBoatModel.createChildren(partDefinition);
        return LayerDefinition.m_171565_((MeshDefinition)meshDefinition, (int)128, (int)64);
    }

    public void setupAnim(Boat boat, float f, float g, float h, float i, float j) {
        FloatyBoatModel.animatePaddle(boat, 0, this.leftPaddle, f);
        FloatyBoatModel.animatePaddle(boat, 1, this.rightPaddle, f);
    }

    @NotNull
    public ImmutableList<ModelPart> parts() {
        return this.parts;
    }

    @NotNull
    public ModelPart m_102282_() {
        return this.waterPatch;
    }

    public void m_7695_(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        poseStack.m_85836_();
        poseStack.m_252880_(0.0f, -1.1f, 0.0f);
        for (ModelPart part : this.parts) {
            if (part == this.leftPaddle || part == this.rightPaddle) continue;
            part.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        }
        poseStack.m_85849_();
        this.leftPaddle.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.rightPaddle.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
    }

    private static void animatePaddle(Boat boat, int i, ModelPart modelPart, float f) {
        float g = boat.m_38315_(i, f);
        modelPart.f_104203_ = Mth.m_144920_((float)-1.0471976f, (float)-0.2617994f, (float)((Mth.m_14031_((float)g) + 1.0f) / 2.0f));
        modelPart.f_104204_ = Mth.m_144920_((float)-0.7853982f, (float)0.7853982f, (float)((Mth.m_14031_((float)(g + 1.0f)) + 1.0f) / 2.0f));
        if (i == 1) {
            modelPart.f_104204_ = (float)Math.PI - modelPart.f_104204_;
        }
    }
}

