/*
 * Decompiled with CFR 0.152.
 */
package com.berksire.applewood.core.registry;

import com.berksire.applewood.core.block.AppleWoodBigBottleStorageBlock;
import com.berksire.applewood.core.block.AppleWoodFourBottleStorageBlock;
import com.berksire.applewood.core.block.AppleWoodHangingSignBlock;
import com.berksire.applewood.core.block.AppleWoodNineBottleStorageBlock;
import com.berksire.applewood.core.block.AppleWoodShelfBlock;
import com.berksire.applewood.core.block.AppleWoodStandingSignBlock;
import com.berksire.applewood.core.block.AppleWoodWallHangingSignBlock;
import com.berksire.applewood.core.block.AppleWoodWallSignBlock;
import com.berksire.applewood.core.entity.AppleWoodBoatEntity;
import com.berksire.applewood.core.item.AppleWoodBoatItem;
import com.berksire.applewood.core.util.AppleWoodIdentifier;
import com.berksire.applewood.core.util.AppleWoodWoodType;
import dev.architectury.registry.registries.DeferredRegister;
import dev.architectury.registry.registries.Registrar;
import dev.architectury.registry.registries.RegistrySupplier;
import java.util.function.Supplier;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.flag.FeatureFlag;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.item.HangingSignItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.SignItem;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ButtonBlock;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.FenceBlock;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.PressurePlateBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.properties.BlockSetType;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraft.world.level.block.state.properties.WoodType;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;
import net.satisfy.vinery.core.block.BigTableBlock;
import net.satisfy.vinery.core.block.CabinetBlock;
import net.satisfy.vinery.core.block.ChairBlock;
import net.satisfy.vinery.core.block.LatticeBlock;
import net.satisfy.vinery.core.block.TableBlock;
import net.satisfy.vinery.core.registry.SoundEventRegistry;
import net.satisfy.vinery.core.util.GeneralUtil;

public class ObjectRegistry {
    public static final DeferredRegister<Item> ITEMS = DeferredRegister.create((String)"applewood", (ResourceKey)Registries.f_256913_);
    public static final Registrar<Item> ITEM_REGISTRAR = ITEMS.getRegistrar();
    public static final DeferredRegister<Block> BLOCKS = DeferredRegister.create((String)"applewood", (ResourceKey)Registries.f_256747_);
    public static final Registrar<Block> BLOCK_REGISTRAR = BLOCKS.getRegistrar();
    public static final RegistrySupplier<Block> APPLE_CHAIR = ObjectRegistry.registerWithItem("apple_chair", () -> new ChairBlock(BlockBehaviour.Properties.m_284310_().m_60913_(2.0f, 3.0f).m_60918_(SoundType.f_56736_)));
    public static final RegistrySupplier<Block> APPLE_TABLE = ObjectRegistry.registerWithItem("apple_table", () -> new TableBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50705_)));
    public static final RegistrySupplier<Block> APPLE_CABINET = ObjectRegistry.registerWithItem("apple_cabinet", () -> new CabinetBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50705_).m_60913_(2.0f, 3.0f).m_60918_(SoundType.f_56736_), (SoundEvent)SoundEventRegistry.CABINET_OPEN.get(), (SoundEvent)SoundEventRegistry.CABINET_CLOSE.get()));
    public static final RegistrySupplier<Block> APPLE_DRAWER = ObjectRegistry.registerWithItem("apple_drawer", () -> new CabinetBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50705_).m_60913_(2.0f, 3.0f).m_60918_(SoundType.f_56736_), (SoundEvent)SoundEventRegistry.DRAWER_OPEN.get(), (SoundEvent)SoundEventRegistry.DRAWER_CLOSE.get()));
    public static final RegistrySupplier<Block> APPLE_WINE_RACK_BIG = ObjectRegistry.registerWithItem("apple_wine_rack_big", () -> new AppleWoodNineBottleStorageBlock(BlockBehaviour.Properties.m_284310_().m_60913_(2.0f, 3.0f).m_60918_(SoundType.f_56736_).m_60955_()));
    public static final RegistrySupplier<Block> APPLE_WINE_RACK_SMALL = ObjectRegistry.registerWithItem("apple_wine_rack_small", () -> new AppleWoodFourBottleStorageBlock(BlockBehaviour.Properties.m_284310_().m_60913_(2.0f, 3.0f).m_60918_(SoundType.f_56736_).m_60955_()));
    public static final RegistrySupplier<Block> APPLE_WINE_RACK_MID = ObjectRegistry.registerWithItem("apple_wine_rack_mid", () -> new AppleWoodBigBottleStorageBlock(BlockBehaviour.Properties.m_284310_().m_60913_(2.0f, 3.0f).m_60918_(SoundType.f_56736_).m_60955_()));
    public static final RegistrySupplier<Block> STRIPPED_APPLE_LOG = ObjectRegistry.registerWithItem("stripped_apple_log", GeneralUtil::logBlock);
    public static final RegistrySupplier<Block> STRIPPED_APPLE_WOOD = ObjectRegistry.registerWithItem("stripped_apple_wood", GeneralUtil::logBlock);
    public static final RegistrySupplier<Block> APPLE_LOG = ObjectRegistry.registerWithItem("apple_log", GeneralUtil::logBlock);
    public static final RegistrySupplier<Block> APPLE_WOOD = ObjectRegistry.registerWithItem("apple_wood", GeneralUtil::logBlock);
    public static final RegistrySupplier<Block> APPLE_BEAM = ObjectRegistry.registerWithItem("apple_beam", GeneralUtil::logBlock);
    public static final RegistrySupplier<Block> APPLE_PLANKS = ObjectRegistry.registerWithItem("apple_planks", () -> new Block(BlockBehaviour.Properties.m_284310_().m_60913_(2.0f, 3.0f).m_284180_(MapColor.f_283895_).m_60918_(SoundType.f_56736_).m_280658_(NoteBlockInstrument.BIT)));
    public static final RegistrySupplier<Block> APPLE_STAIRS = ObjectRegistry.registerWithItem("apple_stairs", () -> new StairBlock(((Block)APPLE_PLANKS.get()).m_49966_(), BlockBehaviour.Properties.m_60926_((BlockBehaviour)((BlockBehaviour)APPLE_PLANKS.get()))));
    public static final RegistrySupplier<Block> APPLE_SLAB = ObjectRegistry.registerWithItem("apple_slab", () -> new SlabBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)((BlockBehaviour)APPLE_PLANKS.get()))));
    public static final RegistrySupplier<Block> APPLE_FENCE = ObjectRegistry.registerWithItem("apple_fence", () -> new FenceBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50132_)));
    public static final RegistrySupplier<Block> APPLE_FENCE_GATE = ObjectRegistry.registerWithItem("apple_fence_gate", () -> new FenceGateBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50132_), WoodType.f_271224_));
    public static final RegistrySupplier<Block> APPLE_BUTTON = ObjectRegistry.registerWithItem("apple_button", () -> ObjectRegistry.woodenButton(FeatureFlags.f_244571_));
    public static final RegistrySupplier<Block> APPLE_PRESSURE_PLATE = ObjectRegistry.registerWithItem("apple_pressure_plate", () -> new PressurePlateBlock(PressurePlateBlock.Sensitivity.EVERYTHING, BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50167_), BlockSetType.f_271401_));
    public static final RegistrySupplier<Block> APPLE_DOOR = ObjectRegistry.registerWithItem("apple_door", () -> new DoorBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50154_), BlockSetType.f_271401_));
    public static final RegistrySupplier<Block> APPLE_TRAPDOOR = ObjectRegistry.registerWithItem("apple_trapdoor", () -> new TrapDoorBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50216_), BlockSetType.f_271401_));
    public static final RegistrySupplier<Block> APPLE_LATTICE = ObjectRegistry.registerWithItem("apple_lattice", () -> new LatticeBlock(BlockBehaviour.Properties.m_284310_().m_60913_(2.0f, 3.0f).m_60918_(Blocks.f_50743_.m_49962_(Blocks.f_50743_.m_49966_())).m_60955_()));
    public static final RegistrySupplier<Block> APPLE_BIG_TABLE = ObjectRegistry.registerWithItem("apple_big_table", () -> new BigTableBlock(BlockBehaviour.Properties.m_284310_().m_60913_(2.0f, 2.0f).m_278166_(PushReaction.IGNORE)));
    public static final RegistrySupplier<Block> APPLE_SHELF = ObjectRegistry.registerWithItem("apple_shelf", () -> new AppleWoodShelfBlock(BlockBehaviour.Properties.m_284310_().m_60913_(2.0f, 3.0f).m_60918_(SoundType.f_56736_).m_60955_()));
    public static final RegistrySupplier<Block> APPLE_SIGN = ObjectRegistry.registerWithoutItem("apple_sign", () -> new AppleWoodStandingSignBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50095_), AppleWoodWoodType.APPLE));
    public static final RegistrySupplier<Block> APPLE_WALL_SIGN = ObjectRegistry.registerWithoutItem("apple_wall_sign", () -> new AppleWoodWallSignBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50158_), AppleWoodWoodType.APPLE));
    public static final RegistrySupplier<Block> APPLE_HANGING_SIGN = ObjectRegistry.registerWithoutItem("apple_hanging_sign", () -> new AppleWoodHangingSignBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_244319_), AppleWoodWoodType.APPLE));
    public static final RegistrySupplier<Block> APPLE_WALL_HANGING_SIGN = ObjectRegistry.registerWithoutItem("apple_wall_hanging_sign", () -> new AppleWoodWallHangingSignBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_244093_), AppleWoodWoodType.APPLE));
    public static final RegistrySupplier<Item> APPLE_SIGN_ITEM = ITEMS.register("apple_sign", () -> new SignItem(new Item.Properties().m_41487_(16), (Block)APPLE_SIGN.get(), (Block)APPLE_WALL_SIGN.get()));
    public static final RegistrySupplier<Item> APPLE_HANGING_SIGN_ITEM = ITEMS.register("apple_hanging_sign", () -> new HangingSignItem((Block)APPLE_HANGING_SIGN.get(), (Block)APPLE_WALL_HANGING_SIGN.get(), new Item.Properties().m_41487_(16)));
    public static final RegistrySupplier<Item> APPLE_BOAT = ITEMS.register("apple_boat", () -> new AppleWoodBoatItem(false, AppleWoodBoatEntity.Type.APPLE, new Item.Properties()));
    public static final RegistrySupplier<Item> APPLE_CHEST_BOAT = ITEMS.register("apple_chest_boat", () -> new AppleWoodBoatItem(true, AppleWoodBoatEntity.Type.APPLE, new Item.Properties()));

    public static void init() {
        BLOCKS.register();
        ITEMS.register();
    }

    private static ButtonBlock woodenButton(FeatureFlag ... featureFlags) {
        BlockBehaviour.Properties properties = BlockBehaviour.Properties.m_284310_().m_60910_().m_60978_(0.5f).m_278166_(PushReaction.DESTROY);
        if (featureFlags.length > 0) {
            properties = properties.m_246843_(featureFlags);
        }
        return new ButtonBlock(properties, BlockSetType.f_271401_, 30, true);
    }

    public static <T extends Block> RegistrySupplier<T> registerWithItem(String name, Supplier<T> block) {
        return GeneralUtil.registerWithItem(BLOCKS, BLOCK_REGISTRAR, ITEMS, ITEM_REGISTRAR, (ResourceLocation)new AppleWoodIdentifier(name), block);
    }

    public static <T extends Block> RegistrySupplier<T> registerWithoutItem(String path, Supplier<T> block) {
        return GeneralUtil.registerWithoutItem(BLOCKS, BLOCK_REGISTRAR, (ResourceLocation)new AppleWoodIdentifier(path), block);
    }
}

