/*
 * Decompiled with CFR 0.152.
 */
package com.berksire.applewood.core.registry;

import com.berksire.applewood.core.block.entity.AppleWoodHangingSignBlockEntity;
import com.berksire.applewood.core.block.entity.AppleWoodSignBlockEntity;
import com.berksire.applewood.core.block.entity.AppleWoodStorageBlockEntity;
import com.berksire.applewood.core.entity.AppleWoodBoatEntity;
import com.berksire.applewood.core.entity.AppleWoodChestBoatEntity;
import com.berksire.applewood.core.registry.ObjectRegistry;
import com.berksire.applewood.core.registry.StorageTypeRegistry;
import com.berksire.applewood.core.util.AppleWoodIdentifier;
import com.berksire.applewood.platform.PlatformHelper;
import dev.architectury.registry.registries.DeferredRegister;
import dev.architectury.registry.registries.RegistrySupplier;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;

public class EntityTypeRegistry {
    public static final DeferredRegister<BlockEntityType<?>> BLOCK_ENTITY_TYPES = DeferredRegister.create((String)"applewood", (ResourceKey)Registries.f_256922_);
    private static final DeferredRegister<EntityType<?>> ENTITY_TYPES = DeferredRegister.create((String)"applewood", (ResourceKey)Registries.f_256939_);
    public static final RegistrySupplier<BlockEntityType<AppleWoodStorageBlockEntity>> STORAGE_ENTITY = EntityTypeRegistry.registerBlockEntity("storage", () -> {
        Set<Block> blocks = StorageTypeRegistry.registerBlocks(new HashSet<Block>());
        return BlockEntityType.Builder.m_155273_(AppleWoodStorageBlockEntity::new, (Block[])blocks.toArray(new Block[0])).m_58966_(null);
    });
    public static final RegistrySupplier<BlockEntityType<AppleWoodSignBlockEntity>> APPLE_SIGN = EntityTypeRegistry.registerBlockEntity("apple_sign", () -> BlockEntityType.Builder.m_155273_(AppleWoodSignBlockEntity::new, (Block[])new Block[]{(Block)ObjectRegistry.APPLE_SIGN.get(), (Block)ObjectRegistry.APPLE_WALL_SIGN.get()}).m_58966_(null));
    public static final RegistrySupplier<BlockEntityType<AppleWoodHangingSignBlockEntity>> APPLE_HANGING_SIGN = EntityTypeRegistry.registerBlockEntity("apple_hanging_sign", () -> BlockEntityType.Builder.m_155273_(AppleWoodHangingSignBlockEntity::new, (Block[])new Block[]{(Block)ObjectRegistry.APPLE_HANGING_SIGN.get(), (Block)ObjectRegistry.APPLE_WALL_HANGING_SIGN.get()}).m_58966_(null));
    public static final Supplier<EntityType<AppleWoodBoatEntity>> APPLE_BOAT = PlatformHelper.registerBoatType("apple_boat", AppleWoodBoatEntity::new, MobCategory.MISC, 1.375f, 0.5625f, 10);
    public static final Supplier<EntityType<AppleWoodChestBoatEntity>> APPLE_CHEST_BOAT = PlatformHelper.registerBoatType("apple_chest_boat", AppleWoodChestBoatEntity::new, MobCategory.MISC, 1.375f, 0.5625f, 10);

    private static <T extends BlockEntityType<?>> RegistrySupplier<T> registerBlockEntity(String path, Supplier<T> type) {
        return BLOCK_ENTITY_TYPES.register((ResourceLocation)new AppleWoodIdentifier(path), type);
    }

    public static void init() {
        BLOCK_ENTITY_TYPES.register();
        ENTITY_TYPES.register();
    }
}

