/*
 * Decompiled with CFR 0.152.
 */
package com.berksire.applewood.core.block.entity;

import com.berksire.applewood.core.registry.EntityTypeRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.satisfy.vinery.core.util.GeneralUtil;
import org.jetbrains.annotations.NotNull;

public class AppleWoodStorageBlockEntity
extends BlockEntity {
    private int size;
    private NonNullList<ItemStack> inventory;

    public AppleWoodStorageBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)EntityTypeRegistry.STORAGE_ENTITY.get(), pos, state);
    }

    public AppleWoodStorageBlockEntity(BlockPos pos, BlockState state, int size) {
        super((BlockEntityType)EntityTypeRegistry.STORAGE_ENTITY.get(), pos, state);
        this.size = size;
        this.inventory = NonNullList.m_122780_((int)this.size, (Object)ItemStack.f_41583_);
    }

    public ItemStack removeStack(int slot) {
        ItemStack stack = (ItemStack)this.inventory.set(slot, (Object)ItemStack.f_41583_);
        this.m_6596_();
        return stack;
    }

    public void setStack(int slot, ItemStack stack) {
        this.inventory.set(slot, (Object)stack);
        this.m_6596_();
    }

    public void m_6596_() {
        if (this.f_58857_ != null && !this.f_58857_.m_5776_()) {
            ClientboundBlockEntityDataPacket updatePacket = this.getUpdatePacket();
            for (ServerPlayer player : GeneralUtil.tracking((ServerLevel)((ServerLevel)this.f_58857_), (BlockPos)this.m_58899_())) {
                player.f_8906_.m_9829_((Packet)updatePacket);
            }
        }
        super.m_6596_();
    }

    public void m_142466_(CompoundTag nbt) {
        super.m_142466_(nbt);
        this.size = nbt.m_128451_("size");
        this.inventory = NonNullList.m_122780_((int)this.size, (Object)ItemStack.f_41583_);
        ContainerHelper.m_18980_((CompoundTag)nbt, this.inventory);
    }

    protected void m_183515_(CompoundTag nbt) {
        ContainerHelper.m_18973_((CompoundTag)nbt, this.inventory);
        nbt.m_128405_("size", this.size);
        super.m_183515_(nbt);
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    @NotNull
    public CompoundTag m_5995_() {
        return this.m_187482_();
    }

    public void setInventory(NonNullList<ItemStack> inventory) {
        for (int i = 0; i < inventory.size(); ++i) {
            this.inventory.set(i, (Object)((ItemStack)inventory.get(i)));
        }
    }

    public NonNullList<ItemStack> getInventory() {
        return this.inventory;
    }
}

