/*
 * Decompiled with CFR 0.152.
 */
package com.berksire.applewood.client.render.block.storage;

import com.berksire.applewood.client.render.block.storage.AppleWoodStorageTypeRenderer;
import com.berksire.applewood.core.block.AppleWoodStorageBlock;
import com.berksire.applewood.core.block.entity.AppleWoodStorageBlockEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.util.HashMap;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class AppleWoodStorageBlockEntityRenderer
implements BlockEntityRenderer<AppleWoodStorageBlockEntity> {
    private static final HashMap<ResourceLocation, AppleWoodStorageTypeRenderer> STORAGE_TYPES = new HashMap();

    public static void registerStorageType(ResourceLocation name, AppleWoodStorageTypeRenderer renderer) {
        STORAGE_TYPES.put(name, renderer);
    }

    public static AppleWoodStorageTypeRenderer getRendererForId(ResourceLocation name) {
        return STORAGE_TYPES.get(name);
    }

    public void render(AppleWoodStorageBlockEntity entity, float tickDelta, PoseStack matrices, MultiBufferSource vertexConsumers, int light, int overlay) {
        if (entity == null || !entity.m_58898_()) {
            return;
        }
        BlockState state = entity.m_58900_();
        Block block = state.m_60734_();
        if (block instanceof AppleWoodStorageBlock) {
            AppleWoodStorageBlock sB = (AppleWoodStorageBlock)block;
            NonNullList<ItemStack> itemStacks = entity.getInventory();
            matrices.m_85836_();
            AppleWoodStorageBlockEntityRenderer.applyBlockAngle(matrices, state, 180.0f);
            ResourceLocation type = sB.type();
            AppleWoodStorageTypeRenderer renderer = AppleWoodStorageBlockEntityRenderer.getRendererForId(type);
            if (renderer != null) {
                renderer.render(entity, matrices, vertexConsumers, itemStacks);
            }
            matrices.m_85849_();
        }
    }

    public static void applyBlockAngle(PoseStack matrices, BlockState state, float angleOffset) {
        float angle = ((Direction)state.m_61143_((Property)AppleWoodStorageBlock.f_54117_)).m_122435_();
        matrices.m_85837_(0.5, 0.0, 0.5);
        matrices.m_252781_(Axis.f_252436_.m_252977_(angleOffset - angle));
    }
}

