/*
 * Decompiled with CFR 0.152.
 */
package com.berksire.applewood.client;

import com.berksire.applewood.client.render.block.AppleWoodHangingSignRenderer;
import com.berksire.applewood.client.render.block.AppleWoodSignRenderer;
import com.berksire.applewood.client.render.block.storage.AppleWoodBigBottleRenderer;
import com.berksire.applewood.client.render.block.storage.AppleWoodFourBottleRenderer;
import com.berksire.applewood.client.render.block.storage.AppleWoodNineBottleRenderer;
import com.berksire.applewood.client.render.block.storage.AppleWoodShelfRenderer;
import com.berksire.applewood.client.render.block.storage.AppleWoodStorageBlockEntityRenderer;
import com.berksire.applewood.client.render.block.storage.AppleWoodStorageTypeRenderer;
import com.berksire.applewood.client.render.entity.AppleWoodBoatRenderer;
import com.berksire.applewood.core.registry.EntityTypeRegistry;
import com.berksire.applewood.core.registry.ObjectRegistry;
import com.berksire.applewood.core.registry.StorageTypeRegistry;
import dev.architectury.registry.client.level.entity.EntityRendererRegistry;
import dev.architectury.registry.client.rendering.BlockEntityRendererRegistry;
import dev.architectury.registry.client.rendering.RenderTypeRegistry;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class AppleWoodClient {
    public static void onInitializeClient() {
        RenderTypeRegistry.register((RenderType)RenderType.m_110463_(), (Block[])new Block[]{(Block)ObjectRegistry.APPLE_WINE_RACK_BIG.get(), (Block)ObjectRegistry.APPLE_LATTICE.get(), (Block)ObjectRegistry.APPLE_CHAIR.get(), (Block)ObjectRegistry.APPLE_TABLE.get(), (Block)ObjectRegistry.APPLE_WINE_RACK_MID.get()});
        BlockEntityRendererRegistry.register((BlockEntityType)((BlockEntityType)EntityTypeRegistry.STORAGE_ENTITY.get()), context -> new AppleWoodStorageBlockEntityRenderer());
        BlockEntityRendererRegistry.register((BlockEntityType)((BlockEntityType)EntityTypeRegistry.APPLE_SIGN.get()), AppleWoodSignRenderer::new);
        BlockEntityRendererRegistry.register((BlockEntityType)((BlockEntityType)EntityTypeRegistry.APPLE_HANGING_SIGN.get()), AppleWoodHangingSignRenderer::new);
        AppleWoodClient.registerNetherStorageType();
    }

    public static void preInitClient() {
        AppleWoodClient.registerEntityRenderers();
    }

    public static void registerNetherStorageTypes(ResourceLocation location, AppleWoodStorageTypeRenderer renderer) {
        AppleWoodStorageBlockEntityRenderer.registerStorageType(location, renderer);
    }

    public static void registerNetherStorageType() {
        AppleWoodClient.registerNetherStorageTypes(StorageTypeRegistry.BIG_BOTTLE, new AppleWoodBigBottleRenderer());
        AppleWoodClient.registerNetherStorageTypes(StorageTypeRegistry.FOUR_BOTTLE, new AppleWoodFourBottleRenderer());
        AppleWoodClient.registerNetherStorageTypes(StorageTypeRegistry.NINE_BOTTLE, new AppleWoodNineBottleRenderer());
        AppleWoodClient.registerNetherStorageTypes(StorageTypeRegistry.SHELF, new AppleWoodShelfRenderer());
    }

    public static void registerEntityRenderers() {
        EntityRendererRegistry.register(EntityTypeRegistry.APPLE_BOAT, context -> new AppleWoodBoatRenderer(context, false));
        EntityRendererRegistry.register(EntityTypeRegistry.APPLE_CHEST_BOAT, context -> new AppleWoodBoatRenderer(context, true));
    }
}

