/*
 * Decompiled with CFR 0.152.
 */
package com.github.ysbbbbbb.kaleidoscopedoll.network.message;

import com.github.ysbbbbbb.kaleidoscopedoll.entity.DollEntity;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.network.NetworkEvent;
import org.joml.Vector2f;
import org.joml.Vector3f;

public class DollTweakersMessage {
    private final int entityId;
    private final Vector3f scale;
    private final Vector3f translation;
    private final Vector2f rotation;

    public DollTweakersMessage(int entityId, Vector3f scale, Vector3f translation, Vector2f rotation) {
        this.entityId = entityId;
        this.scale = scale;
        this.translation = translation;
        this.rotation = rotation;
        DollTweakersMessage.limitValues(this);
    }

    public static void limitValues(DollTweakersMessage message) {
        DollTweakersMessage.limitVector3f(message.scale, 0.1f, 10.0f);
        DollTweakersMessage.limitVector3f(message.translation, -5.0f, 5.0f);
        message.rotation.x = Math.max(-90.0f, Math.min(90.0f, message.rotation.x));
        message.rotation.y = (message.rotation.y % 360.0f + 360.0f) % 360.0f;
    }

    private static void limitVector3f(Vector3f vec, float min, float max) {
        vec.x = Math.max(min, Math.min(max, vec.x));
        vec.y = Math.max(min, Math.min(max, vec.y));
        vec.z = Math.max(min, Math.min(max, vec.z));
    }

    public static void encode(DollTweakersMessage message, FriendlyByteBuf buf) {
        buf.m_130130_(message.entityId);
        buf.m_269582_(message.scale);
        buf.m_269582_(message.translation);
        buf.writeFloat(message.rotation.x);
        buf.writeFloat(message.rotation.y);
    }

    public static DollTweakersMessage decode(FriendlyByteBuf buf) {
        int entityId = buf.m_130242_();
        Vector3f scale = buf.m_269394_();
        Vector3f translation = buf.m_269394_();
        float rotX = buf.readFloat();
        float rotY = buf.readFloat();
        Vector2f rotation = new Vector2f(rotX, rotY);
        return new DollTweakersMessage(entityId, scale, translation, rotation);
    }

    public static void handle(DollTweakersMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        if (context.getDirection().getReceptionSide().isServer()) {
            context.enqueueWork(() -> {
                Entity patt2591$temp;
                ServerPlayer player = context.getSender();
                if (player != null && (patt2591$temp = player.m_9236_().m_6815_(message.entityId)) instanceof DollEntity) {
                    DollEntity dollEntity = (DollEntity)patt2591$temp;
                    DollTweakersMessage.limitValues(message);
                    dollEntity.setDisplayScale(message.scale);
                    dollEntity.setDisplayTranslation(message.translation);
                    dollEntity.m_7678_(dollEntity.m_20185_(), dollEntity.m_20186_(), dollEntity.m_20189_(), message.rotation.y, message.rotation.x);
                }
            });
        }
        context.setPacketHandled(true);
    }
}

