/*
 * Decompiled with CFR 0.152.
 */
package com.github.ysbbbbbb.kaleidoscopedoll.item.crafting;

import com.github.ysbbbbbb.kaleidoscopedoll.datagen.TagItem;
import com.github.ysbbbbbb.kaleidoscopedoll.init.ModRecipes;
import com.github.ysbbbbbb.kaleidoscopedoll.item.DollEntityItem;
import com.github.ysbbbbbb.kaleidoscopedoll.item.DollItem;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;

public class DollEntityCraftingRecipe
extends CustomRecipe {
    public DollEntityCraftingRecipe(ResourceLocation id, CraftingBookCategory category) {
        super(id, category);
    }

    public boolean matches(CraftingContainer container, Level level) {
        boolean hasDollItem = false;
        boolean hasBlockToEntityItem = false;
        int itemCount = 0;
        for (int i = 0; i < container.m_6643_(); ++i) {
            ItemStack stack = container.m_8020_(i);
            if (stack.m_41619_()) continue;
            ++itemCount;
            if (stack.m_41720_() instanceof DollItem) {
                hasDollItem = true;
                continue;
            }
            if (stack.m_204117_(TagItem.BLOCK_DOLLS_TO_ENTITY_ITEM)) {
                hasBlockToEntityItem = true;
                continue;
            }
            return false;
        }
        return itemCount == 2 && hasDollItem && hasBlockToEntityItem;
    }

    public ItemStack assemble(CraftingContainer container, RegistryAccess registryAccess) {
        ItemStack dollItemStack = ItemStack.f_41583_;
        for (int i = 0; i < container.m_6643_(); ++i) {
            ItemStack stack = container.m_8020_(i);
            if (!(stack.m_41720_() instanceof DollItem)) continue;
            dollItemStack = stack;
            break;
        }
        if (dollItemStack.m_41619_()) {
            return ItemStack.f_41583_;
        }
        DollItem dollItem = (DollItem)dollItemStack.m_41720_();
        return DollEntityItem.createItemWithBlockState(dollItem.m_40614_().m_49966_());
    }

    public boolean m_8004_(int width, int height) {
        return width >= 2 && height >= 2;
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)ModRecipes.DOLL_ENTITY_CRAFTING.get();
    }
}

