/*
 * Decompiled with CFR 0.152.
 */
package com.github.ysbbbbbb.kaleidoscopedoll.client.render;

import com.github.ysbbbbbb.kaleidoscopedoll.entity.DollEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.model.data.ModelData;
import org.joml.Vector3f;

public class DollEntityRender
extends EntityRenderer<DollEntity> {
    private static final ResourceLocation EMPTY = new ResourceLocation("minecraft", "textures/misc/empty.png");

    public DollEntityRender(EntityRendererProvider.Context context) {
        super(context);
    }

    public void render(DollEntity dollEntity, float entityYaw, float partialTick, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight) {
        BlockState blockState = dollEntity.getDisplayBlockState();
        if (blockState == null || blockState.m_60795_()) {
            return;
        }
        poseStack.m_85836_();
        Vector3f translation = dollEntity.getDisplayTranslation();
        poseStack.m_252880_(translation.x, translation.y, translation.z);
        Entity vehicle = dollEntity.m_20202_();
        if (vehicle != null) {
            float vehicleYaw = Mth.m_14179_((float)partialTick, (float)vehicle.f_19859_, (float)vehicle.m_146908_());
            poseStack.m_252781_(Axis.f_252436_.m_252977_(-vehicleYaw));
        } else {
            entityYaw = Mth.m_14179_((float)partialTick, (float)dollEntity.f_19859_, (float)dollEntity.m_146908_());
            poseStack.m_252781_(Axis.f_252436_.m_252977_(-entityYaw));
        }
        float pitchRadians = Mth.m_14179_((float)partialTick, (float)dollEntity.f_19860_, (float)dollEntity.m_146909_());
        poseStack.m_252781_(Axis.f_252529_.m_252977_(pitchRadians));
        Vector3f scale = dollEntity.getDisplayScale();
        poseStack.m_85841_(scale.x, scale.y, scale.z);
        long time = dollEntity.getBounceTime() - System.currentTimeMillis();
        if (time > 0L) {
            float dampingFactor = 0.6f;
            float frequency = 6.0f;
            float bounceStrength = 0.6f;
            float bounceProgress = 1.0f - (float)time / 500.0f;
            float dampedAmplitude = (float)Math.exp(-dampingFactor * bounceProgress * 8.0f);
            float compressionIntensity = dampedAmplitude * bounceStrength;
            float groundContact = (float)Math.max(0.0, -Math.sin((double)(bounceProgress * frequency) * Math.PI));
            float scaleY = 1.0f - groundContact * compressionIntensity;
            float scaleXZ = 1.0f + groundContact * compressionIntensity;
            poseStack.m_85841_(scaleXZ, scaleY, scaleXZ);
        }
        poseStack.m_85837_(-0.5, 0.0, -0.5);
        BlockRenderDispatcher blockRenderer = Minecraft.m_91087_().m_91289_();
        Level level = dollEntity.m_9236_();
        VertexConsumer buffer = bufferSource.m_6299_(RenderType.m_110463_());
        blockRenderer.renderBatched(blockState, dollEntity.m_20183_(), (BlockAndTintGetter)level, poseStack, buffer, false, level.f_46441_, ModelData.EMPTY, RenderType.m_110463_());
        poseStack.m_85849_();
        super.m_7392_((Entity)dollEntity, entityYaw, partialTick, poseStack, bufferSource, packedLight);
    }

    public ResourceLocation getTextureLocation(DollEntity dollEntity) {
        return EMPTY;
    }
}

