/*
 * Decompiled with CFR 0.152.
 */
package com.github.ysbbbbbb.kaleidoscopedoll.client.gui;

import com.github.ysbbbbbb.kaleidoscopedoll.client.gui.DollButton;
import com.github.ysbbbbbb.kaleidoscopedoll.datagen.TagItem;
import com.github.ysbbbbbb.kaleidoscopedoll.event.ModRegisterEvent;
import com.github.ysbbbbbb.kaleidoscopedoll.inventory.ComputerMenu;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.tags.ITag;
import net.minecraftforge.registries.tags.ITagManager;
import org.apache.commons.lang3.StringUtils;

public class ComputerMenuScreen
extends AbstractContainerScreen<ComputerMenu> {
    private static final ResourceLocation BG = new ResourceLocation("kaleidoscope_doll", "textures/gui/computer.png");
    private static final int MAX_DOLLS_PER_PAGE = 32;
    private List<Item> dolls = Lists.newArrayList();
    private int currentPage = 0;
    private float scrollOffs;
    private boolean scrolling;
    private EditBox searchField;

    public ComputerMenuScreen(ComputerMenu screenContainer, Inventory inv, Component titleIn) {
        super((AbstractContainerMenu)screenContainer, inv, titleIn);
        this.f_97727_ = 208;
        this.getDolls();
    }

    private void getDolls() {
        ITagManager tags = ForgeRegistries.ITEMS.tags();
        if (tags == null) {
            return;
        }
        this.dolls.addAll(tags.getTag(TagItem.PLAYER_DOLLS).stream().toList());
    }

    protected void m_7856_() {
        super.m_7856_();
        this.m_169413_();
        this.initSearch();
        this.initDollButtons();
    }

    private void initDollButtons() {
        ITagManager tags = ForgeRegistries.ITEMS.tags();
        if (tags == null) {
            return;
        }
        ITag tag = tags.getTag(TagItem.PLAYER_DOLLS);
        String searchText = this.searchField.m_94155_().toLowerCase(Locale.ENGLISH);
        this.dolls.clear();
        if (StringUtils.isEmpty((CharSequence)searchText)) {
            this.dolls.addAll(tag.stream().toList());
        } else {
            this.dolls.addAll(tag.stream().filter(item -> this.doSearch((Item)item, searchText)).toList());
        }
        int start = this.currentPage * 32;
        int end = Math.min(start + 32, this.dolls.size());
        List<Item> dollsToShow = this.dolls.subList(start, end);
        int xPos = this.f_97735_ + 7;
        int yPos = this.f_97736_ + 17;
        int xOffset = 18;
        int yOffset = 18;
        for (int i = 0; i < dollsToShow.size(); ++i) {
            Item item2 = dollsToShow.get(i);
            int x = xPos + i % 8 * xOffset;
            int y = yPos + i / 8 * yOffset;
            this.m_142416_((GuiEventListener)new DollButton(x, y, item2.m_7968_(), button -> {
                button.m_93692_(!button.m_93696_());
                if (this.f_96541_ == null || this.f_96541_.f_91072_ == null) {
                    return;
                }
                this.f_96541_.f_91072_.m_105208_(((ComputerMenu)this.f_97732_).f_38840_, Item.m_41393_((Item)item2));
            }));
        }
    }

    private boolean doSearch(Item item, String searchText) {
        ResourceLocation id = Objects.requireNonNull(ForgeRegistries.ITEMS.getKey((Object)item));
        if (id.toString().contains(searchText)) {
            return true;
        }
        String key = ModRegisterEvent.SPECIAL_TOOLTIPS.get(id);
        if (key == null) {
            return false;
        }
        if (key.contains(searchText)) {
            return true;
        }
        return I18n.m_118938_((String)("tooltip.kaleidoscope_doll.doll." + key), (Object[])new Object[0]).contains(searchText);
    }

    private void initSearch() {
        String perText = "";
        boolean focus = false;
        if (this.searchField != null) {
            perText = this.searchField.m_94155_();
            focus = this.searchField.m_93696_();
        }
        this.searchField = new EditBox(this.getMinecraft().f_91062_, this.f_97735_ + 8, this.f_97736_ + 102, 85, 16, (Component)Component.m_237113_((String)"Doll Search Box"));
        this.searchField.m_94144_(perText);
        this.searchField.m_94182_(false);
        this.searchField.m_94199_(32);
        this.searchField.m_94202_(3800918);
        this.searchField.m_93692_(focus);
        this.searchField.m_94201_();
        this.m_7787_((GuiEventListener)this.searchField);
    }

    protected void m_280003_(GuiGraphics graphics, int x, int y) {
        graphics.m_280614_(this.f_96547_, (Component)Component.m_237115_((String)"block.kaleidoscope_doll.computer"), this.f_97728_, this.f_97729_, 0x404040, false);
    }

    protected void m_7286_(GuiGraphics graphics, float partialTicks, int x, int y) {
        this.m_280273_(graphics);
        int posX = this.f_97735_;
        int posY = (this.f_96544_ - this.f_97727_) / 2;
        graphics.m_280218_(BG, posX, posY, 0, 0, this.f_97726_, this.f_97727_);
    }

    public void m_88315_(GuiGraphics graphics, int x, int y, float partialTicks) {
        super.m_88315_(graphics, x, y, partialTicks);
        int uOffset = this.isScrollBarActive() ? 0 : 14;
        int offset = (int)(57.0f * this.scrollOffs);
        graphics.m_280218_(BG, this.f_97735_ + 155, this.f_97736_ + 17 + offset, 177 + uOffset, 0, 12, 15);
        this.searchField.m_88315_(graphics, x, y, partialTicks);
        if (!this.searchField.m_93696_() && this.searchField.m_94155_().isEmpty()) {
            graphics.m_280614_(this.f_96547_, (Component)Component.m_237115_((String)"gui.kaleidoscope_doll.computer.search").m_130940_(ChatFormatting.GRAY), this.f_97735_ + 9, this.f_97736_ + 102, 0xFFFFFF, false);
        }
        if (this.m_6774_(108, 98, 16, 16, x, y) && this.f_97734_ != null && !this.f_97734_.m_6657_()) {
            graphics.m_280557_(this.f_96547_, (Component)Component.m_237115_((String)"tooltip.kaleidoscope_doll.computer.input"), x, y);
        }
        this.m_280072_(graphics, x, y);
    }

    public void m_6574_(Minecraft minecraft, int width, int height) {
        String value = this.searchField.m_94155_();
        super.m_6574_(minecraft, width, height);
        this.searchField.m_94144_(value);
    }

    protected void m_181908_() {
        this.searchField.m_94120_();
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (this.searchField.m_6375_(mouseX, mouseY, button)) {
            this.m_7522_((GuiEventListener)this.searchField);
            return true;
        }
        this.searchField.m_93692_(false);
        this.scrolling = false;
        double scrollX = this.f_97735_ + 155;
        double scrollY = this.f_97736_ + 17;
        if (scrollX <= mouseX && mouseX < scrollX + 12.0 && scrollY <= mouseY && mouseY < scrollY + 72.0) {
            this.scrolling = true;
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    public boolean m_7979_(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (this.scrolling && this.isScrollBarActive()) {
            float yOffset = (float)mouseY - (float)this.f_97736_ - 17.0f;
            this.scrollOffs = Mth.m_14036_((float)(yOffset / 57.0f), (float)0.0f, (float)1.0f);
            this.currentPage = (int)((double)(this.scrollOffs * (float)this.getOffscreenRows()) + 0.5);
            this.m_7856_();
            return true;
        }
        return super.m_7979_(mouseX, mouseY, button, dragX, dragY);
    }

    public boolean m_6050_(double mouseX, double mouseY, double delta) {
        if (this.isScrollBarActive()) {
            int offscreenRows = this.getOffscreenRows();
            float scrollAmount = (float)delta / (float)offscreenRows;
            this.scrollOffs = Mth.m_14036_((float)(this.scrollOffs - scrollAmount), (float)0.0f, (float)1.0f);
            this.currentPage = (int)((double)(this.scrollOffs * (float)offscreenRows) + 0.5);
            this.m_7856_();
        }
        return true;
    }

    private int getOffscreenRows() {
        return (this.dolls.size() + 32 - 1) / 32 - 1;
    }

    private boolean isScrollBarActive() {
        return this.dolls.size() > 32;
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        String preText = this.searchField.m_94155_();
        if (this.searchField.m_7933_(keyCode, scanCode, modifiers)) {
            if (!Objects.equals(preText, this.searchField.m_94155_())) {
                this.currentPage = 0;
                this.m_7856_();
            }
            return true;
        }
        return this.searchField.m_93696_() && this.searchField.m_94213_() && keyCode != 256 || super.m_7933_(keyCode, scanCode, modifiers);
    }

    public boolean m_5534_(char codePoint, int modifiers) {
        if (this.searchField == null) {
            return false;
        }
        String perText = this.searchField.m_94155_();
        if (this.searchField.m_5534_(codePoint, modifiers)) {
            if (!Objects.equals(perText, this.searchField.m_94155_())) {
                this.currentPage = 0;
                this.m_7856_();
            }
            return true;
        }
        return false;
    }

    protected void m_6697_(String text, boolean overwrite) {
        if (overwrite) {
            this.searchField.m_94144_(text);
        } else {
            this.searchField.m_94164_(text);
        }
    }
}

