/*
 * Decompiled with CFR 0.152.
 */
package com.github.ysbbbbbb.kaleidoscopedoll.block;

import com.github.ysbbbbbb.kaleidoscopedoll.config.GeneralConfig;
import com.github.ysbbbbbb.kaleidoscopedoll.datagen.TagItem;
import com.github.ysbbbbbb.kaleidoscopedoll.init.ModItems;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class DollMachineBlock
extends HorizontalDirectionalBlock {
    private static final VoxelShape SHAPE_UPPER = Block.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)8.0, (double)15.0);
    private static final VoxelShape SHAPE = Block.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)16.0, (double)15.0);
    private static final BooleanProperty LOTTERY_IN_PROGRESS = BooleanProperty.m_61465_((String)"lottery_in_progress");
    public static final EnumProperty<DoubleBlockHalf> HALF = BlockStateProperties.f_61401_;

    public DollMachineBlock() {
        super(BlockBehaviour.Properties.m_284310_().m_278183_().m_280658_(NoteBlockInstrument.BASS).m_60918_(SoundType.f_154663_).m_60913_(8.0f, 10.0f).m_60953_(s -> 2).m_278166_(PushReaction.BLOCK).m_60955_());
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)f_54117_, (Comparable)Direction.NORTH)).m_61124_((Property)LOTTERY_IN_PROGRESS, (Comparable)Boolean.valueOf(false))).m_61124_(HALF, (Comparable)DoubleBlockHalf.LOWER));
    }

    public BlockState m_7417_(BlockState state, Direction facing, BlockState facingState, LevelAccessor level, BlockPos currentPos, BlockPos facingPos) {
        DoubleBlockHalf blockHalf = (DoubleBlockHalf)state.m_61143_(HALF);
        if (facing.m_122434_() == Direction.Axis.Y && blockHalf == DoubleBlockHalf.LOWER == (facing == Direction.UP)) {
            boolean condition = facingState.m_60713_((Block)this) && facingState.m_61143_(HALF) != blockHalf;
            return condition ? (BlockState)((BlockState)state.m_61124_((Property)f_54117_, (Comparable)((Direction)facingState.m_61143_((Property)f_54117_)))).m_61124_((Property)LOTTERY_IN_PROGRESS, (Comparable)((Boolean)facingState.m_61143_((Property)LOTTERY_IN_PROGRESS))) : Blocks.f_50016_.m_49966_();
        }
        boolean condition = blockHalf == DoubleBlockHalf.LOWER && facing == Direction.DOWN && !state.m_60710_((LevelReader)level, currentPos);
        return condition ? Blocks.f_50016_.m_49966_() : super.m_7417_(state, facing, facingState, level, currentPos, facingPos);
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        BlockPos clickedPos = context.m_8083_();
        Level level = context.m_43725_();
        if (clickedPos.m_123342_() < level.m_151558_() - 1 && level.m_8055_(clickedPos.m_7494_()).m_60629_(context)) {
            return (BlockState)((BlockState)this.m_49966_().m_61124_((Property)f_54117_, (Comparable)context.m_8125_())).m_61124_(HALF, (Comparable)DoubleBlockHalf.LOWER);
        }
        return null;
    }

    public void m_5707_(Level level, BlockPos pos, BlockState state, Player player) {
        BlockPos below;
        BlockState belowState;
        DoubleBlockHalf value;
        if (!level.f_46443_ && player.m_7500_() && (value = (DoubleBlockHalf)state.m_61143_(HALF)) == DoubleBlockHalf.UPPER && (belowState = level.m_8055_(below = pos.m_7495_())).m_60713_(state.m_60734_()) && belowState.m_61143_(HALF) == DoubleBlockHalf.LOWER) {
            BlockState blockState = belowState.m_60819_().m_192917_((Fluid)Fluids.f_76193_) ? Blocks.f_49990_.m_49966_() : Blocks.f_50016_.m_49966_();
            level.m_7731_(below, blockState, 35);
            level.m_5898_(player, 2001, below, Block.m_49956_((BlockState)belowState));
        }
        super.m_5707_(level, pos, state, player);
    }

    public void m_6402_(Level pLevel, BlockPos pPos, BlockState pState, LivingEntity entity, ItemStack pStack) {
        pLevel.m_7731_(pPos.m_7494_(), (BlockState)pState.m_61124_(HALF, (Comparable)DoubleBlockHalf.UPPER), 3);
    }

    public boolean m_7898_(BlockState pState, LevelReader pLevel, BlockPos pPos) {
        BlockPos blockpos = pPos.m_7495_();
        BlockState blockstate = pLevel.m_8055_(blockpos);
        return pState.m_61143_(HALF) == DoubleBlockHalf.LOWER ? blockstate.m_60783_((BlockGetter)pLevel, blockpos, Direction.UP) : blockstate.m_60713_((Block)this);
    }

    public InteractionResult m_6227_(BlockState blockstate, Level world, BlockPos pos, Player entity, InteractionHand hand, BlockHitResult hit) {
        if (entity.m_21120_(hand).m_204117_(TagItem.DOLL_MACHINE_TOKENS) && !((Boolean)blockstate.m_61143_((Property)LOTTERY_IN_PROGRESS)).booleanValue()) {
            int x = pos.m_123341_();
            int y = blockstate.m_61143_(HALF) == DoubleBlockHalf.LOWER ? pos.m_123342_() : pos.m_123342_() - 1;
            int z = pos.m_123343_();
            entity.m_21120_(hand).m_41774_(1);
            world.m_46597_(pos, (BlockState)blockstate.m_61124_((Property)LOTTERY_IN_PROGRESS, (Comparable)Boolean.valueOf(true)));
            world.m_5594_(null, pos, SoundEvents.f_144180_, SoundSource.BLOCKS, 4.0f, 2.0f);
            if (world instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)world;
                serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_175828_, (double)x + 0.5, (double)(y + 1), (double)z + 0.5, 8, 0.5, 0.5, 0.5, 0.2);
                serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_175829_, (double)x + 0.5, (double)(y + 1), (double)z + 0.5, 8, 0.5, 0.5, 0.5, 0.2);
                world.m_186460_(pos, blockstate.m_60734_(), 60);
            }
            return InteractionResult.SUCCESS;
        }
        return super.m_6227_(blockstate, world, pos, entity, hand, hit);
    }

    public void m_213897_(BlockState blockstate, ServerLevel world, BlockPos pos, RandomSource random) {
        if (((Boolean)blockstate.m_61143_((Property)LOTTERY_IN_PROGRESS)).booleanValue()) {
            this.dropGiftBox(world, blockstate, pos, random);
        }
    }

    public void dropGiftBox(ServerLevel world, BlockState blockstate, BlockPos pos, RandomSource random) {
        int x = pos.m_123341_();
        int y = blockstate.m_61143_(HALF) == DoubleBlockHalf.LOWER ? pos.m_123342_() : pos.m_123342_() - 1;
        int z = pos.m_123343_();
        world.m_8767_((ParticleOptions)ParticleTypes.f_123748_.m_6012_(), (double)x + 0.5, (double)y + 1.8, (double)z + 0.5, 10, 0.5, 0.5, 0.5, 0.5);
        world.m_6263_(null, (double)x, (double)y, (double)z, SoundEvents.f_11871_, SoundSource.BLOCKS, 1.0f, 1.0f);
        world.m_46597_(pos, (BlockState)blockstate.m_61124_((Property)LOTTERY_IN_PROGRESS, (Comparable)Boolean.valueOf(false)));
        int yellowCount = (Integer)GeneralConfig.YELLOW_DOLL_GIFT_BOX_WEIGHT.get();
        int greenCount = yellowCount + (Integer)GeneralConfig.GREEN_DOLL_GIFT_BOX_WEIGHT.get();
        int totalCount = greenCount + (Integer)GeneralConfig.PURPLE_DOLL_GIFT_BOX_WEIGHT.get();
        int count = random.m_216339_(0, totalCount);
        ItemEntity item = count <= yellowCount ? new ItemEntity((Level)world, (double)x + 0.5, (double)y + 1.8, (double)z + 0.5, ((Item)ModItems.YELLOW_DOLL_GIFT_BOX.get()).m_7968_()) : (count <= greenCount ? new ItemEntity((Level)world, (double)x + 0.5, (double)y + 1.8, (double)z + 0.5, ((Item)ModItems.GREEN_DOLL_GIFT_BOX.get()).m_7968_()) : new ItemEntity((Level)world, (double)x + 0.5, (double)y + 1.8, (double)z + 0.5, ((Item)ModItems.PURPLE_DOLL_GIFT_BOX.get()).m_7968_()));
        item.m_32010_(10);
        world.m_7967_((Entity)item);
    }

    public VoxelShape m_5940_(BlockState blockState, BlockGetter level, BlockPos pos, CollisionContext context) {
        if (blockState.m_61143_(HALF) == DoubleBlockHalf.LOWER) {
            return SHAPE;
        }
        return SHAPE_UPPER;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{f_54117_, LOTTERY_IN_PROGRESS, HALF});
    }

    public void m_5871_(ItemStack pStack, @Nullable BlockGetter pLevel, List<Component> tooltip, TooltipFlag pFlag) {
        tooltip.add((Component)Component.m_237115_((String)"tooltip.kaleidoscope_doll.doll_machine").m_130940_(ChatFormatting.DARK_GRAY));
    }
}

