/*
 * Decompiled with CFR 0.152.
 */
package com.github.ysbbbbbb.kaleidoscopecookery.util;

import com.github.ysbbbbbb.kaleidoscopecookery.api.item.IHasContainer;
import com.github.ysbbbbbb.kaleidoscopecookery.init.tag.TagMod;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BowlFoodItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import org.apache.commons.lang3.tuple.Pair;

public class ItemUtils {
    public static void getItemToLivingEntity(LivingEntity entity, ItemStack stack) {
        if (stack.m_41619_()) {
            return;
        }
        if (entity.m_21205_().m_41619_()) {
            RandomSource random = entity.m_9236_().f_46441_;
            entity.m_21008_(InteractionHand.MAIN_HAND, stack);
            entity.m_5496_(SoundEvents.f_12019_, 0.2f, ((random.m_188501_() - random.m_188501_()) * 0.7f + 1.0f) * 2.0f);
        } else if (entity instanceof Player) {
            Player player = (Player)entity;
            ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)stack);
        } else {
            ItemEntity dropItem = entity.m_19983_(stack);
            if (dropItem != null) {
                dropItem.m_32010_(0);
            }
        }
    }

    public static Pair<Integer, ItemStack> getLastStack(IItemHandler itemHandler) {
        for (int i = itemHandler.getSlots(); i > 0; --i) {
            int index = i - 1;
            ItemStack stack = itemHandler.getStackInSlot(index);
            if (stack.m_41619_()) continue;
            return Pair.of((Object)index, (Object)stack);
        }
        return Pair.of((Object)0, (Object)ItemStack.f_41583_);
    }

    public static Item getContainerItem(ItemStack stack) {
        if (stack.m_41619_()) {
            return Items.f_41852_;
        }
        Item item = stack.m_41720_();
        ItemStack remainingItem = item.getCraftingRemainingItem(stack);
        if (remainingItem != null && !remainingItem.m_41619_()) {
            return remainingItem.m_41720_();
        }
        if (item instanceof IHasContainer) {
            IHasContainer hasContainer = (IHasContainer)item;
            return hasContainer.getContainerItem();
        }
        if (item instanceof BowlFoodItem) {
            return Items.f_42399_;
        }
        if (stack.m_204117_(TagMod.BOWL_CONTAINER)) {
            return Items.f_42399_;
        }
        if (stack.m_204117_(TagMod.GLASS_BOTTLE_CONTAINER)) {
            return Items.f_42590_;
        }
        if (stack.m_204117_(TagMod.BUCKET_CONTAINER)) {
            return Items.f_42446_;
        }
        return Items.f_41852_;
    }
}

