/*
 * Decompiled with CFR 0.152.
 */
package com.github.ysbbbbbb.kaleidoscopecookery.loot;

import com.github.ysbbbbbb.kaleidoscopecookery.crafting.recipe.PotRecipe;
import com.github.ysbbbbbb.kaleidoscopecookery.crafting.recipe.StockpotRecipe;
import com.github.ysbbbbbb.kaleidoscopecookery.init.ModLootModifier;
import com.github.ysbbbbbb.kaleidoscopecookery.init.ModRecipes;
import com.github.ysbbbbbb.kaleidoscopecookery.init.registry.FoodBiteRegistry;
import com.github.ysbbbbbb.kaleidoscopecookery.item.RecipeItem;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.functions.LootItemConditionalFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraftforge.registries.ForgeRegistries;

public class RecipeRandomlyFunction
extends LootItemConditionalFunction {
    private final List<RecipeItem.RecipeRecord> possibleRecipes;

    protected RecipeRandomlyFunction(LootItemCondition[] predicates, Collection<RecipeItem.RecipeRecord> possibleRecipes) {
        super(predicates);
        this.possibleRecipes = ImmutableList.copyOf(possibleRecipes);
    }

    public LootItemFunctionType m_7162_() {
        return ModLootModifier.RECIPE_RANDOMLY;
    }

    protected ItemStack m_7372_(ItemStack stack, LootContext context) {
        RandomSource randomsource = context.m_230907_();
        if (!this.possibleRecipes.isEmpty()) {
            RecipeItem.RecipeRecord record = this.possibleRecipes.get(randomsource.m_188503_(this.possibleRecipes.size()));
            RecipeItem.setRecipe(stack, record);
            return stack;
        }
        List keys = FoodBiteRegistry.FOOD_DATA_MAP.keySet().stream().toList();
        if (keys.isEmpty()) {
            return stack;
        }
        ResourceLocation randomKey = (ResourceLocation)keys.get(randomsource.m_188503_(keys.size()));
        Item result = FoodBiteRegistry.getItem(randomKey);
        RegistryAccess registryAccess = context.m_78952_().m_9598_();
        List potRecipes = context.m_78952_().m_7465_().m_44013_(ModRecipes.POT_RECIPE);
        for (PotRecipe recipe : potRecipes) {
            ItemStack resultItem = recipe.m_8043_(registryAccess);
            if (!resultItem.m_150930_(result)) continue;
            List<ItemStack> inputs = recipe.m_7527_().stream().filter(i -> !i.m_43947_()).map(i -> i.m_43908_()[0]).toList();
            RecipeItem.RecipeRecord record = new RecipeItem.RecipeRecord(inputs, resultItem, RecipeItem.POT);
            RecipeItem.setRecipe(stack, record);
            return stack;
        }
        List stockpotRecipes = context.m_78952_().m_7465_().m_44013_(ModRecipes.STOCKPOT_RECIPE);
        for (StockpotRecipe recipe : stockpotRecipes) {
            ItemStack resultItem = recipe.m_8043_(registryAccess);
            if (!resultItem.m_150930_(result)) continue;
            List<ItemStack> inputs = recipe.m_7527_().stream().filter(i -> !i.m_43947_()).map(i -> i.m_43908_()[0]).toList();
            RecipeItem.RecipeRecord record = new RecipeItem.RecipeRecord(inputs, resultItem, RecipeItem.STOCKPOT);
            RecipeItem.setRecipe(stack, record);
            return stack;
        }
        return stack;
    }

    public static Builder randomRecipe() {
        return new Builder();
    }

    public static class Builder
    extends LootItemConditionalFunction.Builder<Builder> {
        private final List<RecipeItem.RecipeRecord> recipes = Lists.newArrayList();

        protected Builder getThis() {
            return this;
        }

        public Builder withRecord(RecipeItem.RecipeRecord record) {
            this.recipes.add(record);
            return this;
        }

        public Builder pot(ItemLike output, ItemLike ... input) {
            List<ItemStack> list = Arrays.stream(input).map(ItemStack::new).toList();
            RecipeItem.RecipeRecord record = new RecipeItem.RecipeRecord(list, new ItemStack(output), RecipeItem.POT);
            return this.withRecord(record);
        }

        public Builder stockpot(ItemLike output, ItemLike ... input) {
            List<ItemStack> list = Arrays.stream(input).map(ItemStack::new).toList();
            RecipeItem.RecipeRecord record = new RecipeItem.RecipeRecord(list, new ItemStack(output), RecipeItem.STOCKPOT);
            return this.withRecord(record);
        }

        public LootItemFunction m_7453_() {
            return new RecipeRandomlyFunction(this.m_80699_(), this.recipes);
        }
    }

    public static class Serializer
    extends LootItemConditionalFunction.Serializer<RecipeRandomlyFunction> {
        public void serialize(JsonObject json, RecipeRandomlyFunction function, JsonSerializationContext context) {
            super.m_6170_(json, (LootItemConditionalFunction)function, context);
            if (function.possibleRecipes.isEmpty()) {
                return;
            }
            JsonArray records = new JsonArray();
            for (RecipeItem.RecipeRecord record : function.possibleRecipes) {
                JsonObject root = new JsonObject();
                JsonObject output = new JsonObject();
                JsonArray inputs = new JsonArray();
                root.addProperty("type", record.type().toString());
                output.addProperty("item", ForgeRegistries.ITEMS.getKey((Object)record.output().m_41720_()).toString());
                output.addProperty("count", (Number)record.output().m_41613_());
                root.add("output", (JsonElement)output);
                for (ItemStack input : record.input()) {
                    JsonObject inputJson = new JsonObject();
                    inputJson.addProperty("item", ForgeRegistries.ITEMS.getKey((Object)input.m_41720_()).toString());
                    inputs.add((JsonElement)inputJson);
                }
                root.add("inputs", (JsonElement)inputs);
                records.add((JsonElement)root);
            }
            json.add("records", (JsonElement)records);
        }

        public RecipeRandomlyFunction deserialize(JsonObject object, JsonDeserializationContext context, LootItemCondition[] conditions) {
            if (!object.has("records")) {
                return new RecipeRandomlyFunction(conditions, Collections.emptyList());
            }
            JsonArray records = object.getAsJsonArray("records");
            if (records.size() <= 0) {
                return new RecipeRandomlyFunction(conditions, Collections.emptyList());
            }
            ArrayList recipeRecords = Lists.newArrayList();
            for (int i = 0; i < records.size(); ++i) {
                JsonObject record = records.get(i).getAsJsonObject();
                ResourceLocation type = new ResourceLocation(record.get("type").getAsString());
                JsonObject outputJson = record.getAsJsonObject("output");
                Item item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(GsonHelper.m_13906_((JsonObject)outputJson, (String)"item")));
                int count = GsonHelper.m_13824_((JsonObject)outputJson, (String)"count", (int)1);
                if (item == null) {
                    throw new JsonSyntaxException("No such item " + GsonHelper.m_13906_((JsonObject)outputJson, (String)"item"));
                }
                if (count <= 0) {
                    throw new JsonSyntaxException("Item count must be positive");
                }
                ItemStack output = new ItemStack((ItemLike)item, count);
                JsonArray inputsJson = record.getAsJsonArray("inputs");
                ArrayList inputs = Lists.newArrayList();
                for (int j = 0; j < inputsJson.size(); ++j) {
                    JsonObject inputJson = inputsJson.get(j).getAsJsonObject();
                    Item inputItem = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(GsonHelper.m_13906_((JsonObject)inputJson, (String)"item")));
                    if (inputItem == null) {
                        throw new JsonSyntaxException("No such item " + GsonHelper.m_13906_((JsonObject)inputJson, (String)"item"));
                    }
                    inputs.add(new ItemStack((ItemLike)inputItem));
                }
                recipeRecords.add(new RecipeItem.RecipeRecord(inputs, output, type));
            }
            return new RecipeRandomlyFunction(conditions, recipeRecords);
        }
    }
}

