/*
 * Decompiled with CFR 0.152.
 */
package com.github.ysbbbbbb.kaleidoscopecookery.item;

import com.github.ysbbbbbb.kaleidoscopecookery.blockentity.kitchen.PotBlockEntity;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ShovelItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.Tiers;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

public class KitchenShovelItem
extends ShovelItem {
    public static final ResourceLocation HAS_OIL_PROPERTY = new ResourceLocation("kaleidoscope_cookery", "has_oil");
    private static final int NO_OIL = 0;
    private static final int HAS_OIL = 1;

    public KitchenShovelItem() {
        super((Tier)Tiers.IRON, -1.0f, -2.0f, new Item.Properties());
    }

    public static void setHasOil(ItemStack stack, boolean hasOil) {
        CompoundTag tag = stack.m_41784_();
        tag.m_128379_("hasOil", hasOil);
    }

    public static boolean hasOil(ItemStack stack) {
        CompoundTag tag = stack.m_41783_();
        return tag != null && tag.m_128471_("hasOil");
    }

    @OnlyIn(value=Dist.CLIENT)
    public static float getTexture(ItemStack stack, @javax.annotation.Nullable ClientLevel level, @javax.annotation.Nullable LivingEntity entity, int seed) {
        if (KitchenShovelItem.hasOil(stack)) {
            return 1.0f;
        }
        return 0.0f;
    }

    public InteractionResult m_6225_(UseOnContext context) {
        InteractionResult result = super.m_6225_(context);
        if (result.m_146666_() && KitchenShovelItem.hasOil(context.m_43722_())) {
            KitchenShovelItem.setHasOil(context.m_43722_(), false);
        }
        return result;
    }

    public InteractionResult onItemUseFirst(ItemStack stack, UseOnContext context) {
        BlockPos clickedPos = context.m_8083_();
        Level level = context.m_43725_();
        Player player = context.m_43723_();
        BlockEntity blockEntity = level.m_7702_(clickedPos);
        if (blockEntity instanceof PotBlockEntity) {
            PotBlockEntity potBlockEntity = (PotBlockEntity)blockEntity;
            if (player != null && player.m_36341_() && potBlockEntity.getStatus() == 2 && !potBlockEntity.hasCarrier()) {
                potBlockEntity.takeOutProduct(level, (LivingEntity)player, stack);
                return InteractionResult.SUCCESS;
            }
        }
        return super.onItemUseFirst(stack, context);
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag flag) {
        tooltip.add((Component)Component.m_237115_((String)"tooltip.kaleidoscope_cookery.kitchen_shovel").m_130940_(ChatFormatting.GRAY));
    }
}

