/*
 * Decompiled with CFR 0.152.
 */
package com.github.ysbbbbbb.kaleidoscopecookery.datamap.resources;

import com.github.ysbbbbbb.kaleidoscopecookery.KaleidoscopeCookery;
import com.github.ysbbbbbb.kaleidoscopecookery.datamap.MillstoneBindableData;
import com.google.common.collect.Maps;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.resources.IoSupplier;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.ResourceManagerReloadListener;
import net.minecraft.world.entity.EntityType;

public class MillstoneBindableDataReloadListener
implements ResourceManagerReloadListener {
    public static final Map<EntityType<?>, MillstoneBindableData> INSTANCE = Maps.newHashMap();
    private static final ResourceLocation FILE_PATH = new ResourceLocation("kaleidoscope_cookery", "datamap/millstone_bindable_data.json");

    public void m_6213_(ResourceManager resourceManager) {
        resourceManager.m_7536_().forEach(packResources -> {
            IoSupplier resource = packResources.m_214146_(PackType.SERVER_DATA, FILE_PATH);
            if (resource == null) {
                return;
            }
            try (InputStream inputStream = (InputStream)resource.m_247737_();
                 InputStreamReader reader = new InputStreamReader(inputStream, StandardCharsets.UTF_8);){
                JsonElement jsonElement = JsonParser.parseReader((Reader)reader);
                DataResult result = MillstoneBindableData.CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)jsonElement);
                if (result.result().isPresent()) {
                    INSTANCE.putAll((Map)result.result().get());
                    KaleidoscopeCookery.LOGGER.info("Successfully loaded millstone bindable data");
                } else if (result.error().isPresent()) {
                    KaleidoscopeCookery.LOGGER.error("Failed to parse millstone bindable data: {}", (Object)((DataResult.PartialResult)result.error().get()).message());
                }
            }
            catch (Exception e) {
                KaleidoscopeCookery.LOGGER.error("Failed to load millstone bindable data", (Throwable)e);
            }
        });
    }
}

