/*
 * Decompiled with CFR 0.152.
 */
package com.github.ysbbbbbb.kaleidoscopecookery.client.render.block;

import com.github.ysbbbbbb.kaleidoscopecookery.block.kitchen.ShawarmaSpitBlock;
import com.github.ysbbbbbb.kaleidoscopecookery.blockentity.kitchen.ShawarmaSpitBlockEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;

public class ShawarmaSpitBlockEntityRender
implements BlockEntityRenderer<ShawarmaSpitBlockEntity> {
    private final BlockEntityRendererProvider.Context context;

    public ShawarmaSpitBlockEntityRender(BlockEntityRendererProvider.Context context) {
        this.context = context;
    }

    public void render(ShawarmaSpitBlockEntity shawarmaSpit, float partialTick, PoseStack poseStack, MultiBufferSource buffer, int packedLight, int packedOverlay) {
        ItemStack cookedItem = shawarmaSpit.cookedItem;
        if (cookedItem.m_41619_()) {
            return;
        }
        ItemStack renderItem = !shawarmaSpit.cookingItem.m_41619_() ? shawarmaSpit.cookingItem : cookedItem;
        BlockState blockState = shawarmaSpit.m_58900_();
        Boolean powered = (Boolean)blockState.m_61143_((Property)BlockStateProperties.f_61448_);
        DoubleBlockHalf half = (DoubleBlockHalf)blockState.m_61143_(ShawarmaSpitBlock.HALF);
        ItemRenderer itemRenderer = this.context.m_234447_();
        if (powered.booleanValue()) {
            long time = System.currentTimeMillis() % 3600L;
            poseStack.m_272245_(Axis.f_252436_.m_252977_((float)time / 10.0f), 0.5f, 0.0f, 0.5f);
        }
        if (half == DoubleBlockHalf.UPPER) {
            poseStack.m_85837_(0.25, 0.5, 0.25);
            this.renderItems(shawarmaSpit, poseStack, buffer, packedLight, packedOverlay, renderItem, itemRenderer);
        } else if (half == DoubleBlockHalf.LOWER) {
            poseStack.m_85837_(0.25, 0.875, 0.25);
            this.renderItems(shawarmaSpit, poseStack, buffer, packedLight, packedOverlay, renderItem, itemRenderer);
        }
    }

    private void renderItems(ShawarmaSpitBlockEntity shawarmaSpit, PoseStack poseStack, MultiBufferSource buffer, int packedLight, int packedOverlay, ItemStack renderItem, ItemRenderer itemRenderer) {
        for (int i = 0; i < renderItem.m_41613_(); ++i) {
            poseStack.m_85836_();
            poseStack.m_272245_(Axis.f_252436_.m_252977_((float)(i * 45)), 0.25f, 0.0f, 0.25f);
            poseStack.m_85841_(0.65f, 0.65f, 0.65f);
            itemRenderer.m_269128_(renderItem, ItemDisplayContext.FIXED, packedLight, packedOverlay, poseStack, buffer, shawarmaSpit.m_58904_(), 0);
            poseStack.m_85849_();
        }
    }
}

