/*
 * Decompiled with CFR 0.152.
 */
package com.github.ysbbbbbb.kaleidoscopecookery.blockentity.kitchen;

import com.github.ysbbbbbb.kaleidoscopecookery.api.blockentity.IStockpot;
import com.github.ysbbbbbb.kaleidoscopecookery.api.event.StockpotMatchRecipeEvent;
import com.github.ysbbbbbb.kaleidoscopecookery.api.recipe.soupbase.ISoupBase;
import com.github.ysbbbbbb.kaleidoscopecookery.block.kitchen.StockpotBlock;
import com.github.ysbbbbbb.kaleidoscopecookery.blockentity.BaseBlockEntity;
import com.github.ysbbbbbb.kaleidoscopecookery.client.particle.StockpotParticleOptions;
import com.github.ysbbbbbb.kaleidoscopecookery.crafting.container.StockpotContainer;
import com.github.ysbbbbbb.kaleidoscopecookery.crafting.recipe.StockpotRecipe;
import com.github.ysbbbbbb.kaleidoscopecookery.crafting.serializer.StockpotRecipeSerializer;
import com.github.ysbbbbbb.kaleidoscopecookery.crafting.soupbase.FluidSoupBase;
import com.github.ysbbbbbb.kaleidoscopecookery.crafting.soupbase.SoupBaseManager;
import com.github.ysbbbbbb.kaleidoscopecookery.init.ModBlocks;
import com.github.ysbbbbbb.kaleidoscopecookery.init.ModItems;
import com.github.ysbbbbbb.kaleidoscopecookery.init.ModParticles;
import com.github.ysbbbbbb.kaleidoscopecookery.init.ModRecipes;
import com.github.ysbbbbbb.kaleidoscopecookery.init.ModSounds;
import com.github.ysbbbbbb.kaleidoscopecookery.init.ModSoupBases;
import com.github.ysbbbbbb.kaleidoscopecookery.init.ModTrigger;
import com.github.ysbbbbbb.kaleidoscopecookery.init.tag.TagMod;
import com.github.ysbbbbbb.kaleidoscopecookery.util.BlockDrop;
import com.github.ysbbbbbb.kaleidoscopecookery.util.ItemUtils;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetActionBarTextPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;

public class StockpotBlockEntity
extends BaseBlockEntity
implements IStockpot {
    public static final int MAX_TAKEOUT_COUNT = 9;
    private static final String INPUTS = "Inputs";
    private static final String RECIPE_ID = "RecipeId";
    private static final String SOUP_BASE_ID = "SoupBaseId";
    private static final String RESULT = "Result";
    private static final String STATUS = "Status";
    private static final String CURRENT_TICK = "CurrentTick";
    private static final String TAKEOUT_COUNT = "TakeoutCount";
    private static final String LID_ITEM = "LidItem";
    private final RecipeManager.CachedCheck<StockpotContainer, StockpotRecipe> quickCheck = RecipeManager.m_220267_(ModRecipes.STOCKPOT_RECIPE);
    private NonNullList<ItemStack> inputs = NonNullList.m_122780_((int)9, (Object)ItemStack.f_41583_);
    private ResourceLocation recipeId = StockpotRecipeSerializer.EMPTY_ID;
    private ResourceLocation soupBaseId = ModSoupBases.WATER;
    private ItemStack result = ItemStack.f_41583_;
    private int status = 0;
    private int currentTick = -1;
    private int takeoutCount = 0;
    private ItemStack lidItem = ItemStack.f_41583_;
    public StockpotRecipe recipe = StockpotRecipeSerializer.getEmptyRecipe();
    @Nullable
    public Entity renderEntity = null;

    public StockpotBlockEntity(BlockPos pPos, BlockState pBlockState) {
        super((BlockEntityType)ModBlocks.STOCKPOT_BE.get(), pPos, pBlockState);
    }

    public void clientTick() {
        if (this.renderEntity != null) {
            ++this.renderEntity.f_19797_;
        }
    }

    @Override
    public boolean hasHeatSource(Level level) {
        BlockState belowState = level.m_8055_(this.f_58858_.m_7495_());
        if (belowState.m_61138_((Property)BlockStateProperties.f_61443_) && ((Boolean)belowState.m_61143_((Property)BlockStateProperties.f_61443_)).booleanValue()) {
            return true;
        }
        return belowState.m_204336_(TagMod.HEAT_SOURCE_BLOCKS_WITHOUT_LIT);
    }

    @Override
    public boolean hasLid() {
        if (this.f_58857_ == null) {
            return false;
        }
        BlockState blockState = this.f_58857_.m_8055_(this.f_58858_);
        return this.f_58857_ != null && blockState.m_61138_((Property)StockpotBlock.HAS_LID) && (Boolean)blockState.m_61143_((Property)StockpotBlock.HAS_LID) != false;
    }

    public void tick(Level level) {
        if (this.status == 0) {
            return;
        }
        if (!this.hasHeatSource(level)) {
            return;
        }
        boolean hasLid = this.hasLid();
        if (level.m_46467_() % 15L == 0L) {
            float volume = hasLid ? 0.075f : 0.2f;
            float pitch = hasLid ? 0.1f + level.f_46441_.m_188501_() * 0.05f : 1.0f + level.f_46441_.m_188501_() * 0.1f;
            level.m_6263_(null, (double)this.f_58858_.m_123341_() + 0.5, (double)this.f_58858_.m_123342_() + 0.5, (double)this.f_58858_.m_123343_() + 0.5, (SoundEvent)ModSounds.BLOCK_STOCKPOT.get(), SoundSource.BLOCKS, volume, pitch);
        }
        if (!hasLid) {
            this.spawnParticleWithoutLid(level);
            return;
        }
        this.spawnParticleWithLid(level);
        if (this.status == 1 && level.m_46467_() % 5L == 0L && !this.isEmpty()) {
            this.setRecipe(level);
            this.status = 2;
            this.refresh();
            return;
        }
        if (this.status == 2) {
            if (this.currentTick > 0) {
                --this.currentTick;
                return;
            }
            this.status = 3;
            this.currentTick = -1;
            this.inputs.clear();
            this.refresh();
        }
    }

    private void spawnParticleWithLid(Level level) {
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (level.f_46441_.m_188501_() < 0.05f) {
                RandomSource random = serverLevel.f_46441_;
                serverLevel.m_8767_((ParticleOptions)((SimpleParticleType)ModParticles.COOKING.get()), (double)this.f_58858_.m_123341_() + 0.5 + random.m_188500_() / 3.0 * (double)(random.m_188499_() ? 1 : -1), (double)this.f_58858_.m_123342_() + 0.375 + random.m_188500_() / 3.0, (double)this.f_58858_.m_123343_() + 0.5 + random.m_188500_() / 3.0 * (double)(random.m_188499_() ? 1 : -1), 1, 0.0, 0.0, 0.0, 0.05);
            }
        }
    }

    private void spawnParticleWithoutLid(Level level) {
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (serverLevel.f_46441_.m_188501_() < 0.25f) {
                int color = this.getBubbleColor();
                serverLevel.m_8767_((ParticleOptions)new StockpotParticleOptions(Vec3.m_82501_((int)color).m_252839_(), 1.0f), (double)this.f_58858_.m_123341_() + 0.25 + (double)(level.f_46441_.m_188501_() * 0.5f), (double)this.f_58858_.m_123342_() + 0.375, (double)this.f_58858_.m_123343_() + 0.25 + (double)(level.f_46441_.m_188501_() * 0.5f), 2, ((double)level.f_46441_.m_188501_() - 0.5) * (double)0.1f, 0.0, ((double)level.f_46441_.m_188501_() - 0.5) * (double)0.1f, 0.0);
            }
        }
    }

    private int getBubbleColor() {
        if (this.f_58857_ != null && this.recipeId != StockpotRecipeSerializer.EMPTY_ID && this.recipe.m_6423_() == StockpotRecipeSerializer.EMPTY_ID) {
            StockpotRecipe stockpotRecipe = (StockpotRecipe)this.f_58857_.m_7465_().m_44054_(ModRecipes.STOCKPOT_RECIPE).get(this.recipeId);
            this.recipe = Objects.requireNonNullElseGet(stockpotRecipe, StockpotRecipeSerializer::getEmptyRecipe);
        }
        if (this.status == 2) {
            return this.recipe.cookingBubbleColor();
        }
        if (this.status == 3) {
            return this.recipe.finishedBubbleColor();
        }
        ISoupBase soup = this.getSoupBase();
        if (soup != null) {
            return soup.getBubbleColor();
        }
        return 0xFFFFFF;
    }

    @Override
    public boolean onLitClick(Level level, LivingEntity user, ItemStack stack) {
        BlockState blockState = level.m_8055_(this.f_58858_);
        boolean hasLid = this.hasLid();
        if (!hasLid && stack.m_150930_((Item)ModItems.STOCKPOT_LID.get())) {
            this.setLidItem(stack.m_41620_(1));
            this.m_6596_();
            level.m_46597_(this.f_58858_, (BlockState)blockState.m_61124_((Property)StockpotBlock.HAS_LID, (Comparable)Boolean.valueOf(true)));
            user.m_5496_(SoundEvents.f_12028_, 0.5f, 0.5f);
            ModTrigger.EVENT.trigger(user, "use_lid_on_stockpot");
            return true;
        }
        if (hasLid) {
            ItemStack lid = this.getLidItem().m_41619_() ? ((Item)ModItems.STOCKPOT_LID.get()).m_7968_() : this.getLidItem().m_41777_();
            this.setLidItem(ItemStack.f_41583_);
            if (stack.m_41619_()) {
                user.m_21008_(InteractionHand.MAIN_HAND, lid);
            } else {
                BlockDrop.popResource(level, this.f_58858_, 0.5, lid);
            }
            this.m_6596_();
            level.m_46597_(this.f_58858_, (BlockState)blockState.m_61124_((Property)StockpotBlock.HAS_LID, (Comparable)Boolean.valueOf(false)));
            user.m_5496_(SoundEvents.f_12025_, 0.5f, 0.5f);
            return true;
        }
        return false;
    }

    public StockpotContainer getContainer() {
        return new StockpotContainer((List<ItemStack>)this.inputs, this.soupBaseId);
    }

    private void setRecipe(Level levelIn) {
        StockpotContainer container = this.getContainer();
        StockpotMatchRecipeEvent.Pre preEvent = new StockpotMatchRecipeEvent.Pre(levelIn, this, container);
        MinecraftForge.EVENT_BUS.post((Event)preEvent);
        if (preEvent.getOutput() != null) {
            this.applyRecipe(levelIn, container, preEvent.getOutput());
        }
        this.quickCheck.m_213657_((Container)container, levelIn).ifPresentOrElse(recipe -> this.applyRecipe(levelIn, container, (StockpotRecipe)recipe), () -> {
            this.recipeId = StockpotRecipeSerializer.EMPTY_ID;
            this.recipe = StockpotRecipeSerializer.getEmptyRecipe();
            this.result = Items.f_42718_.m_7968_();
            this.currentTick = 300;
            this.takeoutCount = 1;
        });
        StockpotMatchRecipeEvent.Post postEvent = new StockpotMatchRecipeEvent.Post(levelIn, this, container, this.recipe);
        MinecraftForge.EVENT_BUS.post((Event)postEvent);
        if (postEvent.getOutput() != null) {
            this.applyRecipe(levelIn, container, postEvent.getOutput());
        }
    }

    private void applyRecipe(Level level, StockpotContainer container, StockpotRecipe recipe) {
        this.recipeId = recipe.m_6423_();
        this.recipe = recipe;
        this.result = recipe.m_5874_(container, level.m_9598_());
        this.currentTick = recipe.time();
        this.takeoutCount = Math.min(this.result.m_41613_(), 9);
    }

    @Override
    public boolean addSoupBase(Level level, LivingEntity user, ItemStack bucket) {
        if (this.hasLid()) {
            return false;
        }
        if (this.status != 0) {
            return false;
        }
        for (Map.Entry<ResourceLocation, ISoupBase> entry : SoupBaseManager.getAllSoupBases().entrySet()) {
            ResourceLocation key = entry.getKey();
            ISoupBase soupBase = entry.getValue();
            if (!soupBase.isSoupBase(bucket)) continue;
            this.soupBaseId = key;
            this.status = 1;
            this.refresh();
            ItemStack container = soupBase.getReturnContainer(level, user, bucket);
            bucket.m_41774_(1);
            ItemUtils.getItemToLivingEntity(user, container);
            return true;
        }
        return false;
    }

    @Override
    public boolean removeSoupBase(Level level, LivingEntity user, ItemStack bucket) {
        if (this.status == 1 && this.isEmpty() && SoupBaseManager.containsSoupBase(this.soupBaseId)) {
            ISoupBase soupBase = this.getSoupBase();
            if (soupBase == null || !soupBase.isContainer(bucket)) {
                return false;
            }
            this.renderEntity = null;
            this.soupBaseId = ModSoupBases.WATER;
            this.status = 0;
            this.refresh();
            ItemStack container = soupBase.getReturnSoupBase(level, user, bucket);
            bucket.m_41774_(1);
            ItemUtils.getItemToLivingEntity(user, container);
            return true;
        }
        return false;
    }

    public void addAllIngredients(List<ItemStack> ingredients, LivingEntity user) {
        if (this.f_58857_ == null) {
            return;
        }
        if (this.hasLid()) {
            return;
        }
        if (this.status != 1) {
            return;
        }
        for (int i = 0; i < Math.min(ingredients.size(), this.inputs.size()); ++i) {
            ItemStack stack = ingredients.get(i);
            if (stack.m_41619_()) continue;
            Item containerItem = ItemUtils.getContainerItem(stack);
            if (containerItem != Items.f_41852_) {
                ItemUtils.getItemToLivingEntity(user, containerItem.m_7968_());
            }
            this.inputs.set(i, (Object)stack.m_255036_(1));
        }
        this.f_58857_.m_5594_(null, this.f_58858_, SoundEvents.f_12019_, SoundSource.PLAYERS, 0.2f, ((this.f_58857_.f_46441_.m_188501_() - this.f_58857_.f_46441_.m_188501_()) * 0.7f + 1.0f) * 2.0f);
        this.refresh();
    }

    @Override
    public boolean addIngredient(Level level, LivingEntity user, ItemStack itemStack) {
        if (this.hasLid()) {
            return false;
        }
        if (this.status != 1) {
            return false;
        }
        if (!itemStack.m_41614_() && !itemStack.m_204117_(TagMod.POT_INGREDIENT)) {
            return false;
        }
        for (int i = 0; i < this.inputs.size(); ++i) {
            if (!((ItemStack)this.inputs.get(i)).m_41619_()) continue;
            Item containerItem = ItemUtils.getContainerItem(itemStack);
            if (containerItem != Items.f_41852_) {
                ItemUtils.getItemToLivingEntity(user, containerItem.m_7968_());
            }
            this.inputs.set(i, (Object)itemStack.m_41620_(1));
            level.m_6263_(null, user.m_20185_(), user.m_20186_() + 0.5, user.m_20189_(), SoundEvents.f_12019_, SoundSource.PLAYERS, 0.2f, ((level.f_46441_.m_188501_() - level.f_46441_.m_188501_()) * 0.7f + 1.0f) * 2.0f);
            this.refresh();
            return true;
        }
        return false;
    }

    @Override
    public boolean removeIngredient(Level level, LivingEntity user) {
        if (this.hasLid()) {
            return false;
        }
        if (this.status != 1) {
            return false;
        }
        for (int i = this.inputs.size() - 1; i >= 0; --i) {
            FluidSoupBase fluidSoupBase;
            ItemStack stack = (ItemStack)this.inputs.get(i);
            if (stack.m_41619_()) continue;
            if (!this.containerIsMatch(user, stack)) {
                return false;
            }
            this.inputs.set(i, (Object)ItemStack.f_41583_);
            ItemUtils.getItemToLivingEntity(user, stack.m_41777_());
            ISoupBase soupBase = this.getSoupBase();
            if (soupBase instanceof FluidSoupBase && (fluidSoupBase = (FluidSoupBase)soupBase).getFluid().getFluidType().getTemperature() > 500) {
                user.m_6469_(level.m_269111_().m_269387_(), 1.0f);
                ModTrigger.EVENT.trigger(user, "hurt_when_takeout_from_stockpot");
            }
            this.refresh();
            return true;
        }
        return false;
    }

    private boolean containerIsMatch(LivingEntity user, ItemStack stack) {
        Item containerItem = ItemUtils.getContainerItem(stack);
        if (containerItem == Items.f_41852_) {
            return true;
        }
        if (user.m_21205_().m_150930_(containerItem)) {
            user.m_21205_().m_41774_(1);
            return true;
        }
        this.sendActionBarMessage(user, "tip.kaleidoscope_cookery.kitchen.remove_ingredient.need_container", containerItem.m_7968_().m_41786_());
        return false;
    }

    @Override
    public boolean takeOutProduct(Level level, LivingEntity user, ItemStack stack) {
        if (this.hasLid()) {
            return false;
        }
        if (this.status != 3 || this.result.m_41619_() || this.takeoutCount <= 0) {
            return false;
        }
        Ingredient carrier = this.recipe.carrier();
        if (!carrier.m_43947_() && !carrier.test(stack)) {
            Component carrierName = carrier.m_43908_()[0].m_41786_();
            this.sendActionBarMessage(user, "tip.kaleidoscope_cookery.pot.need_carrier", carrierName);
            return false;
        }
        if (!carrier.m_43947_()) {
            stack.m_41774_(1);
        }
        ItemStack resultCopy = this.result.m_255036_(1);
        ItemUtils.getItemToLivingEntity(user, resultCopy);
        --this.takeoutCount;
        if (this.takeoutCount <= 0) {
            this.status = 0;
            this.inputs.clear();
            this.recipeId = StockpotRecipeSerializer.EMPTY_ID;
            this.soupBaseId = ModSoupBases.WATER;
            this.result = ItemStack.f_41583_;
            this.currentTick = -1;
            this.renderEntity = null;
        }
        this.refresh();
        return true;
    }

    private void sendActionBarMessage(LivingEntity user, String key, Object ... args) {
        if (user instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)user;
            MutableComponent message = Component.m_237110_((String)key, (Object[])args);
            serverPlayer.f_8906_.m_9829_((Packet)new ClientboundSetActionBarTextPacket((Component)message));
        }
    }

    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128365_(INPUTS, (Tag)ContainerHelper.m_18973_((CompoundTag)new CompoundTag(), this.inputs));
        tag.m_128359_(RECIPE_ID, this.recipeId.toString());
        tag.m_128359_(SOUP_BASE_ID, this.soupBaseId.toString());
        tag.m_128365_(RESULT, (Tag)this.result.m_41739_(new CompoundTag()));
        tag.m_128405_(STATUS, this.status);
        tag.m_128405_(CURRENT_TICK, this.currentTick);
        tag.m_128405_(TAKEOUT_COUNT, this.takeoutCount);
        if (!this.lidItem.m_41619_()) {
            tag.m_128365_(LID_ITEM, (Tag)this.lidItem.m_41739_(new CompoundTag()));
        }
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        if (tag.m_128441_(INPUTS)) {
            this.inputs = NonNullList.m_122780_((int)9, (Object)ItemStack.f_41583_);
            ContainerHelper.m_18980_((CompoundTag)tag.m_128469_(INPUTS), this.inputs);
        }
        if (tag.m_128441_(RECIPE_ID)) {
            this.recipeId = ResourceLocation.m_135820_((String)tag.m_128461_(RECIPE_ID));
            if (this.f_58857_ != null) {
                StockpotRecipe stockpotRecipe = (StockpotRecipe)this.f_58857_.m_7465_().m_44054_(ModRecipes.STOCKPOT_RECIPE).get(this.recipeId);
                this.recipe = Objects.requireNonNullElseGet(stockpotRecipe, StockpotRecipeSerializer::getEmptyRecipe);
            }
        }
        if (tag.m_128441_(SOUP_BASE_ID)) {
            this.soupBaseId = ResourceLocation.m_135820_((String)tag.m_128461_(SOUP_BASE_ID));
        }
        if (tag.m_128441_(RESULT)) {
            this.result = ItemStack.m_41712_((CompoundTag)tag.m_128469_(RESULT));
        }
        this.status = tag.m_128451_(STATUS);
        this.currentTick = tag.m_128451_(CURRENT_TICK);
        this.takeoutCount = tag.m_128451_(TAKEOUT_COUNT);
        if (tag.m_128441_(LID_ITEM)) {
            this.lidItem = ItemStack.m_41712_((CompoundTag)tag.m_128469_(LID_ITEM));
        }
    }

    public boolean isEmpty() {
        for (ItemStack stack : this.inputs) {
            if (stack.m_41619_()) continue;
            return false;
        }
        return true;
    }

    public NonNullList<ItemStack> getInputs() {
        return this.inputs;
    }

    @Override
    public int getStatus() {
        return this.status;
    }

    public int getTakeoutCount() {
        return this.takeoutCount;
    }

    public ItemStack getResult() {
        return this.result;
    }

    public ResourceLocation getSoupBaseId() {
        return this.soupBaseId;
    }

    @Nullable
    public ISoupBase getSoupBase() {
        return SoupBaseManager.getSoupBase(this.soupBaseId);
    }

    public ItemStack getLidItem() {
        return this.lidItem;
    }

    public void setLidItem(ItemStack lidItem) {
        this.lidItem = lidItem;
    }
}

