/*
 * Decompiled with CFR 0.152.
 */
package com.github.ysbbbbbb.kaleidoscopecookery.block.misc;

import com.github.ysbbbbbb.kaleidoscopecookery.blockentity.decoration.RecipeBlockEntity;
import com.github.ysbbbbbb.kaleidoscopecookery.init.ModSoundType;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.FaceAttachedHorizontalDirectionalBlock;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.AttachFace;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class RecipeBlock
extends FaceAttachedHorizontalDirectionalBlock
implements EntityBlock,
SimpleWaterloggedBlock {
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    private static final VoxelShape CEILING_AABB_X = Block.m_49796_((double)1.5, (double)15.75, (double)3.0, (double)14.5, (double)16.0, (double)13.0);
    private static final VoxelShape CEILING_AABB_Z = Block.m_49796_((double)3.0, (double)15.75, (double)1.5, (double)13.0, (double)16.0, (double)14.5);
    private static final VoxelShape FLOOR_AABB_X = Block.m_49796_((double)1.5, (double)0.0, (double)3.0, (double)14.5, (double)0.25, (double)13.0);
    private static final VoxelShape FLOOR_AABB_Z = Block.m_49796_((double)3.0, (double)0.0, (double)1.5, (double)13.0, (double)0.25, (double)14.5);
    private static final VoxelShape NORTH_AABB = Block.m_49796_((double)3.0, (double)1.5, (double)15.75, (double)13.0, (double)14.5, (double)16.0);
    private static final VoxelShape SOUTH_AABB = Block.m_49796_((double)3.0, (double)1.5, (double)0.0, (double)13.0, (double)14.5, (double)0.25);
    private static final VoxelShape WEST_AABB = Block.m_49796_((double)15.75, (double)1.5, (double)3.0, (double)16.0, (double)14.5, (double)13.0);
    private static final VoxelShape EAST_AABB = Block.m_49796_((double)0.0, (double)1.5, (double)3.0, (double)0.25, (double)14.5, (double)13.0);

    public RecipeBlock() {
        super(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283832_).m_60966_().m_60955_().m_60918_(ModSoundType.RECIPE_BLOCK));
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)f_54117_, (Comparable)Direction.NORTH)).m_61124_((Property)f_53179_, (Comparable)AttachFace.WALL)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        if (hand != InteractionHand.MAIN_HAND) {
            return InteractionResult.PASS;
        }
        ItemStack mainHandItem = player.m_21205_();
        if (!mainHandItem.m_41619_()) {
            return InteractionResult.PASS;
        }
        if (level.f_46443_) {
            return InteractionResult.SUCCESS;
        }
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof RecipeBlockEntity) {
            RecipeBlockEntity recipeBlockEntity = (RecipeBlockEntity)blockEntity;
            ItemStack itemStack = recipeBlockEntity.getItems().getStackInSlot(0);
            if (itemStack.m_41619_()) {
                return InteractionResult.PASS;
            }
            player.m_21008_(hand, itemStack.m_41777_());
            level.m_7731_(pos, Blocks.f_50016_.m_49966_(), 3);
            level.m_5594_(null, pos, ModSoundType.RECIPE_BLOCK.m_56775_(), player.m_5720_(), 1.0f, 1.0f);
            return InteractionResult.SUCCESS;
        }
        return super.m_6227_(state, level, pos, player, hand, hitResult);
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState neighborState, LevelAccessor levelAccessor, BlockPos pos, BlockPos neighborPos) {
        if (((Boolean)state.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            levelAccessor.m_186469_(pos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)levelAccessor));
        }
        return super.m_7417_(state, direction, neighborState, levelAccessor, pos, neighborPos);
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        Direction facing = (Direction)state.m_61143_((Property)f_54117_);
        return switch ((AttachFace)state.m_61143_((Property)f_53179_)) {
            case AttachFace.FLOOR -> {
                if (facing.m_122434_() == Direction.Axis.X) {
                    yield FLOOR_AABB_X;
                }
                yield FLOOR_AABB_Z;
            }
            case AttachFace.WALL -> {
                switch (facing) {
                    default: {
                        throw new IncompatibleClassChangeError();
                    }
                    case EAST: {
                        yield EAST_AABB;
                    }
                    case WEST: {
                        yield WEST_AABB;
                    }
                    case SOUTH: {
                        yield SOUTH_AABB;
                    }
                    case NORTH: 
                    case UP: 
                    case DOWN: 
                }
                yield NORTH_AABB;
            }
            default -> facing.m_122434_() == Direction.Axis.X ? CEILING_AABB_X : CEILING_AABB_Z;
        };
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        FluidState fluidState = context.m_43725_().m_6425_(context.m_8083_());
        BlockState stateForPlacement = super.m_5573_(context);
        if (stateForPlacement != null) {
            return (BlockState)stateForPlacement.m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidState.m_76152_() == Fluids.f_76193_));
        }
        return null;
    }

    public void m_6402_(Level pLevel, BlockPos pPos, BlockState pState, @Nullable LivingEntity livingEntity, ItemStack stack) {
        BlockEntity blockEntity;
        if (!pLevel.f_46443_ && (blockEntity = pLevel.m_7702_(pPos)) instanceof RecipeBlockEntity) {
            RecipeBlockEntity recipeBlockEntity = (RecipeBlockEntity)blockEntity;
            recipeBlockEntity.getItems().setStackInSlot(0, stack.m_255036_(1));
        }
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, BlockGetter level, BlockPos pos, Player player) {
        RecipeBlockEntity recipeBlockEntity;
        ItemStack itemStack;
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof RecipeBlockEntity && !(itemStack = (recipeBlockEntity = (RecipeBlockEntity)blockEntity).getItems().getStackInSlot(0)).m_41619_()) {
            return itemStack.m_41777_();
        }
        return super.getCloneItemStack(state, target, level, pos, player);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.m_61104_(new Property[]{f_54117_, f_53179_, WATERLOGGED});
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    public List<ItemStack> m_49635_(BlockState state, LootParams.Builder lootParamsBuilder) {
        List drops = super.m_49635_(state, lootParamsBuilder);
        BlockEntity parameter = (BlockEntity)lootParamsBuilder.m_287261_(LootContextParams.f_81462_);
        if (parameter instanceof RecipeBlockEntity) {
            RecipeBlockEntity recipeBlock = (RecipeBlockEntity)parameter;
            drops.add(recipeBlock.getItems().getStackInSlot(0).m_255036_(1));
        }
        return drops;
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pPos, BlockState pState) {
        return new RecipeBlockEntity(pPos, pState);
    }
}

