/*
 * Decompiled with CFR 0.152.
 */
package com.github.ysbbbbbb.kaleidoscopecookery.block.kitchen;

import com.github.ysbbbbbb.kaleidoscopecookery.init.ModItems;
import com.github.ysbbbbbb.kaleidoscopecookery.init.ModTrigger;
import com.github.ysbbbbbb.kaleidoscopecookery.init.tag.TagMod;
import com.github.ysbbbbbb.kaleidoscopecookery.item.KitchenShovelItem;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.Nullable;

public class StoveBlock
extends HorizontalDirectionalBlock {
    public static final BooleanProperty LIT = BlockStateProperties.f_61443_;

    public StoveBlock() {
        super(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283947_).m_60918_(SoundType.f_56742_).m_60999_().m_60953_(state -> (Boolean)state.m_61143_((Property)LIT) != false ? 13 : 0).m_60977_().m_60913_(1.5f, 6.0f));
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)f_54117_, (Comparable)Direction.SOUTH)).m_61124_((Property)LIT, (Comparable)Boolean.valueOf(false)));
    }

    public void m_214162_(BlockState state, Level level, BlockPos pos, RandomSource random) {
        if (((Boolean)state.m_61143_((Property)LIT)).booleanValue()) {
            double x = (double)pos.m_123341_() + 0.5;
            double y = (double)pos.m_123342_() + 0.5;
            double z = (double)pos.m_123343_() + 0.5;
            if (random.m_188503_(10) == 0) {
                level.m_7785_(x, y, z, SoundEvents.f_11784_, SoundSource.BLOCKS, 0.5f + random.m_188501_(), random.m_188501_() * 0.7f + 0.6f, false);
            }
            level.m_7106_((ParticleOptions)ParticleTypes.f_123762_, x + random.m_188500_() / 3.0 * (double)(random.m_188499_() ? 1 : -1), y + 0.5 + random.m_188500_() / 3.0, z + random.m_188500_() / 3.0 * (double)(random.m_188499_() ? 1 : -1), 0.0, 0.02, 0.0);
            Direction direction = (Direction)state.m_61143_((Property)f_54117_);
            Direction.Axis axis = direction.m_122434_();
            double offsetRandom = random.m_188500_() * 0.6 - 0.3;
            double xOffset = axis == Direction.Axis.X ? (double)direction.m_122429_() * 0.52 : offsetRandom;
            double yOffset = 0.25 + random.m_188500_() * 6.0 / 16.0;
            double zOffset = axis == Direction.Axis.Z ? (double)direction.m_122431_() * 0.52 : offsetRandom;
            level.m_7106_((ParticleOptions)ParticleTypes.f_123744_, x + xOffset, (double)pos.m_123342_() + yOffset, z + zOffset, 0.0, 0.0, 0.0);
        }
    }

    public void m_213898_(BlockState blockState, ServerLevel level, BlockPos pos, RandomSource random) {
        if (((Boolean)blockState.m_61143_((Property)LIT)).booleanValue() && level.m_46758_(pos.m_7494_())) {
            level.m_46597_(pos, (BlockState)blockState.m_61124_((Property)LIT, (Comparable)Boolean.valueOf(false)));
            level.m_5594_(null, pos, SoundEvents.f_11937_, SoundSource.BLOCKS, 1.0f, 1.0f);
        }
    }

    public void m_141947_(Level level, BlockPos pos, BlockState state, Entity entity) {
        if (((Boolean)state.m_61143_((Property)LIT)).booleanValue() && level instanceof ServerLevel) {
            LivingEntity livingEntity;
            ServerLevel serverLevel = (ServerLevel)level;
            if (entity instanceof LivingEntity && !EnchantmentHelper.m_44938_((LivingEntity)(livingEntity = (LivingEntity)entity)) && !livingEntity.m_20161_() && !livingEntity.m_20147_() && livingEntity.f_19802_ <= 10) {
                Player player;
                if (livingEntity instanceof Player && (player = (Player)livingEntity).m_7500_()) {
                    return;
                }
                livingEntity.f_19802_ = 20;
                serverLevel.m_269196_((Entity)livingEntity, livingEntity.m_269291_().m_269047_());
            }
        }
        super.m_141947_(level, pos, state, entity);
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState neighborState, LevelAccessor levelAccessor, BlockPos pos, BlockPos neighborPos) {
        if (((Boolean)state.m_61143_((Property)LIT)).booleanValue() && levelAccessor.m_46801_(pos.m_7494_()) && levelAccessor instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)levelAccessor;
            serverLevel.m_46597_(pos, (BlockState)state.m_61124_((Property)LIT, (Comparable)Boolean.valueOf(false)));
            serverLevel.m_5594_(null, pos, SoundEvents.f_11937_, SoundSource.BLOCKS, 1.0f, 1.0f);
        }
        return super.m_7417_(state, direction, neighborState, levelAccessor, pos, neighborPos);
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        ItemStack itemInHand = player.m_21120_(hand);
        if (!((Boolean)state.m_61143_((Property)LIT)).booleanValue() && itemInHand.m_204117_(TagMod.LIT_STOVE)) {
            level.m_46597_(pos, (BlockState)state.m_61124_((Property)LIT, (Comparable)Boolean.valueOf(true)));
            if (itemInHand.m_150930_(Items.f_42613_)) {
                level.m_5594_(player, pos, SoundEvents.f_11874_, SoundSource.BLOCKS, 1.0f, level.m_213780_().m_188501_() * 0.4f + 0.8f);
                itemInHand.m_41774_(1);
            } else {
                level.m_5594_(player, pos, SoundEvents.f_11942_, SoundSource.BLOCKS, 1.0f, level.m_213780_().m_188501_() * 0.4f + 0.8f);
                itemInHand.m_41622_(1, (LivingEntity)player, p -> p.m_21190_(hand));
            }
            ModTrigger.EVENT.trigger((LivingEntity)player, "lit_the_stove");
            return InteractionResult.SUCCESS;
        }
        if (((Boolean)state.m_61143_((Property)LIT)).booleanValue() && itemInHand.m_204117_(TagMod.EXTINGUISH_STOVE)) {
            if (itemInHand.m_150930_((Item)ModItems.KITCHEN_SHOVEL.get()) && KitchenShovelItem.hasOil(itemInHand)) {
                KitchenShovelItem.setHasOil(itemInHand, false);
            }
            level.m_46597_(pos, (BlockState)state.m_61124_((Property)LIT, (Comparable)Boolean.valueOf(false)));
            level.m_5594_(player, pos, SoundEvents.f_11937_, SoundSource.BLOCKS, 0.5f, 2.6f + (level.f_46441_.m_188501_() - level.f_46441_.m_188501_()) * 0.8f);
            itemInHand.m_41622_(1, (LivingEntity)player, p -> p.m_21190_(hand));
            return InteractionResult.SUCCESS;
        }
        return super.m_6227_(state, level, pos, player, hand, hitResult);
    }

    public void m_5581_(Level level, BlockState state, BlockHitResult hitResult, Projectile projectile) {
        BlockPos hitBlockPos = hitResult.m_82425_();
        if (!level.f_46443_ && projectile.m_6060_() && projectile.m_142265_(level, hitBlockPos) && !((Boolean)state.m_61143_((Property)LIT)).booleanValue()) {
            level.m_7731_(hitBlockPos, (BlockState)state.m_61124_((Property)BlockStateProperties.f_61443_, (Comparable)Boolean.valueOf(true)), 11);
            Entity entity = projectile.m_19749_();
            if (entity instanceof Player) {
                Player player = (Player)entity;
                ModTrigger.EVENT.trigger((LivingEntity)player, "lit_the_stove");
            }
        }
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)this.m_49966_().m_61124_((Property)f_54117_, (Comparable)context.m_8125_().m_122424_());
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{LIT, f_54117_});
    }

    public void m_5871_(ItemStack pStack, @Nullable BlockGetter pLevel, List<Component> pTooltip, TooltipFlag pFlag) {
        pTooltip.add((Component)Component.m_237115_((String)"tooltip.kaleidoscope_cookery.stove").m_130940_(ChatFormatting.GRAY));
    }

    @Nullable
    public BlockPathTypes getBlockPathType(BlockState state, BlockGetter level, BlockPos pos, @Nullable Mob mob) {
        return BlockPathTypes.DANGER_FIRE;
    }
}

