/*
 * Decompiled with CFR 0.152.
 */
package com.github.ysbbbbbb.kaleidoscopecookery.block.kitchen;

import com.github.ysbbbbbb.kaleidoscopecookery.init.ModItems;
import com.github.ysbbbbbb.kaleidoscopecookery.item.KitchenShovelItem;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EnamelBasinBlock
extends Block
implements SimpleWaterloggedBlock {
    public static final int MAX_OIL_COUNT = 12;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    public static final BooleanProperty HAS_LID = BooleanProperty.m_61465_((String)"has_lid");
    public static final IntegerProperty OIL_COUNT = IntegerProperty.m_61631_((String)"oil_count", (int)0, (int)12);
    private static final VoxelShape AABB_NO_LID = Block.m_49796_((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)5.0, (double)13.0);
    private static final VoxelShape AABB = Shapes.m_83124_((VoxelShape)AABB_NO_LID, (VoxelShape[])new VoxelShape[]{Block.m_49796_((double)2.5, (double)5.0, (double)2.5, (double)13.5, (double)6.0, (double)13.5), Block.m_49796_((double)7.0, (double)6.0, (double)7.0, (double)9.0, (double)7.0, (double)9.0)});

    public EnamelBasinBlock() {
        super(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283947_).m_280658_(NoteBlockInstrument.BELL).m_60913_(1.0f, 1.5f).m_60918_(SoundType.f_56762_));
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)HAS_LID, (Comparable)Boolean.valueOf(true))).m_61124_((Property)OIL_COUNT, (Comparable)Integer.valueOf(12)));
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState neighborState, LevelAccessor levelAccessor, BlockPos pos, BlockPos neighborPos) {
        if (((Boolean)state.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            levelAccessor.m_186469_(pos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)levelAccessor));
        }
        return super.m_7417_(state, direction, neighborState, levelAccessor, pos, neighborPos);
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        ItemStack mainHandItem;
        if (hand != InteractionHand.MAIN_HAND) {
            super.m_6227_(state, level, pos, player, hand, hitResult);
        }
        if ((mainHandItem = player.m_21205_()).m_150930_(Items.f_42398_)) {
            float pitch = 0.6f + (float)Math.random() * 0.2f;
            level.m_5594_(player, pos, SoundEvents.f_12025_, SoundSource.BLOCKS, 2.0f, pitch);
            return InteractionResult.SUCCESS;
        }
        boolean hasLid = (Boolean)state.m_61143_((Property)HAS_LID);
        if (hasLid) {
            level.m_5594_(player, pos, SoundEvents.f_12025_, SoundSource.BLOCKS, 0.8f, 0.8f);
            level.m_46597_(pos, (BlockState)state.m_61124_((Property)HAS_LID, (Comparable)Boolean.valueOf(false)));
            return InteractionResult.SUCCESS;
        }
        if (mainHandItem.m_41619_()) {
            level.m_5594_(player, pos, SoundEvents.f_12025_, SoundSource.BLOCKS, 0.8f, 0.4f);
            level.m_46597_(pos, (BlockState)state.m_61124_((Property)HAS_LID, (Comparable)Boolean.valueOf(true)));
            return InteractionResult.SUCCESS;
        }
        if (mainHandItem.m_150930_((Item)ModItems.OIL.get())) {
            int value = (Integer)state.m_61143_((Property)OIL_COUNT);
            if (value >= 12) {
                return InteractionResult.FAIL;
            }
            int needCount = 12 - value;
            int consumeCount = Math.min(needCount, mainHandItem.m_41613_());
            level.m_5594_(player, pos, SoundEvents.f_11964_, SoundSource.BLOCKS, 0.8f, 0.8f);
            mainHandItem.m_41774_(consumeCount);
            level.m_46597_(pos, (BlockState)state.m_61124_((Property)OIL_COUNT, (Comparable)Integer.valueOf(value + consumeCount)));
            return InteractionResult.SUCCESS;
        }
        if (mainHandItem.m_150930_((Item)ModItems.KITCHEN_SHOVEL.get())) {
            return this.onShovelClick(state, level, pos, player, mainHandItem);
        }
        return super.m_6227_(state, level, pos, player, hand, hitResult);
    }

    @NotNull
    private InteractionResult onShovelClick(BlockState state, Level level, BlockPos pos, Player player, ItemStack mainHandItem) {
        int value = (Integer)state.m_61143_((Property)OIL_COUNT);
        boolean shovelHasOil = KitchenShovelItem.hasOil(mainHandItem);
        if (shovelHasOil) {
            if (value >= 12) {
                return InteractionResult.FAIL;
            }
            level.m_5594_(player, pos, SoundEvents.f_11964_, SoundSource.BLOCKS, 0.8f, 0.8f);
            KitchenShovelItem.setHasOil(mainHandItem, false);
            level.m_46597_(pos, (BlockState)state.m_61124_((Property)OIL_COUNT, (Comparable)Integer.valueOf(value + 1)));
            return InteractionResult.SUCCESS;
        }
        if (value == 0) {
            level.m_46953_(pos, true, (Entity)player);
            return InteractionResult.SUCCESS;
        }
        level.m_5594_(player, pos, SoundEvents.f_11964_, SoundSource.BLOCKS, 0.8f, 1.2f);
        KitchenShovelItem.setHasOil(mainHandItem, true);
        level.m_46597_(pos, (BlockState)state.m_61124_((Property)OIL_COUNT, (Comparable)Integer.valueOf(value - 1)));
        return InteractionResult.SUCCESS;
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        FluidState fluidState = context.m_43725_().m_6425_(context.m_8083_());
        return (BlockState)this.m_49966_().m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidState.m_76152_() == Fluids.f_76193_));
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{WATERLOGGED, HAS_LID, OIL_COUNT});
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter blockGetter, BlockPos pos, CollisionContext collisionContext) {
        return (Boolean)state.m_61143_((Property)HAS_LID) != false ? AABB : AABB_NO_LID;
    }

    public boolean m_7278_(BlockState state) {
        return true;
    }

    public int m_6782_(BlockState state, Level level, BlockPos pos) {
        return (Integer)state.m_61143_((Property)OIL_COUNT);
    }

    public void m_5871_(ItemStack stack, @Nullable BlockGetter level, List<Component> tooltip, TooltipFlag flag) {
        tooltip.add((Component)Component.m_237115_((String)"tooltip.kaleidoscope_cookery.enamel_basin").m_130940_(ChatFormatting.GRAY));
    }
}

