/*
 * Decompiled with CFR 0.152.
 */
package me.towdium.jecharacters.utils;

import java.util.Collections;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.function.BiConsumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import me.towdium.jecharacters.JechConfig;
import me.towdium.pinin.DictLoader;
import me.towdium.pinin.PinIn;
import me.towdium.pinin.searchers.Searcher;
import me.towdium.pinin.searchers.TreeSearcher;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Match {
    private static final Logger LOGGER = LogManager.getLogger((String)"Jech Match");
    public static final PinIn context = new PinIn(new Loader()).config().accelerate(true).commit();
    static final Pattern p = Pattern.compile("a");
    static Set<TreeSearcher<?>> searchers = Collections.newSetFromMap(new WeakHashMap());

    public static <T> TreeSearcher<T> searcher() {
        TreeSearcher ret = new TreeSearcher(Searcher.Logic.CONTAIN, context);
        searchers.add(ret);
        return ret;
    }

    public static int rank(Object o, String s1, String s2) {
        return Match.contains(s1, (CharSequence)s2) ? 1 : 0;
    }

    public static String wrap(String s) {
        return JechConfig.enableQuote ? "\"" + s + "\"" : s;
    }

    public static boolean contains(String s, CharSequence cs) {
        boolean b = context.contains(s, cs.toString());
        if (JechConfig.enableVerbose) {
            LOGGER.info("contains(" + s + "," + cs + ")->" + b);
        }
        return b;
    }

    public static boolean contains(CharSequence a, CharSequence b, boolean c) {
        if (c) {
            return Match.contains(a.toString().toLowerCase(), (CharSequence)b.toString().toLowerCase());
        }
        return Match.contains(a, b);
    }

    public static boolean equals(String s, Object o) {
        boolean b;
        boolean bl = b = o instanceof String && context.matches(s, (String)o);
        if (JechConfig.enableVerbose) {
            LOGGER.info("contains(" + s + "," + o + ")->" + b);
        }
        return b;
    }

    public static boolean contains(CharSequence a, CharSequence b) {
        return Match.contains(a.toString(), b);
    }

    public static Matcher matcher(Pattern test, CharSequence name) {
        boolean result = (test.flags() & 2) != 0 || (test.flags() & 0x40) != 0 ? Match.matches(name.toString().toLowerCase(), test.toString().toLowerCase()) : Match.matches(name.toString(), test.toString());
        return result ? p.matcher("a") : p.matcher("");
    }

    public static boolean matches(String s1, String s2) {
        boolean start = s2.startsWith(".*");
        boolean end = s2.endsWith(".*");
        if (start && end && s2.length() < 4) {
            end = false;
        }
        if (start || end) {
            s2 = s2.substring(start ? 2 : 0, s2.length() - (end ? 2 : 0));
        }
        return Match.contains(s1, (CharSequence)s2);
    }

    public static void onConfigChange() {
        context.config().keyboard(JechConfig.enumKeyboard.get()).fAng2An(JechConfig.enableFAng2an).fEng2En(JechConfig.enableFEng2en).fIng2In(JechConfig.enableFIng2in).fZh2Z(JechConfig.enableFZh2z).fCh2C(JechConfig.enableFCh2c).fSh2S(JechConfig.enableFSh2s).fU2V(JechConfig.enableFU2v).commit();
        searchers.forEach(TreeSearcher::refresh);
    }

    private static class Loader
    extends DictLoader.Default {
        private Loader() {
        }

        @Override
        public void load(BiConsumer<Character, String[]> feed) {
            super.load(feed);
            feed.accept(Character.valueOf('\u9fcf'), new String[]{"mai4"});
            feed.accept(Character.valueOf('\u9fd4'), new String[]{"ge1"});
            feed.accept(Character.valueOf('\u9fed'), new String[]{"ni3"});
            feed.accept(Character.valueOf('\u9fec'), new String[]{"tian2"});
            feed.accept(Character.valueOf('\u9feb'), new String[]{"ao4"});
            feed.accept(Character.valueOf('\ue900'), new String[]{"lu2"});
            feed.accept(Character.valueOf('\ue901'), new String[]{"du4"});
            feed.accept(Character.valueOf('\ue902'), new String[]{"xi3"});
            feed.accept(Character.valueOf('\ue903'), new String[]{"bo1"});
            feed.accept(Character.valueOf('\ue904'), new String[]{"hei1"});
            feed.accept(Character.valueOf('\ue906'), new String[]{"da2"});
            feed.accept(Character.valueOf('\ue907'), new String[]{"lun2"});
            feed.accept(Character.valueOf('\ue910'), new String[]{"fu1"});
            feed.accept(Character.valueOf('\ue912'), new String[]{"li4"});
        }
    }
}

