/*
 * Decompiled with CFR 0.152.
 */
package me.towdium.jecharacters.asm;

import me.towdium.jecharacters.annotations.MethodsReturnNonnullByDefault;
import me.towdium.jecharacters.annotations.ParametersAreNonnullByDefault;
import org.objectweb.asm.tree.MethodNode;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class TransformTarget {
    private final String owner;
    private final String methodName;
    private final String methodDesc;

    public TransformTarget(String owner, String methodName, String methodDesc) {
        this.owner = owner;
        this.methodName = methodName;
        this.methodDesc = methodDesc;
    }

    public static TransformTarget of(String target) {
        target = target.replace(".", "/");
        String[] split = target.split(":", 2);
        String owner = split[0];
        String methodName = split[1].substring(0, split[1].indexOf("("));
        String methodDesc = split[1].substring(split[1].indexOf("("));
        return new TransformTarget(owner, methodName, methodDesc);
    }

    public String getOwner() {
        return this.owner;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public String getMethodDesc() {
        return this.methodDesc;
    }

    public boolean matches(String owner, MethodNode methodNode) {
        return this.owner.equals(owner) & methodNode.name.equals(this.methodName) && methodNode.desc.equals(this.methodDesc);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TransformTarget that = (TransformTarget)o;
        if (!this.owner.equals(that.owner)) {
            return false;
        }
        if (!this.methodName.equals(that.methodName)) {
            return false;
        }
        return this.methodDesc.equals(that.methodDesc);
    }

    public int hashCode() {
        int result = this.owner.hashCode();
        result = 31 * result + this.methodName.hashCode();
        result = 31 * result + this.methodDesc.hashCode();
        return result;
    }

    public String toString() {
        return "TransformTarget{owner='" + this.owner + "', methodName='" + this.methodName + "', methodDesc='" + this.methodDesc + "'}";
    }
}

