/*
 * Decompiled with CFR 0.152.
 */
package ocean.inventoryprotection.common.event;

import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ShieldItem;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.living.LivingExperienceDropEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import ocean.inventoryprotection.common.ModItems;
import ocean.inventoryprotection.common.config.ApplicationConfig;

@Mod.EventBusSubscriber(modid="inventoryprotection")
public class ModEvents {
    private static final String APPLICATION_NAME = "InventoryProtection_playerInventoryDrops";
    private static final String DROP_COUNT = "dropSize";
    private static final String DROP_PREFIX = "dropPrefix";
    private static final String DROP_LEVEL_POINT = "dropLevelPoint";

    @SubscribeEvent
    public static void onLivingDropsEvent(LivingDropsEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player) {
            List drops;
            Player player = (Player)livingEntity;
            if (ModEvents.container((Item)ModItems.PROTECTOR.get(), event.getDrops()) && (drops = event.getDrops().stream().map(res -> {
                if (!res.m_32055_().m_41619_()) {
                    return res;
                }
                return null;
            }).filter(Objects::nonNull).collect(Collectors.toList())).size() > 0) {
                event.getDrops().removeAll(drops);
                CompoundTag cmp = new CompoundTag();
                for (int i = 0; i < drops.size(); ++i) {
                    ItemStack stack = ((ItemEntity)drops.get(i)).m_32055_();
                    CompoundTag tagItem = stack.m_41739_(new CompoundTag());
                    cmp.m_128365_(DROP_PREFIX + i, (Tag)tagItem);
                }
                CompoundTag data = event.getEntity().getPersistentData();
                if (!data.m_128441_("PlayerPersisted")) {
                    data.m_128365_("PlayerPersisted", (Tag)new CompoundTag());
                }
                cmp.m_128405_(DROP_COUNT, drops.size());
                cmp.m_128405_(DROP_LEVEL_POINT, player.f_36079_);
                CompoundTag persist = data.m_128469_("PlayerPersisted");
                persist.m_128365_(APPLICATION_NAME, (Tag)cmp);
            }
        }
    }

    @SubscribeEvent
    public static void onLivingExperienceDropEvent(LivingExperienceDropEvent event) {
        if (((Boolean)ApplicationConfig.LEVEL.get()).booleanValue() && event.getEntity().getPersistentData().m_128441_("PlayerPersisted")) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onPlayerRespawn(PlayerEvent.PlayerRespawnEvent event) {
        Player player = event.getEntity();
        CompoundTag data = player.getPersistentData();
        if (data.m_128441_("PlayerPersisted")) {
            CompoundTag inventoryIndex = data.m_128469_("PlayerPersisted");
            CompoundTag allDrops = inventoryIndex.m_128469_(APPLICATION_NAME);
            int count = allDrops.m_128451_(DROP_COUNT);
            if (count > 0) {
                for (int i = 0; i < count; ++i) {
                    CompoundTag item = allDrops.m_128469_(DROP_PREFIX + i);
                    ItemStack stack = ItemStack.m_41712_((CompoundTag)item);
                    if (stack.m_41619_()) continue;
                    ItemStack copy = stack.m_41777_();
                    if (copy.m_41720_() == ModItems.PROTECTOR.get()) {
                        copy.m_41774_(1);
                    }
                    ModEvents.inventoryReset(player, copy);
                }
                if (((Boolean)ApplicationConfig.LEVEL.get()).booleanValue()) {
                    player.m_6756_(allDrops.m_128451_(DROP_LEVEL_POINT));
                }
                player.m_213846_((Component)Component.m_237113_((String)((String)ApplicationConfig.MESSAGE.get())));
            }
            inventoryIndex.m_128473_(APPLICATION_NAME);
        }
    }

    private static void inventoryReset(Player player, ItemStack copy) {
        if (copy.m_41720_() instanceof ArmorItem) {
            EquipmentSlot equipmentslot = Mob.m_147233_((ItemStack)copy);
            if (ModEvents.container((NonNullList<ItemStack>)player.m_150109_().f_35975_, copy)) {
                ModEvents.addInventory(player, copy);
            } else {
                player.m_8061_(equipmentslot, copy.m_41777_());
            }
        } else if (copy.m_41720_() instanceof ShieldItem) {
            EquipmentSlot equipmentslot = Mob.m_147233_((ItemStack)copy);
            if (ModEvents.container((NonNullList<ItemStack>)player.m_150109_().f_35976_, copy)) {
                ModEvents.addInventory(player, copy);
            } else {
                player.m_8061_(equipmentslot, copy.m_41777_());
            }
        } else {
            ModEvents.addInventory(player, copy);
        }
    }

    public static void addInventory(Player player, ItemStack itemStack) {
        if (!player.m_150109_().m_36054_(itemStack)) {
            player.m_36176_(itemStack, true);
        }
    }

    public static boolean container(Item item, Collection<ItemEntity> itemEntities) {
        for (ItemEntity itemEntity : itemEntities) {
            if (itemEntity.m_32055_().m_41720_() != item) continue;
            return true;
        }
        return false;
    }

    public static boolean container(NonNullList<ItemStack> itemStacks, ItemStack itemStack) {
        for (ItemStack stack : itemStacks) {
            if (!ItemStack.m_41656_((ItemStack)stack, (ItemStack)itemStack)) continue;
            return true;
        }
        return false;
    }
}

