/*
 * Decompiled with CFR 0.152.
 */
package net.lavabucket.hourglass.time.effects;

import java.util.stream.Stream;
import net.lavabucket.hourglass.config.HourglassConfig;
import net.lavabucket.hourglass.time.SleepStatus;
import net.lavabucket.hourglass.time.TimeContext;
import net.lavabucket.hourglass.time.effects.AbstractTimeEffect;
import net.lavabucket.hourglass.time.effects.EffectCondition;
import net.lavabucket.hourglass.wrappers.ServerLevelWrapper;
import net.lavabucket.hourglass.wrappers.ServerPlayerWrapper;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;

public class HungerTimeEffect
extends AbstractTimeEffect {
    @Override
    public void onTimeTick(TimeContext context) {
        EffectCondition condition = (EffectCondition)((Object)HourglassConfig.SERVER_CONFIG.hungerEffect.get());
        if (condition == EffectCondition.NEVER) {
            return;
        }
        ServerLevelWrapper level = context.getLevel();
        SleepStatus sleepStatus = context.getTimeService().sleepStatus;
        long extraTicks = context.getTimeDelta().longValue() - 1L;
        if (extraTicks <= 0L || condition == EffectCondition.SLEEPING && sleepStatus.allAwake()) {
            return;
        }
        Stream<ServerPlayerWrapper> playerStream = ((ServerLevel)level.get()).m_6907_().stream().map(ServerPlayerWrapper::new);
        if (condition == EffectCondition.SLEEPING) {
            playerStream = playerStream.filter(ServerPlayerWrapper::isSleeping);
        }
        playerStream.forEach(player -> HungerTimeEffect.tickHunger(player, extraTicks));
    }

    private static void tickHunger(ServerPlayerWrapper player, long ticks) {
        int i = 0;
        while ((long)i < ticks) {
            ((ServerPlayer)player.get()).m_36324_().m_38710_((Player)player.get());
            ++i;
        }
    }
}

