/*
 * Decompiled with CFR 0.152.
 */
package net.lavabucket.hourglass.client.gui;

import com.mojang.blaze3d.vertex.PoseStack;
import net.lavabucket.hourglass.client.gui.ScreenAlignment;
import net.lavabucket.hourglass.config.HourglassConfig;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.InBedChatScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.client.event.ScreenEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class SleepGui {
    private static ItemStack clock = new ItemStack((ItemLike)Items.f_42524_);

    @SubscribeEvent
    public static void onClientTick(TickEvent.ClientTickEvent event) {
        Minecraft minecraft = Minecraft.m_91087_();
        if (event.phase == TickEvent.Phase.START && ((Boolean)HourglassConfig.CLIENT_CONFIG.preventClockWobble.get()).booleanValue() && minecraft.f_91073_ != null && !minecraft.m_91104_() && SleepGui.clockEnabled()) {
            minecraft.m_91291_().m_174264_(clock, (Level)minecraft.f_91073_, (LivingEntity)minecraft.f_91074_, 0);
        }
    }

    @SubscribeEvent
    public static void onGuiEvent(ScreenEvent.Render.Post event) {
        if (event.getScreen() instanceof InBedChatScreen && SleepGui.clockEnabled()) {
            SleepGui.renderSleepInterface(event.getScreen(), event.getGuiGraphics());
        }
    }

    public static void renderSleepInterface(Screen screen, GuiGraphics guiGraphics) {
        int scale = (Integer)HourglassConfig.CLIENT_CONFIG.clockScale.get();
        int margin = (Integer)HourglassConfig.CLIENT_CONFIG.clockMargin.get();
        ScreenAlignment alignment = (ScreenAlignment)((Object)HourglassConfig.CLIENT_CONFIG.clockAlignment.get());
        float x = alignment == ScreenAlignment.TOP_LEFT || alignment == ScreenAlignment.CENTER_LEFT || alignment == ScreenAlignment.BOTTOM_LEFT ? (float)margin : (alignment == ScreenAlignment.TOP_CENTER || alignment == ScreenAlignment.CENTER_CENTER || alignment == ScreenAlignment.BOTTOM_CENTER ? (float)(screen.f_96543_ / 2 - scale / 2) : (float)(screen.f_96543_ - scale - margin));
        float y = alignment == ScreenAlignment.TOP_LEFT || alignment == ScreenAlignment.TOP_CENTER || alignment == ScreenAlignment.TOP_RIGHT ? (float)margin : (alignment == ScreenAlignment.CENTER_LEFT || alignment == ScreenAlignment.CENTER_CENTER || alignment == ScreenAlignment.CENTER_RIGHT ? (float)(screen.f_96544_ / 2 - scale / 2) : (float)(screen.f_96544_ - scale - margin));
        SleepGui.renderClock(guiGraphics, x, y, scale);
    }

    public static void renderClock(GuiGraphics guiGraphics, float x, float y, float scale) {
        PoseStack poseStack = guiGraphics.m_280168_();
        poseStack.m_85836_();
        poseStack.m_252880_(x, y, 0.0f);
        poseStack.m_85841_(scale /= 16.0f, scale, 0.0f);
        guiGraphics.m_280480_(clock, 0, 0);
        poseStack.m_85849_();
    }

    public static boolean clockEnabled() {
        return (Boolean)HourglassConfig.SERVER_CONFIG.enableSleepFeature.get() != false && (Boolean)HourglassConfig.SERVER_CONFIG.displayBedClock.get() != false;
    }
}

