/*
 * Decompiled with CFR 0.152.
 */
package mod.schnappdragon.habitat.core.event;

import mod.schnappdragon.habitat.core.registry.HabitatEffects;
import mod.schnappdragon.habitat.core.tags.HabitatDamageTypeTags;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.Stats;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.living.MobEffectEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="habitat")
public class HabitatEvents {
    @SubscribeEvent
    public static void onLivingAttack(LivingAttackEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity.m_21023_((MobEffect)HabitatEffects.PRICKLING.get()) && event.getSource().m_269533_(HabitatDamageTypeTags.PRICKLING_IMMUNE_TO)) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onLivingHurt(LivingHurtEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity.m_21023_((MobEffect)HabitatEffects.PRICKLING.get())) {
            DamageSource source = event.getSource();
            Entity directEntity = source.m_7640_();
            int lvl = livingEntity.m_21124_((MobEffect)HabitatEffects.PRICKLING.get()).m_19564_();
            if (directEntity != null && !source.m_269533_(HabitatDamageTypeTags.AVOIDS_PRICKLING) && livingEntity.m_217043_().m_188503_(4) < 1 + lvl) {
                directEntity.m_6469_(livingEntity.m_269291_().m_269374_((Entity)livingEntity), 1.0f + (float)livingEntity.m_217043_().m_188503_(1 + 2 * lvl));
            }
        }
    }

    @SubscribeEvent
    public static void onLivingDamage(LivingDamageEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity.m_21023_((MobEffect)HabitatEffects.BLAST_ENDURANCE.get()) && event.getSource().m_269533_(DamageTypeTags.f_268415_)) {
            DamageSource source = event.getSource();
            int lvl = Math.min(livingEntity.m_21124_((MobEffect)HabitatEffects.BLAST_ENDURANCE.get()).m_19564_(), 4);
            float dmg = Mth.m_14143_((float)(event.getAmount() * (0.8f - 0.2f * (float)lvl)));
            int res = (int)(event.getAmount() - dmg);
            event.setAmount(dmg);
            if (livingEntity instanceof ServerPlayer) {
                ((ServerPlayer)livingEntity).m_36222_(Stats.f_12934_, res * 10);
            } else if (source.m_7639_() instanceof ServerPlayer) {
                ((ServerPlayer)source.m_7639_()).m_36222_(Stats.f_12930_, res * 10);
            }
        }
    }

    @SubscribeEvent
    public static void onMobEffectAdded(MobEffectEvent.Added event) {
        if (event.getEntity().m_21023_((MobEffect)HabitatEffects.PROLONGATION.get())) {
            MobEffectInstance incoming = event.getEffectInstance();
            MobEffectInstance prolonged = new MobEffectInstance(incoming.m_19544_(), Mth.m_14165_((double)((double)incoming.m_19557_() * 1.2)));
            incoming.m_19558_(prolonged);
        }
    }
}

