/*
 * Decompiled with CFR 0.152.
 */
package mod.schnappdragon.habitat.core.dispenser;

import mod.schnappdragon.habitat.common.block.FairyRingMushroomBlock;
import mod.schnappdragon.habitat.common.block.FloweringBallCactusBlock;
import mod.schnappdragon.habitat.common.block.KabloomBushBlock;
import mod.schnappdragon.habitat.common.block.RafflesiaBlock;
import mod.schnappdragon.habitat.common.block.entity.RafflesiaBlockEntity;
import mod.schnappdragon.habitat.common.entity.projectile.ThrownKabloomFruit;
import mod.schnappdragon.habitat.common.entity.vehicle.HabitatBoat;
import mod.schnappdragon.habitat.core.dispenser.HabitatDispenseBoatBehavior;
import mod.schnappdragon.habitat.core.registry.HabitatBlocks;
import mod.schnappdragon.habitat.core.registry.HabitatItems;
import mod.schnappdragon.habitat.core.registry.HabitatSoundEvents;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.BlockSource;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.dispenser.AbstractProjectileDispenseBehavior;
import net.minecraft.core.dispenser.DefaultDispenseItemBehavior;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.core.dispenser.OptionalDispenseItemBehavior;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.SuspiciousStewItem;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.DispenserBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;

public class HabitatDispenseItemBehavior {
    private static DispenseItemBehavior SuspiciousStewBehavior;
    private static DispenseItemBehavior BowlItemBehavior;
    private static DispenseItemBehavior ShearsBehavior;

    public static void registerDispenserBehaviors() {
        SuspiciousStewBehavior = (DispenseItemBehavior)DispenserBlock.f_52661_.get(Items.f_42718_);
        BowlItemBehavior = (DispenseItemBehavior)DispenserBlock.f_52661_.get(Items.f_42399_);
        ShearsBehavior = (DispenseItemBehavior)DispenserBlock.f_52661_.get(Items.f_42574_);
        DispenserBlock.m_52672_((ItemLike)((ItemLike)HabitatItems.FAIRY_RING_MUSHROOM_BOAT.get()), (DispenseItemBehavior)new HabitatDispenseBoatBehavior(HabitatBoat.Type.FAIRY_RING_MUSHROOM));
        DispenserBlock.m_52672_((ItemLike)Items.f_42718_, (DispenseItemBehavior)new OptionalDispenseItemBehavior(){

            protected ItemStack m_7498_(BlockSource source, ItemStack stack) {
                BlockEntity blockEntity;
                BlockPos pos;
                ServerLevel worldIn = source.m_7727_();
                BlockState state = worldIn.m_8055_(pos = source.m_7961_().m_121945_((Direction)source.m_6414_().m_61143_((Property)DispenserBlock.f_52659_)));
                if (state.m_60713_((Block)HabitatBlocks.RAFFLESIA.get()) && (blockEntity = worldIn.m_7702_(pos)) instanceof RafflesiaBlockEntity) {
                    RafflesiaBlockEntity rafflesia = (RafflesiaBlockEntity)blockEntity;
                    if (!((Boolean)state.m_61143_((Property)RafflesiaBlock.HAS_STEW)).booleanValue()) {
                        CompoundTag tag = stack.m_41783_();
                        if (tag != null && tag.m_128425_("Effects", 9)) {
                            rafflesia.Effects = tag.m_128437_("Effects", 10);
                        }
                        worldIn.m_46597_(pos, (BlockState)state.m_61124_((Property)RafflesiaBlock.HAS_STEW, (Comparable)Boolean.valueOf(true)));
                        rafflesia.onChange((Level)worldIn, worldIn.m_8055_(pos));
                        worldIn.m_5594_(null, pos, (SoundEvent)HabitatSoundEvents.RAFFLESIA_SLURP.get(), SoundSource.BLOCKS, 1.0f, 0.8f + worldIn.f_46441_.m_188501_() * 0.4f);
                        worldIn.m_8767_(RafflesiaBlock.getParticle(rafflesia.Effects), (double)pos.m_123341_() + 0.5 + (2.0 * worldIn.f_46441_.m_188500_() - 1.0) / 3.0, (double)((float)pos.m_123342_() + 0.25f) + worldIn.f_46441_.m_188500_() / 2.0, (double)pos.m_123343_() + 0.5 + (2.0 * worldIn.f_46441_.m_188500_() - 1.0) / 3.0, 0, 0.0, 0.1, 0.0, 1.0);
                        worldIn.m_220407_(GameEvent.f_157769_, pos, GameEvent.Context.m_223722_((BlockState)state));
                        stack = new ItemStack((ItemLike)Items.f_42399_, 1);
                        this.m_123573_(true);
                        return stack;
                    }
                }
                if (SuspiciousStewBehavior != null) {
                    SuspiciousStewBehavior.m_6115_(source, stack);
                }
                this.m_123573_(false);
                return stack;
            }
        });
        DispenserBlock.m_52672_((ItemLike)Items.f_42399_, (DispenseItemBehavior)new OptionalDispenseItemBehavior(){

            protected ItemStack m_7498_(BlockSource source, ItemStack stack) {
                BlockEntity blockEntity;
                BlockPos pos;
                ServerLevel worldIn = source.m_7727_();
                BlockState state = worldIn.m_8055_(pos = source.m_7961_().m_121945_((Direction)source.m_6414_().m_61143_((Property)DispenserBlock.f_52659_)));
                if (state.m_60713_((Block)HabitatBlocks.RAFFLESIA.get()) && (blockEntity = worldIn.m_7702_(pos)) instanceof RafflesiaBlockEntity) {
                    RafflesiaBlockEntity rafflesia = (RafflesiaBlockEntity)blockEntity;
                    if (((Boolean)state.m_61143_((Property)RafflesiaBlock.HAS_STEW)).booleanValue()) {
                        ItemStack stew = new ItemStack((ItemLike)Items.f_42718_);
                        rafflesia.Effects.forEach(tag -> {
                            CompoundTag compound = (CompoundTag)tag;
                            SuspiciousStewItem.m_43258_((ItemStack)stew, (MobEffect)MobEffect.m_19453_((int)compound.m_128445_("EffectId")), (int)compound.m_128451_("EffectDuration"));
                        });
                        worldIn.m_46597_(pos, (BlockState)state.m_61124_((Property)RafflesiaBlock.HAS_STEW, (Comparable)Boolean.valueOf(false)));
                        rafflesia.Effects = RafflesiaBlock.getDefault();
                        rafflesia.onChange((Level)worldIn, worldIn.m_8055_(pos));
                        worldIn.m_5594_(null, pos, (SoundEvent)HabitatSoundEvents.RAFFLESIA_FILL_BOWL.get(), SoundSource.BLOCKS, 1.0f, 0.8f + worldIn.f_46441_.m_188501_() * 0.4f);
                        worldIn.m_220407_(GameEvent.f_157816_, pos, GameEvent.Context.m_223722_((BlockState)state));
                        this.m_123573_(true);
                        stack.m_41774_(1);
                        if (stack.m_41619_()) {
                            return stew;
                        }
                        if (((DispenserBlockEntity)source.m_8118_()).m_59237_(stew) < 0) {
                            new DefaultDispenseItemBehavior().m_6115_(source, stew);
                        }
                        return stack;
                    }
                }
                if (BowlItemBehavior != null) {
                    BowlItemBehavior.m_6115_(source, stack);
                }
                this.m_123573_(false);
                return stack;
            }
        });
        DispenserBlock.m_52672_((ItemLike)Items.f_42574_, (DispenseItemBehavior)new OptionalDispenseItemBehavior(){

            protected ItemStack m_7498_(BlockSource source, ItemStack stack) {
                BlockPos pos;
                ServerLevel worldIn = source.m_7727_();
                BlockState state = worldIn.m_8055_(pos = source.m_7961_().m_121945_((Direction)source.m_6414_().m_61143_((Property)DispenserBlock.f_52659_)));
                if (state.m_60713_((Block)HabitatBlocks.KABLOOM_BUSH.get()) && (Integer)state.m_61143_((Property)KabloomBushBlock.AGE) == 7) {
                    Block.m_49840_((Level)worldIn, (BlockPos)pos, (ItemStack)new ItemStack((ItemLike)HabitatItems.KABLOOM_FRUIT.get()));
                    worldIn.m_46597_(pos, (BlockState)state.m_61124_((Property)KabloomBushBlock.AGE, (Comparable)Integer.valueOf(3)));
                    worldIn.m_5594_(null, pos, (SoundEvent)HabitatSoundEvents.KABLOOM_BUSH_SHEAR.get(), SoundSource.BLOCKS, 1.0f, 0.8f + worldIn.f_46441_.m_188501_() * 0.4f);
                    if (stack.m_220157_(1, worldIn.m_213780_(), null)) {
                        stack.m_41764_(0);
                    }
                    worldIn.m_220407_(GameEvent.f_157781_, pos, GameEvent.Context.m_223722_((BlockState)state));
                    this.m_123573_(true);
                } else {
                    Block block = state.m_60734_();
                    if (block instanceof FloweringBallCactusBlock) {
                        FloweringBallCactusBlock cactus = (FloweringBallCactusBlock)block;
                        Block.m_49840_((Level)worldIn, (BlockPos)pos, (ItemStack)new ItemStack((ItemLike)cactus.getColor().getFlower()));
                        worldIn.m_46597_(pos, cactus.getColor().getBallCactus().m_49966_());
                        worldIn.m_5594_(null, pos, (SoundEvent)HabitatSoundEvents.FLOWERING_BALL_CACTUS_SHEAR.get(), SoundSource.BLOCKS, 1.0f, 0.8f + worldIn.f_46441_.m_188501_() * 0.4f);
                        if (stack.m_220157_(1, worldIn.m_213780_(), null)) {
                            stack.m_41764_(0);
                        }
                        worldIn.m_220407_(GameEvent.f_157781_, pos, GameEvent.Context.m_223722_((BlockState)state));
                        this.m_123573_(true);
                    } else if (state.m_60713_((Block)HabitatBlocks.FAIRY_RING_MUSHROOM.get()) && (Integer)state.m_61143_((Property)FairyRingMushroomBlock.MUSHROOMS) > 1) {
                        Block.m_49840_((Level)worldIn, (BlockPos)pos, (ItemStack)new ItemStack((ItemLike)state.m_60734_()));
                        worldIn.m_46597_(pos, (BlockState)state.m_61124_((Property)FairyRingMushroomBlock.MUSHROOMS, (Comparable)Integer.valueOf((Integer)state.m_61143_((Property)FairyRingMushroomBlock.MUSHROOMS) - 1)));
                        worldIn.m_5594_(null, pos, (SoundEvent)HabitatSoundEvents.FAIRY_RING_MUSHROOM_SHEAR.get(), SoundSource.BLOCKS, 1.0f, 0.8f + worldIn.f_46441_.m_188501_() * 0.4f);
                        if (stack.m_220157_(1, worldIn.m_213780_(), null)) {
                            stack.m_41764_(0);
                        }
                        worldIn.m_220407_(GameEvent.f_157781_, pos, GameEvent.Context.m_223722_((BlockState)state));
                        this.m_123573_(true);
                    } else {
                        return ShearsBehavior.m_6115_(source, stack);
                    }
                }
                return stack;
            }
        });
        DispenserBlock.m_52672_((ItemLike)((ItemLike)HabitatItems.KABLOOM_FRUIT.get()), (DispenseItemBehavior)new AbstractProjectileDispenseBehavior(){

            protected Projectile m_6895_(Level worldIn, Position position, ItemStack stackIn) {
                return (Projectile)Util.m_137469_((Object)((Object)new ThrownKabloomFruit(worldIn, position.m_7096_(), position.m_7098_(), position.m_7094_())), kabloomfruit -> kabloomfruit.m_37446_(stackIn));
            }

            protected float m_7101_() {
                return super.m_7101_() * 0.9f;
            }

            protected float m_7104_() {
                return super.m_7104_() * 0.5f;
            }
        });
    }
}

