/*
 * Decompiled with CFR 0.152.
 */
package mod.schnappdragon.habitat.common.levelgen.feature;

import com.mojang.serialization.Codec;
import mod.schnappdragon.habitat.common.levelgen.feature.configuration.HugeBallCactusConfiguration;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelWriter;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;

public class HugeBallCactusFeature
extends Feature<HugeBallCactusConfiguration> {
    public HugeBallCactusFeature(Codec<HugeBallCactusConfiguration> codec) {
        super(codec);
    }

    public boolean m_142674_(FeaturePlaceContext<HugeBallCactusConfiguration> context) {
        HugeBallCactusConfiguration config = (HugeBallCactusConfiguration)context.m_159778_();
        WorldGenLevel world = context.m_159774_();
        BlockPos pos = context.m_159777_();
        RandomSource rand = context.m_225041_();
        if (this.canPlace(world, pos, config)) {
            for (int i = 0; i <= 2; ++i) {
                this.placeLayer(world, pos, rand, i, config);
            }
            return true;
        }
        return false;
    }

    private boolean canPlace(WorldGenLevel world, BlockPos pos, HugeBallCactusConfiguration config) {
        int i;
        BlockPos.MutableBlockPos blockpos$mutable = new BlockPos.MutableBlockPos();
        blockpos$mutable.m_122154_((Vec3i)pos, 0, -1, 0);
        for (i = -1; i <= 1; ++i) {
            for (int j = -1; j <= 1; ++j) {
                blockpos$mutable.m_122154_((Vec3i)pos, i, -1, j);
                if (world.m_8055_((BlockPos)blockpos$mutable).m_204341_(config.canBePlacedOn())) continue;
                return false;
            }
        }
        for (i = 0; i <= 2; ++i) {
            blockpos$mutable.m_122154_((Vec3i)pos, 0, i, 0);
            if (world.m_8055_((BlockPos)blockpos$mutable).m_247087_()) continue;
            return false;
        }
        return true;
    }

    private void placeLayer(WorldGenLevel world, BlockPos pos, RandomSource rand, int layer, HugeBallCactusConfiguration config) {
        BlockPos.MutableBlockPos blockpos$mutable = new BlockPos.MutableBlockPos();
        for (int i = -1; i <= 1; ++i) {
            for (int j = -1; j <= 1; ++j) {
                if (layer > 1 && Mth.m_14040_((int)i) + Mth.m_14040_((int)j) == 2) continue;
                blockpos$mutable.m_122154_((Vec3i)pos, i, layer, j);
                this.setBlock(world, blockpos$mutable, rand, config);
            }
        }
    }

    protected void setBlock(WorldGenLevel world, BlockPos.MutableBlockPos pos, RandomSource rand, HugeBallCactusConfiguration config) {
        if (world.m_8055_((BlockPos)pos).m_247087_()) {
            BlockState state = (rand.m_188501_() < config.floweringCactusChance() ? config.floweringCactusProvider() : config.cactusProvider()).m_213972_(rand, (BlockPos)pos);
            this.m_5974_((LevelWriter)world, (BlockPos)pos, state);
        }
    }
}

