/*
 * Decompiled with CFR 0.152.
 */
package mod.schnappdragon.habitat.common.entity.vehicle;

import mod.schnappdragon.habitat.core.registry.HabitatEntityTypes;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.registries.ForgeRegistries;

public class HabitatBoat
extends Boat {
    private static final EntityDataAccessor<Integer> BOAT_TYPE = SynchedEntityData.m_135353_(HabitatBoat.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);

    public HabitatBoat(EntityType<? extends Boat> typeIn, Level worldIn) {
        super(typeIn, worldIn);
        this.f_19850_ = true;
    }

    public HabitatBoat(Level worldIn, double x, double y, double z) {
        this((EntityType<? extends Boat>)((EntityType)HabitatEntityTypes.BOAT.get()), worldIn);
        this.m_6034_(x, y, z);
        this.m_20256_(Vec3.f_82478_);
        this.f_19854_ = x;
        this.f_19855_ = y;
        this.f_19856_ = z;
    }

    public Type getHabitatBoatType() {
        return Type.byId((Integer)this.f_19804_.m_135370_(BOAT_TYPE));
    }

    public Item m_38369_() {
        return (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation("habitat", this.getHabitatBoatType().getName() + "_boat"));
    }

    public void setBoatType(Type boatType) {
        this.f_19804_.m_135381_(BOAT_TYPE, (Object)boatType.ordinal());
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(BOAT_TYPE, (Object)Type.FAIRY_RING_MUSHROOM.ordinal());
    }

    protected void m_7380_(CompoundTag compound) {
        compound.m_128359_("Type", this.getHabitatBoatType().getName());
    }

    protected void m_7378_(CompoundTag compound) {
        if (compound.m_128425_("Type", 8)) {
            this.setBoatType(Type.getTypeFromString(compound.m_128461_("Type")));
        }
    }

    protected void m_7840_(double y, boolean onGroundIn, BlockState state, BlockPos pos) {
        this.f_38281_ = this.m_20184_().f_82480_;
        if (!this.m_20159_()) {
            if (onGroundIn) {
                if (this.f_19789_ > 3.0f) {
                    if (this.f_38279_ != Boat.Status.ON_LAND) {
                        this.f_19789_ = 0.0f;
                        return;
                    }
                    this.m_142535_(this.f_19789_, 1.0f, this.m_269291_().m_268989_());
                    if (!this.m_9236_().f_46443_ && !this.m_213877_()) {
                        this.m_6074_();
                        if (this.m_9236_().m_46469_().m_46207_(GameRules.f_46137_)) {
                            Item planks = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation("habitat", this.getHabitatBoatType().getName() + "_planks"));
                            for (int i = 0; i < 3; ++i) {
                                this.m_19998_((ItemLike)planks);
                            }
                            for (int j = 0; j < 2; ++j) {
                                this.m_19998_((ItemLike)Items.f_42398_);
                            }
                        }
                    }
                }
                this.f_19789_ = 0.0f;
            } else if (!this.m_9236_().m_6425_(this.m_20183_().m_7495_()).m_205070_(FluidTags.f_13131_) && y < 0.0) {
                this.f_19789_ = (float)((double)this.f_19789_ - y);
            }
        }
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public static enum Type {
        FAIRY_RING_MUSHROOM("fairy_ring_mushroom");

        private final String name;

        private Type(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public static Type byId(int id) {
            Type[] types = Type.values();
            if (id < 0 || id >= types.length) {
                id = 0;
            }
            return types[id];
        }

        public static Type getTypeFromString(String nameIn) {
            Type[] types;
            for (Type type : types = Type.values()) {
                if (!type.getName().equals(nameIn)) continue;
                return type;
            }
            return types[0];
        }
    }
}

