/*
 * Decompiled with CFR 0.152.
 */
package mod.schnappdragon.habitat.common.entity.animal;

import mod.schnappdragon.habitat.core.registry.HabitatSoundEvents;
import mod.schnappdragon.habitat.core.tags.HabitatItemTags;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.JumpControl;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.ClimbOnTopOfPowderSnowGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class Pooka
extends Animal {
    private int jumpTicks;
    private int jumpDuration;
    public boolean wasOnGround;
    public int jumpDelayTicks;

    public Pooka(EntityType<Pooka> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        this.f_21343_ = new PookaJumpControl(this);
        this.f_21342_ = new PookaMoveControl(this);
        this.setSpeedModifier(0.0);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new ClimbOnTopOfPowderSnowGoal((Mob)this, this.m_9236_()));
        this.f_21345_.m_25352_(2, (Goal)new BreedGoal((Animal)this, 0.8));
        this.f_21345_.m_25352_(3, (Goal)new TemptGoal((PathfinderMob)this, 1.0, Ingredient.m_204132_(HabitatItemTags.POOKA_FOOD), false));
        this.f_21345_.m_25352_(6, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 0.6));
        this.f_21345_.m_25352_(11, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 10.0f));
    }

    protected float m_6118_() {
        Path path;
        float f = 0.6f;
        if (this.f_19862_ || this.f_21342_.m_24995_() && this.f_21342_.m_25001_() > this.m_20186_() + 0.5) {
            f = 1.0f;
        }
        if ((path = this.f_21344_.m_26570_()) != null && !path.m_77392_()) {
            Vec3 vec3 = path.m_77380_((Entity)this);
            if (vec3.f_82480_ > this.m_20186_() + 0.5) {
                f = 1.0f;
            }
        }
        if (this.f_21342_.m_24999_() <= 0.6) {
            f = 0.4f;
        }
        return f + this.m_285755_();
    }

    protected void m_6135_() {
        double d1;
        super.m_6135_();
        double d0 = this.f_21342_.m_24999_();
        if (d0 > 0.0 && (d1 = this.m_20184_().m_165925_()) < 0.01) {
            this.m_19920_(0.1f, new Vec3(0.0, 0.0, 1.0));
        }
        if (!this.m_9236_().f_46443_) {
            this.m_9236_().m_7605_((Entity)this, (byte)1);
        }
    }

    public float getJumpCompletion(float pPartialTick) {
        return this.jumpDuration == 0 ? 0.0f : ((float)this.jumpTicks + pPartialTick) / (float)this.jumpDuration;
    }

    public void setSpeedModifier(double pSpeedModifier) {
        this.m_21573_().m_26517_(pSpeedModifier);
        this.f_21342_.m_6849_(this.f_21342_.m_25000_(), this.f_21342_.m_25001_(), this.f_21342_.m_25002_(), pSpeedModifier);
    }

    public void m_6862_(boolean pJumping) {
        super.m_6862_(pJumping);
        if (pJumping) {
            this.m_5496_(this.getJumpSound(), this.m_6121_(), ((this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.2f + 1.0f) * 0.8f);
        }
    }

    public void startJumping() {
        this.m_6862_(true);
        this.jumpDuration = 10;
        this.jumpTicks = 0;
    }

    public void m_8024_() {
        if (this.jumpDelayTicks > 0) {
            --this.jumpDelayTicks;
        }
        if (this.m_20096_()) {
            PookaJumpControl pookaJumpControl;
            if (!this.wasOnGround) {
                this.m_6862_(false);
                this.checkLandingDelay();
            }
            if (!(pookaJumpControl = (PookaJumpControl)this.f_21343_).wantJump()) {
                if (this.f_21342_.m_24995_() && this.jumpDelayTicks == 0) {
                    Path path = this.f_21344_.m_26570_();
                    Vec3 vec3 = new Vec3(this.f_21342_.m_25000_(), this.f_21342_.m_25001_(), this.f_21342_.m_25002_());
                    if (path != null && !path.m_77392_()) {
                        vec3 = path.m_77380_((Entity)this);
                    }
                    this.facePoint(vec3.f_82479_, vec3.f_82481_);
                    this.startJumping();
                }
            } else if (!pookaJumpControl.canJump()) {
                this.enableJumpControl();
            }
        }
        this.wasOnGround = this.m_20096_();
    }

    public boolean m_5843_() {
        return false;
    }

    private void facePoint(double pX, double pZ) {
        this.m_146922_((float)(Mth.m_14136_((double)(pZ - this.m_20189_()), (double)(pX - this.m_20185_())) * 57.2957763671875) - 90.0f);
    }

    private void enableJumpControl() {
        ((PookaJumpControl)this.f_21343_).setCanJump(true);
    }

    private void disableJumpControl() {
        ((PookaJumpControl)this.f_21343_).setCanJump(false);
    }

    private void setLandingDelay() {
        this.jumpDelayTicks = this.f_21342_.m_24999_() < 2.2 ? 10 : 1;
    }

    private void checkLandingDelay() {
        this.setLandingDelay();
        this.disableJumpControl();
    }

    public void m_8107_() {
        super.m_8107_();
        if (this.jumpTicks != this.jumpDuration) {
            ++this.jumpTicks;
        } else if (this.jumpDuration != 0) {
            this.jumpTicks = 0;
            this.jumpDuration = 0;
            this.m_6862_(false);
        }
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 3.0).m_22268_(Attributes.f_22279_, (double)0.3f);
    }

    @Nullable
    public AgeableMob m_142606_(ServerLevel pLevel, AgeableMob pOtherParent) {
        return null;
    }

    public void m_7380_(CompoundTag pCompound) {
        super.m_7380_(pCompound);
    }

    public void m_7378_(CompoundTag pCompound) {
        super.m_7378_(pCompound);
    }

    protected SoundEvent getJumpSound() {
        return (SoundEvent)HabitatSoundEvents.POOKA_JUMP.get();
    }

    protected SoundEvent m_7515_() {
        return (SoundEvent)HabitatSoundEvents.POOKA_AMBIENT.get();
    }

    protected SoundEvent m_7975_(DamageSource damageSource) {
        return (SoundEvent)HabitatSoundEvents.POOKA_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)HabitatSoundEvents.POOKA_DEATH.get();
    }

    public boolean m_6898_(ItemStack stack) {
        return stack.m_204117_(HabitatItemTags.POOKA_FOOD);
    }

    public static boolean checkPookaSpawnRules(EntityType<Pooka> entityType, LevelAccessor world, MobSpawnType spawnType, BlockPos pos, RandomSource rand) {
        return world.m_8055_(pos.m_7495_()).m_204336_(BlockTags.f_184234_) && Pooka.m_186209_((BlockAndTintGetter)world, (BlockPos)pos);
    }

    public void m_7822_(byte pId) {
        if (pId == 1) {
            this.m_20076_();
            this.jumpDuration = 10;
            this.jumpTicks = 0;
        } else {
            super.m_7822_(pId);
        }
    }

    class PookaJumpControl
    extends JumpControl {
        private boolean canJump;

        public PookaJumpControl(Pooka pooka) {
            super((Mob)pooka);
        }

        public boolean wantJump() {
            return this.f_24897_;
        }

        public boolean canJump() {
            return this.canJump;
        }

        public void setCanJump(boolean pCanJump) {
            this.canJump = pCanJump;
        }

        public void m_8124_() {
            if (this.f_24897_) {
                Pooka.this.startJumping();
                this.f_24897_ = false;
            }
        }
    }

    class PookaMoveControl
    extends MoveControl {
        private double nextJumpSpeed;

        public PookaMoveControl(Pooka pooka) {
            super((Mob)pooka);
        }

        public void m_8126_() {
            if (Pooka.this.m_20096_() && !Pooka.this.f_20899_ && !((PookaJumpControl)Pooka.this.f_21343_).wantJump()) {
                Pooka.this.setSpeedModifier(0.0);
            } else if (this.m_24995_()) {
                Pooka.this.setSpeedModifier(this.nextJumpSpeed);
            }
            super.m_8126_();
        }

        public void m_6849_(double pX, double pY, double pZ, double pSpeed) {
            if (Pooka.this.m_20069_()) {
                pSpeed = 1.5;
            }
            super.m_6849_(pX, pY, pZ, pSpeed);
            if (pSpeed > 0.0) {
                this.nextJumpSpeed = pSpeed;
            }
        }
    }
}

