/*
 * Decompiled with CFR 0.152.
 */
package mod.schnappdragon.habitat.common.entity.animal;

import java.util.EnumSet;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import mod.schnappdragon.habitat.common.entity.animal.PasserineVariant;
import mod.schnappdragon.habitat.core.misc.HabitatCriterionTriggers;
import mod.schnappdragon.habitat.core.particles.ColorableParticleOption;
import mod.schnappdragon.habitat.core.registry.HabitatParticleTypes;
import mod.schnappdragon.habitat.core.registry.HabitatRegistries;
import mod.schnappdragon.habitat.core.registry.HabitatSoundEvents;
import mod.schnappdragon.habitat.core.tags.HabitatBlockTags;
import mod.schnappdragon.habitat.core.tags.HabitatItemTags;
import mod.schnappdragon.habitat.core.tags.PasserineVariantTags;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.BiomeTags;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.VariantHolder;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.FlyingMoveControl;
import net.minecraft.world.entity.ai.control.LookControl;
import net.minecraft.world.entity.ai.goal.ClimbOnTopOfPowderSnowGoal;
import net.minecraft.world.entity.ai.goal.FleeSunGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowMobGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.navigation.FlyingPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.util.LandRandomPos;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.FlyingAnimal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.Vec3;

public class Passerine
extends Animal
implements FlyingAnimal,
VariantHolder<PasserineVariant> {
    private static final EntityDataAccessor<String> DATA_VARIANT_ID = SynchedEntityData.m_135353_(Passerine.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    private static final EntityDataAccessor<Integer> PREEN_COUNTER = SynchedEntityData.m_135353_(Passerine.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> PECK_COUNTER = SynchedEntityData.m_135353_(Passerine.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> DATA_SLEEPING = SynchedEntityData.m_135353_(Passerine.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private int foodTicks;
    public float flap;
    public float flapSpeed;
    public float initialFlapSpeed;
    public float initialFlap;
    private float flapping = 1.0f;
    private float nextFlap = 1.0f;
    private boolean isWet;

    public Passerine(EntityType<? extends Passerine> passerine, Level worldIn) {
        super(passerine, worldIn);
        this.f_21342_ = new PasserineMoveControl(10, false);
        this.f_21365_ = new PasserineLookControl();
        this.m_21441_(BlockPathTypes.DANGER_FIRE, -1.0f);
        this.m_21441_(BlockPathTypes.DAMAGE_FIRE, -1.0f);
        this.m_21441_(BlockPathTypes.COCOA, -1.0f);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(0, (Goal)new ClimbOnTopOfPowderSnowGoal((Mob)this, this.m_9236_()));
        this.f_21345_.m_25352_(0, (Goal)new PanicGoal((PathfinderMob)this, 1.25));
        this.f_21345_.m_25352_(1, (Goal)new PasserineTemptGoal(1.0, Ingredient.m_204132_(HabitatItemTags.PASSERINE_FOOD), false));
        this.f_21345_.m_25352_(2, (Goal)new FindCoverGoal(1.25));
        this.f_21345_.m_25352_(3, (Goal)new SleepGoal());
        this.f_21345_.m_25352_(4, (Goal)new PreenGoal());
        this.f_21345_.m_25352_(4, (Goal)new PeckGoal());
        this.f_21345_.m_25352_(5, (Goal)new PasserineRandomFlyingGoal(1.0));
        this.f_21345_.m_25352_(6, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(6, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21345_.m_25352_(7, (Goal)new PasserineFollowMobGoal(1.0, 3.0f, 7.0f));
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 4.0).m_22268_(Attributes.f_22280_, (double)0.8f).m_22268_(Attributes.f_22279_, (double)0.16f);
    }

    public Vec3 m_7939_() {
        return new Vec3(0.0, (double)(0.5f * this.m_20192_()), (double)(this.m_20205_() * 0.3f));
    }

    protected float m_6431_(Pose pose, EntityDimensions size) {
        return size.f_20378_ * 0.5f;
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(PREEN_COUNTER, (Object)0);
        this.f_19804_.m_135372_(PECK_COUNTER, (Object)0);
        this.f_19804_.m_135372_(DATA_VARIANT_ID, (Object)"habitat:common_sparrow");
        this.f_19804_.m_135372_(DATA_SLEEPING, (Object)false);
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128359_("Variant", this.getVariantId());
        compound.m_128379_("Sleeping", this.isAsleep());
        compound.m_128405_("FoodTicks", this.foodTicks);
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.setVariantId(compound.m_128461_("Variant"));
        this.setSleeping(compound.m_128471_("Sleeping"));
        this.foodTicks = compound.m_128451_("FoodTicks");
    }

    public void setPreenCounter(int counter) {
        this.f_19804_.m_135381_(PREEN_COUNTER, (Object)counter);
    }

    public int getPreenCounter() {
        return (Integer)this.f_19804_.m_135370_(PREEN_COUNTER);
    }

    public boolean isPreening() {
        return this.getPreenCounter() > 0;
    }

    public void setPeckCounter(int counter) {
        this.f_19804_.m_135381_(PECK_COUNTER, (Object)counter);
    }

    public int getPeckCounter() {
        return (Integer)this.f_19804_.m_135370_(PECK_COUNTER);
    }

    public boolean isPecking() {
        return this.getPeckCounter() > 0;
    }

    public void setVariantId(String id) {
        this.f_19804_.m_135381_(DATA_VARIANT_ID, (Object)id);
    }

    public void setVariant(PasserineVariant variant) {
        this.setVariantId(Objects.requireNonNull(this.m_9236_().m_9598_().m_175515_(HabitatRegistries.Keys.PASSERINE_VARIANTS).m_7981_((Object)variant)).toString());
    }

    public String getVariantId() {
        return (String)this.f_19804_.m_135370_(DATA_VARIANT_ID);
    }

    @Nullable
    public PasserineVariant getVariant() {
        Registry registry = this.m_9236_().m_9598_().m_175515_(HabitatRegistries.Keys.PASSERINE_VARIANTS);
        ResourceLocation variant = new ResourceLocation(this.getVariantId());
        return (PasserineVariant)registry.m_7745_(variant);
    }

    public void setSleeping(boolean isSleeping) {
        this.f_19804_.m_135381_(DATA_SLEEPING, (Object)isSleeping);
    }

    public void sleep() {
        this.setSleeping(true);
    }

    public void wakeUp() {
        this.setSleeping(false);
    }

    public boolean isAsleep() {
        return (Boolean)this.f_19804_.m_135370_(DATA_SLEEPING);
    }

    public void setFoodTimer() {
        this.foodTicks = 6000;
    }

    protected void m_8024_() {
        if (this.foodTicks > 0) {
            --this.foodTicks;
        }
        super.m_8024_();
    }

    public void m_8107_() {
        super.m_8107_();
        this.calculateFlapping();
        if (this.isAsleep() || this.m_6107_()) {
            this.f_20899_ = false;
            this.f_20900_ = 0.0f;
            this.f_20902_ = 0.0f;
        }
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.m_20071_() || this.f_146808_) {
            this.isWet = true;
        }
        if (!this.m_9236_().f_46443_ && this.isAsleep() && (this.m_29443_() || this.m_9236_().m_46461_() || this.f_146808_ || this.isUnsafeAt(this.m_20183_()) || !this.canPerch())) {
            this.wakeUp();
        }
    }

    private boolean isUnsafeAt(BlockPos pos) {
        if (this.isGoldfish() || !this.m_9236_().m_46471_() || !this.m_9236_().m_45527_(pos)) {
            return false;
        }
        if (this.m_9236_().m_5452_(Heightmap.Types.MOTION_BLOCKING, pos).m_123342_() > pos.m_123342_()) {
            return false;
        }
        return ((Biome)this.m_9236_().m_204166_(pos).m_203334_()).m_264473_();
    }

    private boolean isActive() {
        return this.m_9236_().m_46461_() && !this.m_9236_().m_46471_();
    }

    private boolean isNotBusy() {
        return !this.isAsleep() && !this.isPreening() && !this.isPecking();
    }

    private boolean canPerch() {
        return this.m_9236_().m_8055_(this.m_20097_()).m_204336_(HabitatBlockTags.PASSERINES_PERCHABLE_ON);
    }

    protected PathNavigation m_6037_(Level pLevel) {
        FlyingPathNavigation flyingpathnavigation = new FlyingPathNavigation((Mob)this, pLevel);
        flyingpathnavigation.m_26440_(false);
        flyingpathnavigation.m_7008_(true);
        flyingpathnavigation.m_26443_(true);
        return flyingpathnavigation;
    }

    private void calculateFlapping() {
        this.initialFlap = this.flap;
        this.initialFlapSpeed = this.flapSpeed;
        this.flapSpeed = (float)((double)this.flapSpeed + (double)(!this.m_20096_() && !this.m_20159_() ? 4 : -1) * 0.3);
        this.flapSpeed = Mth.m_14036_((float)this.flapSpeed, (float)0.0f, (float)1.0f);
        if (!this.m_20096_() && this.flapping < 1.0f) {
            this.flapping = 1.0f;
        }
        this.flapping = (float)((double)this.flapping * 0.9);
        Vec3 vec3 = this.m_20184_();
        if (!this.m_20096_() && vec3.f_82480_ < 0.0) {
            this.m_20256_(vec3.m_82542_(1.0, 0.6, 1.0));
        }
        this.flap += this.flapping * 2.0f;
    }

    protected boolean m_142039_() {
        return this.f_146794_ > this.nextFlap;
    }

    protected void m_142043_() {
        this.m_5496_((SoundEvent)HabitatSoundEvents.PASSERINE_FLAP.get(), 0.1f, 1.0f);
        this.nextFlap = this.f_146794_ + this.flapSpeed / 2.0f;
        if (this.isRegularVariant() && this.f_19796_.m_188503_(30) == 0) {
            this.m_9236_().m_7605_((Entity)this, (byte)11);
        }
    }

    public boolean m_29443_() {
        return !this.m_20096_();
    }

    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (stack.m_204117_(HabitatItemTags.PASSERINE_FOOD) && this.isNotBusy()) {
            if (!this.m_9236_().f_46443_ && this.foodTicks == 0) {
                this.setFoodTimer();
                this.m_5634_(1.0f);
                this.m_142075_(player, hand, stack);
                this.m_9236_().m_7605_((Entity)this, (byte)13);
                this.m_146852_(GameEvent.f_223708_, (Entity)this);
                HabitatCriterionTriggers.FEED_PASSERINE.trigger((ServerPlayer)player);
                this.m_5496_((SoundEvent)HabitatSoundEvents.PASSERINE_AMBIENT.get(), 1.0f, this.m_6100_());
                return InteractionResult.SUCCESS;
            }
            if (this.m_9236_().f_46443_) {
                return InteractionResult.CONSUME;
            }
        }
        return super.m_6071_(player, hand);
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor worldIn, DifficultyInstance difficultyIn, MobSpawnType reason, @Nullable SpawnGroupData spawnDataIn, @Nullable CompoundTag dataTag) {
        PasserineVariant i = this.getVariantByBiome((LevelAccessor)worldIn);
        if (spawnDataIn instanceof PasserineGroupData) {
            PasserineGroupData data = (PasserineGroupData)((Object)spawnDataIn);
            i = data.variant;
        } else {
            spawnDataIn = new PasserineGroupData(i);
        }
        this.setVariant(i);
        return super.m_6518_(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
    }

    public PasserineVariant getVariantByBiome(LevelAccessor worldIn) {
        Holder biomeHolder = worldIn.m_204166_(this.m_20183_());
        Biome biome = (Biome)biomeHolder.m_203334_();
        TagKey<PasserineVariant> tag = biomeHolder.m_203565_(Biomes.f_48179_) ? PasserineVariantTags.ALL : (biomeHolder.m_203656_(BiomeTags.f_207610_) ? PasserineVariantTags.JUNGLE : (biome.m_47554_() >= 1.0f ? PasserineVariantTags.HOT : (biome.m_47554_() < 0.5f ? PasserineVariantTags.COLD : (biome.m_47554_() <= 0.6f ? PasserineVariantTags.TEMPERATE : PasserineVariantTags.COMMON))));
        Optional optionalVariant = worldIn.m_9598_().m_6632_(HabitatRegistries.Keys.PASSERINE_VARIANTS).flatMap(registry -> registry.m_203431_(tag)).flatMap(holders -> holders.m_213653_(this.f_19796_));
        if (optionalVariant.isPresent()) {
            Holder variant = (Holder)optionalVariant.get();
            return (PasserineVariant)variant.get();
        }
        return null;
    }

    public static boolean checkPasserineSpawnRules(EntityType<Passerine> type, LevelAccessor worldIn, MobSpawnType spawnType, BlockPos pos, RandomSource random) {
        return worldIn.m_8055_(pos.m_7495_()).m_204336_(HabitatBlockTags.PASSERINES_SPAWNABLE_ON) && Passerine.m_186209_((BlockAndTintGetter)worldIn, (BlockPos)pos);
    }

    public boolean m_6469_(DamageSource source, float amount) {
        if (this.m_6673_(source)) {
            return false;
        }
        if (!this.m_9236_().f_46443_) {
            if (this.isRegularVariant() && source.m_7640_() != null && !source.m_269533_(DamageTypeTags.f_268467_)) {
                this.m_9236_().m_7605_((Entity)this, (byte)12);
            }
            if (this.isAsleep()) {
                this.wakeUp();
            } else if (this.isPreening()) {
                this.setPreenCounter(0);
            } else if (this.isPecking()) {
                this.setPeckCounter(0);
            }
        }
        return super.m_6469_(source, amount);
    }

    public void m_8032_() {
        if (!this.isPreening() && !this.isPecking() && this.isActive()) {
            super.m_8032_();
            if (!this.m_9236_().f_46443_) {
                this.m_9236_().m_7605_((Entity)this, (byte)13);
            }
        }
    }

    public SoundEvent m_7515_() {
        return (SoundEvent)HabitatSoundEvents.PASSERINE_AMBIENT.get();
    }

    protected SoundEvent m_7975_(DamageSource source) {
        return (SoundEvent)HabitatSoundEvents.PASSERINE_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)HabitatSoundEvents.PASSERINE_DEATH.get();
    }

    protected void m_7355_(BlockPos pos, BlockState state) {
        this.m_5496_((SoundEvent)HabitatSoundEvents.PASSERINE_STEP.get(), 0.1f, 1.0f);
    }

    public float m_6100_() {
        return (this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.2f + 1.0f;
    }

    public void m_7822_(byte id) {
        switch (id) {
            case 11: {
                this.spawnFeathers(this.getFeather(), 1);
                break;
            }
            case 12: {
                this.spawnFeathers(this.getFeather(), 2);
                break;
            }
            case 13: {
                this.m_9236_().m_7106_((ParticleOptions)this.getNote(), this.m_20208_(0.5), 0.6 + this.m_20186_(), this.m_20262_(0.5), this.f_19796_.m_188500_(), 0.0, 0.0);
                break;
            }
            default: {
                super.m_7822_(id);
            }
        }
    }

    protected void spawnFeathers(ColorableParticleOption feather, int number) {
        for (int i = 0; i < number; ++i) {
            this.m_9236_().m_7106_((ParticleOptions)feather, this.m_20208_(0.5), this.m_20227_(this.f_19796_.m_188500_() * 0.75), this.m_20262_(0.5), this.f_19796_.m_188583_() * 0.01, 0.0, this.f_19796_.m_188583_() * 0.01);
        }
    }

    private ColorableParticleOption getFeather() {
        return new ColorableParticleOption((ParticleType<ColorableParticleOption>)((ParticleType)HabitatParticleTypes.FEATHER.get()), Vec3.m_82501_((int)this.getFeatherColor()).m_252839_());
    }

    private int getFeatherColor() {
        return this.getVariant() == null ? 7488818 : this.getVariant().featherColor();
    }

    private ColorableParticleOption getNote() {
        return new ColorableParticleOption((ParticleType<ColorableParticleOption>)((ParticleType)HabitatParticleTypes.NOTE.get()), Vec3.m_82501_((int)this.getNoteColor()).m_252839_());
    }

    private int getNoteColor() {
        return this.getVariant() == null ? 16730112 : this.getVariant().featherColor();
    }

    public boolean isRegularVariant() {
        return !this.isBerdly() && !this.isGoldfish() && !this.isTurkey() && !this.isFlapjack();
    }

    public boolean isBerdly() {
        return "Berdly".equals(ChatFormatting.m_126649_((String)this.m_7755_().getString()));
    }

    public boolean isGoldfish() {
        return this.getVariantId().equals("habitat:american_goldfinch") && "Goldfish".equals(ChatFormatting.m_126649_((String)this.m_7755_().getString()));
    }

    public boolean isTurkey() {
        return "Turkey".equals(ChatFormatting.m_126649_((String)this.m_7755_().getString()));
    }

    public boolean isFlapjack() {
        return this.getVariantId().equals("habitat:northern_cardinal") && "Flapjack".equals(ChatFormatting.m_126649_((String)this.m_7755_().getString()));
    }

    public void m_6667_(DamageSource source) {
        this.wakeUp();
        this.setPreenCounter(0);
        this.setPeckCounter(0);
        super.m_6667_(source);
    }

    public boolean m_7848_(Animal animal) {
        return false;
    }

    public boolean m_6898_(ItemStack stack) {
        return false;
    }

    @Nullable
    public Passerine getBreedOffspring(ServerLevel worldIn, AgeableMob passerine) {
        return null;
    }

    public boolean m_6162_() {
        return false;
    }

    public boolean m_142535_(float f, float f1, DamageSource source) {
        return false;
    }

    protected void m_7840_(double y, boolean onGround, BlockState state, BlockPos pps) {
    }

    public class PasserineMoveControl
    extends FlyingMoveControl {
        public PasserineMoveControl(int maxTurns, boolean hoversInPlace) {
            super((Mob)Passerine.this, maxTurns, hoversInPlace);
        }

        public void m_8126_() {
            if (Passerine.this.isNotBusy()) {
                super.m_8126_();
            }
        }
    }

    public class PasserineLookControl
    extends LookControl {
        public PasserineLookControl() {
            super((Mob)Passerine.this);
        }

        public void m_8128_() {
            if (Passerine.this.isNotBusy()) {
                super.m_8128_();
            }
        }
    }

    class PasserineTemptGoal
    extends TemptGoal {
        public PasserineTemptGoal(double speedModifier, Ingredient items, boolean canScare) {
            super((PathfinderMob)Passerine.this, speedModifier, items, canScare);
        }

        public boolean m_8036_() {
            return !Passerine.this.isAsleep() && super.m_8036_();
        }
    }

    class FindCoverGoal
    extends FleeSunGoal {
        public FindCoverGoal(double speedModifier) {
            super((PathfinderMob)Passerine.this, speedModifier);
        }

        public boolean m_8036_() {
            return Passerine.this.isUnsafeAt(Passerine.this.m_20183_()) && !this.isTargetPosDry() && this.m_25226_();
        }

        private boolean isTargetPosDry() {
            return Passerine.this.m_21573_().m_26572_() && !Passerine.this.isUnsafeAt(Passerine.this.m_21573_().m_26567_());
        }
    }

    class SleepGoal
    extends Goal {
        private static final int WAIT_TIME_BEFORE_SLEEP = SleepGoal.m_186073_((int)140);
        private int countdown;

        public SleepGoal() {
            this.countdown = Passerine.this.f_19796_.m_188503_(WAIT_TIME_BEFORE_SLEEP);
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK, Goal.Flag.JUMP));
        }

        public boolean m_8036_() {
            return Passerine.this.f_20900_ == 0.0f && Passerine.this.f_20901_ == 0.0f && Passerine.this.f_20902_ == 0.0f && (this.canSleep() || Passerine.this.isAsleep());
        }

        public boolean m_8045_() {
            return Passerine.this.isAsleep() && this.canSleep();
        }

        private boolean canSleep() {
            if (this.countdown > 0) {
                --this.countdown;
                return false;
            }
            if (Passerine.this.m_29443_() || Passerine.this.isPreening() || Passerine.this.isPecking() || Passerine.this.m_9236_().m_46461_() || Passerine.this.f_146808_) {
                return false;
            }
            return Passerine.this.canPerch();
        }

        public void m_8056_() {
            Passerine.this.sleep();
            Passerine.this.m_21573_().m_26573_();
        }

        public void m_8041_() {
            Passerine.this.wakeUp();
            this.countdown = Passerine.this.f_19796_.m_188503_(WAIT_TIME_BEFORE_SLEEP);
        }
    }

    class PreenGoal
    extends IdleGoal {
        public PreenGoal() {
            super(Passerine.this::getPreenCounter, Passerine.this::setPreenCounter, Passerine.this::isPreening);
        }

        @Override
        public boolean m_8036_() {
            if (Passerine.this.isWet) {
                this.setCountdown(0);
                Passerine.this.isWet = false;
            }
            return super.m_8036_();
        }

        @Override
        public void m_8037_() {
            super.m_8037_();
            if (Passerine.this.getPreenCounter() == this.m_183277_(20)) {
                Passerine.this.m_9236_().m_7605_((Entity)Passerine.this, (byte)11);
            }
        }
    }

    class PeckGoal
    extends IdleGoal {
        public PeckGoal() {
            super(Passerine.this::getPeckCounter, Passerine.this::setPeckCounter, Passerine.this::isPecking);
        }
    }

    class PasserineRandomFlyingGoal
    extends WaterAvoidingRandomStrollGoal {
        public PasserineRandomFlyingGoal(double speedModifier) {
            super((PathfinderMob)Passerine.this, speedModifier);
        }

        @Nullable
        protected Vec3 m_7037_() {
            if (Passerine.this.m_20069_() || Passerine.this.isUnsafeAt(Passerine.this.m_20183_())) {
                return LandRandomPos.m_148488_((PathfinderMob)Passerine.this, (int)15, (int)15);
            }
            float probability = Passerine.this.m_9236_().m_46461_() ? this.f_25985_ : 0.0f;
            Vec3 vec3 = Passerine.this.m_217043_().m_188501_() >= probability ? this.getPerchablePos() : null;
            vec3 = vec3 == null ? super.m_7037_() : vec3;
            return vec3 != null && !Passerine.this.isUnsafeAt(new BlockPos((int)vec3.m_7096_(), (int)vec3.m_7098_(), (int)vec3.m_7094_())) ? vec3 : null;
        }

        @Nullable
        private Vec3 getPerchablePos() {
            BlockPos blockpos = Passerine.this.m_20183_();
            BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
            BlockPos.MutableBlockPos blockpos$mutableblockpos1 = new BlockPos.MutableBlockPos();
            for (BlockPos blockpos1 : BlockPos.m_121976_((int)Mth.m_14107_((double)(Passerine.this.m_20185_() - 3.0)), (int)Mth.m_14107_((double)(Passerine.this.m_20186_() - 6.0)), (int)Mth.m_14107_((double)(Passerine.this.m_20189_() - 3.0)), (int)Mth.m_14107_((double)(Passerine.this.m_20185_() + 3.0)), (int)Mth.m_14107_((double)(Passerine.this.m_20186_() + 6.0)), (int)Mth.m_14107_((double)(Passerine.this.m_20189_() + 3.0)))) {
                BlockState state;
                boolean flag;
                if (blockpos.equals((Object)blockpos1) || !(flag = (state = Passerine.this.m_9236_().m_8055_((BlockPos)blockpos$mutableblockpos1.m_122159_((Vec3i)blockpos1, Direction.DOWN))).m_204336_(HabitatBlockTags.PASSERINES_PERCHABLE_ON)) || !Passerine.this.m_9236_().m_46859_(blockpos1) || !Passerine.this.m_9236_().m_46859_((BlockPos)blockpos$mutableblockpos.m_122159_((Vec3i)blockpos1, Direction.UP))) continue;
                return Vec3.m_82539_((Vec3i)blockpos1);
            }
            return null;
        }
    }

    class PasserineFollowMobGoal
    extends FollowMobGoal {
        public PasserineFollowMobGoal(double speedModifier, float stopDistance, float areaSize) {
            super((Mob)Passerine.this, speedModifier, stopDistance, areaSize);
        }

        public boolean m_8036_() {
            return Passerine.this.isActive() && super.m_8036_();
        }
    }

    public static class PasserineGroupData
    extends AgeableMob.AgeableMobGroupData {
        public final PasserineVariant variant;

        public PasserineGroupData(PasserineVariant variant) {
            super(false);
            this.variant = variant;
        }
    }

    abstract class IdleGoal
    extends Goal {
        private static final int MINIMUM_WAIT_TIME = IdleGoal.m_186073_((int)1200);
        private int countdown;
        private final Supplier<Integer> getCounter;
        private final Consumer<Integer> setCounter;
        private final Supplier<Boolean> isIdling;

        public IdleGoal(Supplier<Integer> getCounter, Consumer<Integer> setCounter, Supplier<Boolean> isIdling) {
            this.countdown = MINIMUM_WAIT_TIME + Passerine.this.f_19796_.m_188503_(MINIMUM_WAIT_TIME);
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK, Goal.Flag.JUMP));
            this.getCounter = getCounter;
            this.setCounter = setCounter;
            this.isIdling = isIdling;
        }

        public boolean m_8036_() {
            if (this.countdown > 0) {
                --this.countdown;
                return false;
            }
            return Passerine.this.f_20900_ == 0.0f && Passerine.this.f_20901_ == 0.0f && Passerine.this.f_20902_ == 0.0f && this.canIdle();
        }

        public boolean m_8045_() {
            return this.getCounter.get() > 0 && this.canIdle();
        }

        private boolean canIdle() {
            return !Passerine.this.isTurkey() && !Passerine.this.m_29443_() && (Passerine.this.isNotBusy() || this.isIdling.get() != false) && !Passerine.this.f_146808_;
        }

        public void m_8056_() {
            this.setCounter.accept(this.m_183277_(40));
            Passerine.this.m_21573_().m_26573_();
        }

        public void m_8041_() {
            this.setCounter.accept(0);
            this.countdown = MINIMUM_WAIT_TIME + Passerine.this.f_19796_.m_188503_(MINIMUM_WAIT_TIME);
        }

        public void m_8037_() {
            this.setCounter.accept(Math.max(0, this.getCounter.get() - 1));
        }

        public void setCountdown(int countdown) {
            this.countdown = countdown;
        }
    }
}

