/*
 * Decompiled with CFR 0.152.
 */
package mod.schnappdragon.habitat.common.block;

import javax.annotation.Nullable;
import mod.schnappdragon.habitat.common.block.state.properties.HabitatBlockStateProperties;
import mod.schnappdragon.habitat.core.registry.HabitatParticleTypes;
import mod.schnappdragon.habitat.core.registry.HabitatSoundEvents;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.DirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class SlimeFernBlock
extends DirectionalBlock
implements BonemealableBlock {
    private static final VoxelShape UP_SHAPE = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)15.0, (double)16.0);
    private static final VoxelShape DOWN_SHAPE = Block.m_49796_((double)0.0, (double)1.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    private static final VoxelShape NORTH_SHAPE = Block.m_49796_((double)0.0, (double)2.0, (double)1.0, (double)16.0, (double)14.0, (double)16.0);
    private static final VoxelShape SOUTH_SHAPE = Block.m_49796_((double)0.0, (double)2.0, (double)0.0, (double)16.0, (double)14.0, (double)15.0);
    private static final VoxelShape WEST_SHAPE = Block.m_49796_((double)1.0, (double)2.0, (double)0.0, (double)16.0, (double)14.0, (double)16.0);
    private static final VoxelShape EAST_SHAPE = Block.m_49796_((double)0.0, (double)2.0, (double)0.0, (double)15.0, (double)14.0, (double)16.0);
    public static final BooleanProperty SLIMY = HabitatBlockStateProperties.SLIMY;

    public SlimeFernBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)f_52588_, (Comparable)Direction.UP)).m_61124_((Property)SLIMY, (Comparable)Boolean.valueOf(false)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{f_52588_, SLIMY});
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        switch ((Direction)state.m_61143_((Property)f_52588_)) {
            case DOWN: {
                return DOWN_SHAPE;
            }
            case NORTH: {
                return NORTH_SHAPE;
            }
            case SOUTH: {
                return SOUTH_SHAPE;
            }
            case WEST: {
                return WEST_SHAPE;
            }
            case EAST: {
                return EAST_SHAPE;
            }
        }
        return UP_SHAPE;
    }

    public BlockState m_6843_(BlockState state, Rotation rotation) {
        return (BlockState)state.m_61124_((Property)f_52588_, (Comparable)rotation.m_55954_((Direction)state.m_61143_((Property)f_52588_)));
    }

    public BlockState m_6943_(BlockState state, Mirror mirror) {
        return state.m_60717_(mirror.m_54846_((Direction)state.m_61143_((Property)f_52588_)));
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        Direction direction = context.m_43719_();
        Level worldIn = context.m_43725_();
        boolean flag = false;
        if (!worldIn.m_5776_()) {
            BlockPos pos = context.m_8083_();
            ChunkPos chunkPos = new ChunkPos(pos);
            flag = WorldgenRandom.m_224681_((int)chunkPos.f_45578_, (int)chunkPos.f_45579_, (long)((WorldGenLevel)worldIn).m_7328_(), (long)987234911L).m_188503_(10) == 0;
        }
        return (BlockState)((BlockState)this.m_49966_().m_61124_((Property)f_52588_, (Comparable)direction)).m_61124_((Property)SLIMY, (Comparable)Boolean.valueOf(flag));
    }

    public BlockState m_7417_(BlockState stateIn, Direction direction, BlockState directionState, LevelAccessor worldIn, BlockPos currentPos, BlockPos directionPos) {
        return SlimeFernBlock.getBlockConnected(stateIn) == direction && !this.m_7898_(stateIn, (LevelReader)worldIn, currentPos) ? Blocks.f_50016_.m_49966_() : super.m_7417_(stateIn, direction, directionState, worldIn, currentPos, directionPos);
    }

    public boolean m_7898_(BlockState state, LevelReader worldIn, BlockPos pos) {
        Direction dir = SlimeFernBlock.getBlockConnected(state);
        BlockState stateConnected = worldIn.m_8055_(pos.m_121945_(dir));
        return dir == Direction.DOWN && stateConnected.m_60713_(Blocks.f_50093_) || stateConnected.m_60783_((BlockGetter)worldIn, pos.m_121945_(dir), dir.m_122424_());
    }

    protected static Direction getBlockConnected(BlockState state) {
        return ((Direction)state.m_61143_((Property)f_52588_)).m_122424_();
    }

    public void m_214162_(BlockState state, Level worldIn, BlockPos pos, RandomSource rand) {
        if (((Boolean)state.m_61143_((Property)SLIMY)).booleanValue() && rand.m_188503_(10) == 0) {
            VoxelShape voxelshape = this.m_5940_(state, (BlockGetter)worldIn, pos, CollisionContext.m_82749_());
            Vec3 vector3d = voxelshape.m_83215_().m_82399_();
            double X = (double)pos.m_123341_() + vector3d.f_82479_;
            double Y = (double)pos.m_123342_() + vector3d.f_82480_;
            double Z = (double)pos.m_123343_() + vector3d.f_82481_;
            worldIn.m_7106_((ParticleOptions)HabitatParticleTypes.FALLING_SLIME.get(), X + (2.0 * rand.m_188500_() - 1.0) / 2.5, Y - rand.m_188500_() / 5.0, Z + (2.0 * rand.m_188500_() - 1.0) / 2.5, 0.0, 0.0, 0.0);
        }
    }

    public InteractionResult m_6227_(BlockState state, Level worldIn, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        if (player.m_21120_(handIn).m_41720_() == Items.f_42518_ && !((Boolean)state.m_61143_((Property)SLIMY)).booleanValue()) {
            if (!player.m_150110_().f_35937_) {
                player.m_21120_(handIn).m_41774_(1);
            }
            worldIn.m_7731_(pos, (BlockState)state.m_61124_((Property)SLIMY, (Comparable)Boolean.valueOf(true)), 2);
            worldIn.m_7106_((ParticleOptions)ParticleTypes.f_123753_, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, 0.0, 0.0, 0.0);
            worldIn.m_5594_(null, pos, (SoundEvent)HabitatSoundEvents.SLIME_FERN_COAT.get(), SoundSource.BLOCKS, 1.0f, 0.8f + worldIn.f_46441_.m_188501_() * 0.4f);
            worldIn.m_142346_((Entity)player, GameEvent.f_157792_, pos);
            return InteractionResult.m_19078_((boolean)worldIn.f_46443_);
        }
        return super.m_6227_(state, worldIn, pos, player, handIn, hit);
    }

    public void m_7892_(BlockState state, Level worldIn, BlockPos pos, Entity entityIn) {
        double motionY;
        if (entityIn.m_6095_() != EntityType.f_20526_ && (motionY = Math.abs(entityIn.m_20184_().f_82480_)) < 0.1 && !entityIn.m_20161_()) {
            double slowedMotion = 0.4 + motionY * 0.2;
            entityIn.m_20256_(entityIn.m_20184_().m_82542_(slowedMotion, 1.0, slowedMotion));
        }
        super.m_7892_(state, worldIn, pos, entityIn);
    }

    public boolean m_7370_(LevelReader worldIn, BlockPos pos, BlockState state, boolean flag) {
        return true;
    }

    public boolean m_214167_(Level worldIn, RandomSource rand, BlockPos pos, BlockState state) {
        return true;
    }

    public void m_214148_(ServerLevel worldIn, RandomSource rand, BlockPos pos, BlockState state) {
        BlockPos.MutableBlockPos blockpos$mutable = new BlockPos.MutableBlockPos();
        BlockPos.MutableBlockPos blockpos$mutable1 = new BlockPos.MutableBlockPos();
        for (int j = 0; j < 3; ++j) {
            blockpos$mutable.m_122154_((Vec3i)pos, Mth.m_216271_((RandomSource)rand, (int)1, (int)2) - Mth.m_216271_((RandomSource)rand, (int)1, (int)2), Mth.m_216271_((RandomSource)rand, (int)1, (int)2) - Mth.m_216271_((RandomSource)rand, (int)1, (int)2), Mth.m_216271_((RandomSource)rand, (int)1, (int)2) - Mth.m_216271_((RandomSource)rand, (int)1, (int)2));
            if (!worldIn.m_46859_((BlockPos)blockpos$mutable)) continue;
            for (Direction dir : Direction.values()) {
                blockpos$mutable1.m_122159_((Vec3i)blockpos$mutable, dir);
                if (!worldIn.m_8055_((BlockPos)blockpos$mutable1).m_60783_((BlockGetter)worldIn, (BlockPos)blockpos$mutable1, dir.m_122424_())) continue;
                BlockState state1 = (BlockState)this.m_49966_().m_61124_((Property)DirectionalBlock.f_52588_, (Comparable)dir.m_122424_());
                worldIn.m_7731_((BlockPos)blockpos$mutable, state1, 3);
            }
        }
    }

    public PushReaction getPistonPushReaction(BlockState state) {
        return PushReaction.DESTROY;
    }
}

