/*
 * Decompiled with CFR 0.152.
 */
package mod.schnappdragon.habitat.common.block;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import javax.annotation.Nullable;
import mod.schnappdragon.habitat.common.block.entity.RafflesiaBlockEntity;
import mod.schnappdragon.habitat.common.block.state.properties.HabitatBlockStateProperties;
import mod.schnappdragon.habitat.core.registry.HabitatSoundEvents;
import mod.schnappdragon.habitat.core.tags.HabitatBlockTags;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.AreaEffectCloud;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.SuspiciousStewItem;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.extensions.IForgeBlock;

public class RafflesiaBlock
extends BushBlock
implements IForgeBlock,
BonemealableBlock,
EntityBlock {
    protected static final VoxelShape SHAPE = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)5.0, (double)16.0);
    protected static final AABB TOUCH_AABB = new AABB(0.0, 0.0, 0.0, 1.0, 0.3125, 1.0);
    public static final BooleanProperty READY = HabitatBlockStateProperties.READY;
    public static final BooleanProperty HAS_STEW = HabitatBlockStateProperties.HAS_STEW;

    public RafflesiaBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)READY, (Comparable)Boolean.valueOf(false))).m_61124_((Property)HAS_STEW, (Comparable)Boolean.valueOf(false)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{READY, HAS_STEW});
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    public boolean m_7898_(BlockState state, LevelReader worldIn, BlockPos pos) {
        return worldIn.m_8055_(pos.m_7495_()).m_204336_(HabitatBlockTags.RAFFLESIA_PLACEABLE_ON);
    }

    public void m_6807_(BlockState state, Level world, BlockPos pos, BlockState state1, boolean isMoving) {
        if (!state1.m_60713_(state.m_60734_()) && world.m_276867_(pos)) {
            this.cooldownReset(world, pos, state);
        } else {
            world.m_186460_(pos, (Block)this, RafflesiaBlock.getCooldown(world.m_213780_()));
        }
    }

    private static int getCooldown(RandomSource rand) {
        return rand.m_216339_(400, 600);
    }

    public void m_6861_(BlockState state, Level world, BlockPos pos, Block block, BlockPos fromPos, boolean isMoving) {
        if (world.m_276867_(pos)) {
            this.cooldownReset(world, pos, state);
        }
    }

    public void m_213897_(BlockState state, ServerLevel world, BlockPos pos, RandomSource rand) {
        if (!this.m_7898_(state, (LevelReader)world, pos)) {
            world.m_46961_(pos, true);
        } else {
            this.cooldownReset((Level)world, pos, state);
        }
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new RafflesiaBlockEntity(pos, state);
    }

    public void m_214162_(BlockState state, Level worldIn, BlockPos pos, RandomSource rand) {
        BlockEntity tile;
        if (((Boolean)state.m_61143_((Property)READY)).booleanValue() && rand.m_188503_(8) == 0 && (tile = worldIn.m_7702_(pos)) instanceof RafflesiaBlockEntity) {
            RafflesiaBlockEntity rafflesia = (RafflesiaBlockEntity)tile;
            worldIn.m_7106_(RafflesiaBlock.getParticle(rafflesia.Effects), (double)pos.m_123341_() + 0.5 + (2.0 * rand.m_188500_() - 1.0) / 3.0, (double)((float)pos.m_123342_() + 0.25f) + rand.m_188500_() / 2.0, (double)pos.m_123343_() + 0.5 + (2.0 * rand.m_188500_() - 1.0) / 3.0, rand.m_188583_() * 0.01, 0.002, rand.m_188583_() * 0.01);
        }
    }

    private void createCloud(Level worldIn, BlockPos pos, ListTag effects, @Nullable LivingEntity owner) {
        AreaEffectCloud cloud = new AreaEffectCloud(worldIn, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.25, (double)pos.m_123343_() + 0.5);
        cloud.m_19734_(50);
        cloud.m_19712_(1.0f);
        cloud.m_19724_(RafflesiaBlock.getParticle(effects));
        cloud.m_19718_(owner);
        for (int i = 0; i < effects.size(); ++i) {
            MobEffect effect;
            int j = 160;
            CompoundTag tag = effects.m_128728_(i);
            if (tag.m_128425_("EffectDuration", 3)) {
                j = tag.m_128451_("EffectDuration");
            }
            if ((effect = MobEffect.m_19453_((int)tag.m_128445_("EffectId"))) == null) continue;
            cloud.m_19716_(new MobEffectInstance(effect, j));
        }
        worldIn.m_5594_(null, pos, (SoundEvent)HabitatSoundEvents.RAFFLESIA_SPEW.get(), SoundSource.BLOCKS, 1.0f, 0.8f + worldIn.f_46441_.m_188501_() * 0.4f);
        worldIn.m_7967_((Entity)cloud);
    }

    public static ParticleOptions getParticle(ListTag effects) {
        ArrayList effectInstances = Lists.newArrayList();
        for (int i = 0; i < effects.size(); ++i) {
            CompoundTag tag = effects.m_128728_(i);
            MobEffect effect = MobEffect.m_19453_((int)tag.m_128445_("EffectId"));
            if (effect == null) continue;
            effectInstances.add(new MobEffectInstance(effect, 160));
        }
        return new DustParticleOptions(Vec3.m_82501_((int)PotionUtils.m_43564_((Collection)effectInstances)).m_252839_(), 1.0f);
    }

    public void m_7892_(BlockState state, Level worldin, BlockPos pos, Entity entity) {
        BlockEntity tile;
        if (!worldin.f_46443_ && (tile = worldin.m_7702_(pos)) instanceof RafflesiaBlockEntity) {
            RafflesiaBlockEntity rafflesia = (RafflesiaBlockEntity)tile;
            if (((Boolean)state.m_61143_((Property)READY)).booleanValue() && worldin.m_45933_(null, TOUCH_AABB.m_82338_(pos)).contains(entity)) {
                LivingEntity living;
                Entity entity2;
                worldin.m_220407_(GameEvent.f_223702_, pos, GameEvent.Context.m_223722_((BlockState)state));
                if (entity instanceof Projectile) {
                    Projectile projectile = (Projectile)entity;
                    entity2 = projectile.m_19749_();
                } else {
                    entity2 = entity;
                }
                Entity owner = entity2;
                this.createCloud(worldin, pos, rafflesia.Effects, owner instanceof LivingEntity ? (living = (LivingEntity)owner) : null);
                worldin.m_46597_(pos, (BlockState)((BlockState)state.m_61124_((Property)READY, (Comparable)Boolean.valueOf(false))).m_61124_((Property)HAS_STEW, (Comparable)Boolean.valueOf(false)));
                worldin.m_186460_(pos, (Block)this, RafflesiaBlock.getCooldown(worldin.m_213780_()));
                rafflesia.Effects = RafflesiaBlock.getDefault();
                rafflesia.onChange(worldin, worldin.m_8055_(pos));
            }
        }
        super.m_7892_(state, worldin, pos, entity);
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        ItemStack stack = player.m_21120_(hand);
        if (stack.m_41720_() == Items.f_42718_ && !((Boolean)state.m_61143_((Property)HAS_STEW)).booleanValue()) {
            BlockEntity blockEntity;
            if (!world.f_46443_ && (blockEntity = world.m_7702_(pos)) instanceof RafflesiaBlockEntity) {
                RafflesiaBlockEntity rafflesia = (RafflesiaBlockEntity)blockEntity;
                CompoundTag tag2 = stack.m_41783_();
                if (tag2 != null && tag2.m_128425_("Effects", 9)) {
                    rafflesia.Effects = tag2.m_128437_("Effects", 10);
                }
                world.m_46597_(pos, (BlockState)state.m_61124_((Property)HAS_STEW, (Comparable)Boolean.valueOf(true)));
                rafflesia.onChange(world, world.m_8055_(pos));
                player.m_21008_(hand, player.m_150110_().f_35937_ ? stack : new ItemStack((ItemLike)Items.f_42399_));
                world.m_5594_(null, pos, (SoundEvent)HabitatSoundEvents.RAFFLESIA_SLURP.get(), SoundSource.BLOCKS, 1.0f, 0.8f + world.f_46441_.m_188501_() * 0.4f);
                ((ServerLevel)world).m_8767_(RafflesiaBlock.getParticle(rafflesia.Effects), (double)pos.m_123341_() + 0.5 + (2.0 * world.f_46441_.m_188500_() - 1.0) / 3.0, (double)((float)pos.m_123342_() + 0.25f) + world.f_46441_.m_188500_() / 2.0, (double)pos.m_123343_() + 0.5 + (2.0 * world.f_46441_.m_188500_() - 1.0) / 3.0, 0, 0.0, 0.1, 0.0, 1.0);
            }
            world.m_142346_((Entity)player, GameEvent.f_157769_, pos);
            return InteractionResult.m_19078_((boolean)world.f_46443_);
        }
        if (stack.m_41720_() == Items.f_42399_ && ((Boolean)state.m_61143_((Property)HAS_STEW)).booleanValue()) {
            BlockEntity tag2;
            if (!world.f_46443_ && (tag2 = world.m_7702_(pos)) instanceof RafflesiaBlockEntity) {
                RafflesiaBlockEntity rafflesia = (RafflesiaBlockEntity)tag2;
                ItemStack stew = new ItemStack((ItemLike)Items.f_42718_);
                rafflesia.Effects.forEach(tag -> {
                    CompoundTag compound = (CompoundTag)tag;
                    SuspiciousStewItem.m_43258_((ItemStack)stew, (MobEffect)MobEffect.m_19453_((int)compound.m_128445_("EffectId")), (int)compound.m_128451_("EffectDuration"));
                });
                world.m_46597_(pos, (BlockState)state.m_61124_((Property)HAS_STEW, (Comparable)Boolean.valueOf(false)));
                rafflesia.Effects = RafflesiaBlock.getDefault();
                rafflesia.onChange(world, world.m_8055_(pos));
                player.m_21008_(hand, ItemUtils.m_41817_((ItemStack)stack, (Player)player, (ItemStack)stew, (boolean)false));
                world.m_5594_(null, pos, (SoundEvent)HabitatSoundEvents.RAFFLESIA_FILL_BOWL.get(), SoundSource.BLOCKS, 1.0f, 0.8f + world.f_46441_.m_188501_() * 0.4f);
            }
            world.m_142346_((Entity)player, GameEvent.f_157816_, pos);
            return InteractionResult.m_19078_((boolean)world.f_46443_);
        }
        return super.m_6227_(state, world, pos, player, hand, hit);
    }

    public static ListTag getDefault() {
        ListTag Effects = new ListTag();
        CompoundTag tag = new CompoundTag();
        tag.m_128344_("EffectId", (byte)19);
        tag.m_128405_("EffectDuration", 240);
        Effects.add((Object)tag);
        return Effects;
    }

    public boolean m_7370_(LevelReader worldIn, BlockPos pos, BlockState state, boolean isClient) {
        return (Boolean)state.m_61143_((Property)HAS_STEW) == false || (Boolean)state.m_61143_((Property)READY) == false;
    }

    public boolean m_214167_(Level worldIn, RandomSource rand, BlockPos pos, BlockState state) {
        return true;
    }

    public void m_214148_(ServerLevel worldIn, RandomSource rand, BlockPos pos, BlockState state) {
        if (!((Boolean)state.m_61143_((Property)READY)).booleanValue()) {
            this.cooldownReset((Level)worldIn, pos, state);
        } else if (!((Boolean)state.m_61143_((Property)HAS_STEW)).booleanValue()) {
            BlockPos.MutableBlockPos blockpos$mutable = new BlockPos.MutableBlockPos();
            for (int j = 0; j < 8; ++j) {
                blockpos$mutable.m_122154_((Vec3i)pos, Mth.m_216271_((RandomSource)rand, (int)1, (int)2) - Mth.m_216271_((RandomSource)rand, (int)1, (int)2), Mth.m_216271_((RandomSource)rand, (int)1, (int)2) - Mth.m_216271_((RandomSource)rand, (int)1, (int)2), Mth.m_216271_((RandomSource)rand, (int)1, (int)2) - Mth.m_216271_((RandomSource)rand, (int)1, (int)2));
                if (!worldIn.m_46859_((BlockPos)blockpos$mutable) || !worldIn.m_8055_(blockpos$mutable.m_7495_()).m_204336_(HabitatBlockTags.RAFFLESIA_PLACEABLE_ON)) continue;
                worldIn.m_7731_((BlockPos)blockpos$mutable, state, 3);
                break;
            }
        }
    }

    private void cooldownReset(Level worldIn, BlockPos pos, BlockState state) {
        worldIn.m_220407_(GameEvent.f_223703_, pos, GameEvent.Context.m_223722_((BlockState)state));
        worldIn.m_46597_(pos, (BlockState)state.m_61124_((Property)READY, (Comparable)Boolean.valueOf(true)));
        worldIn.m_5594_(null, pos, (SoundEvent)HabitatSoundEvents.RAFFLESIA_POP.get(), SoundSource.BLOCKS, 1.0f, 0.8f + worldIn.f_46441_.m_188501_() * 0.4f);
    }

    public boolean m_7278_(BlockState state) {
        return (Boolean)state.m_61143_((Property)HAS_STEW);
    }

    public int m_6782_(BlockState state, Level worldIn, BlockPos pos) {
        return 1;
    }

    @Nullable
    public BlockPathTypes getBlockPathType(BlockState state, BlockGetter world, BlockPos pos, @Nullable Mob entity) {
        return BlockPathTypes.DANGER_OTHER;
    }
}

