/*
 * Decompiled with CFR 0.152.
 */
package mod.schnappdragon.habitat.common.block;

import javax.annotation.Nullable;
import mod.schnappdragon.habitat.common.block.state.properties.HabitatBlockStateProperties;
import mod.schnappdragon.habitat.core.registry.HabitatParticleTypes;
import mod.schnappdragon.habitat.core.registry.HabitatSoundEvents;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.ToolActions;

public class FairyRingMushroomBlock
extends BushBlock
implements BonemealableBlock {
    protected static final VoxelShape[] SHAPE = new VoxelShape[]{Block.m_49796_((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)13.0, (double)10.0), Block.m_49796_((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)14.0, (double)13.0), Block.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0), Block.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)16.0, (double)15.0)};
    public static final IntegerProperty MUSHROOMS = HabitatBlockStateProperties.MUSHROOMS_1_4;

    public FairyRingMushroomBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)MUSHROOMS, (Comparable)Integer.valueOf(1)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{MUSHROOMS});
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return SHAPE[(Integer)state.m_61143_((Property)MUSHROOMS) - 1];
    }

    public void m_214162_(BlockState state, Level worldIn, BlockPos pos, RandomSource rand) {
        if (rand.m_188503_(9 - (Integer)state.m_61143_((Property)MUSHROOMS)) == 0) {
            worldIn.m_7106_((ParticleOptions)HabitatParticleTypes.FAIRY_RING_SPORE.get(), (double)pos.m_123341_() + rand.m_188500_(), (double)pos.m_123342_() + rand.m_188500_(), (double)pos.m_123343_() + rand.m_188500_(), rand.m_188583_() * 0.01, 0.0, rand.m_188583_() * 0.01);
        }
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        BlockState blockstate = context.m_43725_().m_8055_(context.m_8083_());
        if (blockstate.m_60713_((Block)this)) {
            return (BlockState)blockstate.m_61124_((Property)MUSHROOMS, (Comparable)Integer.valueOf(Math.min(4, (Integer)blockstate.m_61143_((Property)MUSHROOMS) + 1)));
        }
        return super.m_5573_(context);
    }

    public boolean m_6864_(BlockState state, BlockPlaceContext context) {
        return !context.m_7078_() && context.m_43722_().m_150930_(this.m_5456_()) && (Integer)state.m_61143_((Property)MUSHROOMS) < 4 || super.m_6864_(state, context);
    }

    public boolean m_7898_(BlockState state, LevelReader worldIn, BlockPos pos) {
        return worldIn.m_8055_(pos.m_7495_()).m_60804_((BlockGetter)worldIn, pos.m_7495_());
    }

    public InteractionResult m_6227_(BlockState state, Level worldIn, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        if (player.m_21120_(handIn).canPerformAction(ToolActions.SHEARS_HARVEST) && (Integer)state.m_61143_((Property)MUSHROOMS) > 1) {
            FairyRingMushroomBlock.m_49840_((Level)worldIn, (BlockPos)pos, (ItemStack)new ItemStack((ItemLike)this.m_49966_().m_60734_()));
            player.m_21120_(handIn).m_41622_(1, (LivingEntity)player, playerIn -> playerIn.m_21190_(handIn));
            worldIn.m_142346_((Entity)player, GameEvent.f_157781_, pos);
            worldIn.m_7731_(pos, (BlockState)state.m_61124_((Property)MUSHROOMS, (Comparable)Integer.valueOf((Integer)state.m_61143_((Property)MUSHROOMS) - 1)), 2);
            worldIn.m_5594_(null, pos, (SoundEvent)HabitatSoundEvents.FAIRY_RING_MUSHROOM_SHEAR.get(), SoundSource.BLOCKS, 1.0f, 0.8f + worldIn.f_46441_.m_188501_() * 0.4f);
            return InteractionResult.m_19078_((boolean)worldIn.f_46443_);
        }
        return super.m_6227_(state, worldIn, pos, player, handIn, hit);
    }

    public boolean m_6724_(BlockState state) {
        return (Integer)state.m_61143_((Property)MUSHROOMS) < 4;
    }

    public void m_213898_(BlockState state, ServerLevel worldIn, BlockPos pos, RandomSource random) {
        if ((Integer)state.m_61143_((Property)MUSHROOMS) < 4 && ForgeHooks.onCropsGrowPre((Level)worldIn, (BlockPos)pos, (BlockState)state, (random.m_188503_(25) == 0 ? 1 : 0) != 0)) {
            worldIn.m_7731_(pos, (BlockState)state.m_61124_((Property)MUSHROOMS, (Comparable)Integer.valueOf((Integer)state.m_61143_((Property)MUSHROOMS) + 1)), 2);
            ForgeHooks.onCropsGrowPost((Level)worldIn, (BlockPos)pos, (BlockState)state);
        }
    }

    public boolean m_7370_(LevelReader worldIn, BlockPos pos, BlockState state, boolean isClient) {
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean m_214167_(Level worldIn, RandomSource rand, BlockPos pos, BlockState state) {
        if ((Integer)state.m_61143_((Property)MUSHROOMS) != 4) return true;
        float f = rand.m_188501_();
        float f2 = worldIn.m_8055_(pos.m_7495_()).m_204336_(BlockTags.f_13057_) ? 0.8f : 0.4f;
        if (!(f < f2)) return false;
        return true;
    }

    public void m_214148_(ServerLevel worldIn, RandomSource rand, BlockPos pos, BlockState state) {
        if ((Integer)state.m_61143_((Property)MUSHROOMS) < 4) {
            worldIn.m_7731_(pos, (BlockState)state.m_61124_((Property)MUSHROOMS, (Comparable)Integer.valueOf(Math.min(4, (Integer)state.m_61143_((Property)MUSHROOMS) + Mth.m_216271_((RandomSource)rand, (int)1, (int)2)))), 2);
        } else {
            this.growHugeMushroom(worldIn, rand, pos, state);
        }
    }

    private void growHugeMushroom(ServerLevel world, RandomSource rand, BlockPos pos, BlockState state) {
        world.m_7471_(pos, false);
        ConfiguredFeature configuredfeature = (ConfiguredFeature)world.m_9598_().m_175515_(Registries.f_256911_).m_7745_(new ResourceLocation("habitat", "huge_fairy_ring_mushroom"));
        if (!configuredfeature.m_224953_((WorldGenLevel)world, world.m_7726_().m_8481_(), rand, pos)) {
            world.m_7731_(pos, state, 3);
        }
    }
}

