/*
 * Decompiled with CFR 0.152.
 */
package mod.schnappdragon.habitat.client.renderer.entity;

import mod.schnappdragon.habitat.client.model.PasserineModel;
import mod.schnappdragon.habitat.client.renderer.HabitatModelLayers;
import mod.schnappdragon.habitat.client.renderer.entity.layers.PasserineEyesLayer;
import mod.schnappdragon.habitat.common.entity.animal.Passerine;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;

public class PasserineRenderer
extends MobRenderer<Passerine, PasserineModel<Passerine>> {
    public static final ResourceLocation FALLBACK_LOCATION = new ResourceLocation("habitat", "textures/entity/passerine/common_sparrow.png");
    public static final ResourceLocation PASSERINE_BERDLY_LOCATION = new ResourceLocation("habitat", "textures/entity/passerine/berdly.png");
    public static final ResourceLocation PASSERINE_GOLDFISH_LOCATION = new ResourceLocation("habitat", "textures/entity/passerine/goldfish.png");
    public static final ResourceLocation PASSERINE_TURKEY_LOCATION = new ResourceLocation("habitat", "textures/entity/passerine/turkey.png");

    public PasserineRenderer(EntityRendererProvider.Context context) {
        super(context, new PasserineModel(context.m_174023_(HabitatModelLayers.PASSERINE)), 0.25f);
        this.m_115326_(new PasserineEyesLayer(this));
    }

    public ResourceLocation getTextureLocation(Passerine passerine) {
        if (passerine.isBerdly()) {
            return PASSERINE_BERDLY_LOCATION;
        }
        if (passerine.isGoldfish()) {
            return PASSERINE_GOLDFISH_LOCATION;
        }
        if (passerine.isTurkey()) {
            return PASSERINE_TURKEY_LOCATION;
        }
        return passerine.getVariant() == null ? FALLBACK_LOCATION : passerine.getVariant().texture();
    }

    public float getBob(Passerine passerine, float partialTicks) {
        if (passerine.m_29443_()) {
            float f = Mth.m_14179_((float)partialTicks, (float)passerine.initialFlap, (float)passerine.flap);
            float f1 = Mth.m_14179_((float)partialTicks, (float)passerine.initialFlapSpeed, (float)passerine.flapSpeed);
            return (Mth.m_14031_((float)f) + 1.0f) * f1;
        }
        return super.m_6930_((LivingEntity)passerine, partialTicks);
    }
}

