/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.ftbbackups.repack.net.covers1624.quack.collection.redblack;

import net.creeperhost.ftbbackups.repack.net.covers1624.quack.collection.Object2IntPair;
import net.creeperhost.ftbbackups.repack.net.covers1624.quack.collection.redblack.BaseRedBlackTree;
import net.creeperhost.ftbbackups.repack.net.covers1624.quack.collection.redblack.CollectionRedBlackTree;
import net.creeperhost.ftbbackups.repack.net.covers1624.quack.collection.redblack.RedBlackNode;
import net.creeperhost.ftbbackups.repack.net.covers1624.quack.util.Object2IntFunction;
import net.creeperhost.ftbbackups.repack.net.covers1624.quack.util.SneakyUtils;
import org.jetbrains.annotations.Nullable;

public abstract class ComparableRedBlackTree<T, N extends RedBlackNode<N>>
extends CollectionRedBlackTree<T, N> {
    @Override
    protected BaseRedBlackTree.Entries makeEntriesCollection() {
        return new ComparableEntries();
    }

    public Object2IntPair<N> closest(N node) {
        return this.closest((N)((Object2IntFunction<RedBlackNode>)x$0 -> ((Comparable)((Object)node)).compareTo(x$0)));
    }

    @Override
    protected void orderConsistencyCheck(@Nullable N left, @Nullable N right) {
        if (left != null && right != null && ((Comparable)left).compareTo(right) >= 0) {
            throw new IllegalArgumentException("Comparison contract violated by supplied arguments '" + left + "' < '" + right + "'");
        }
    }

    public void insertRange(Iterable<N> nodes) {
        this.insertRangeAt(null, nodes);
    }

    public void insertRangeAt(@Nullable N loc, Iterable<N> nodes) {
        for (RedBlackNode node : nodes) {
            if (loc == null) {
                Object2IntPair<RedBlackNode> c = this.closest(node);
                loc = c.getKey();
                if (c.getValue() < 0 && loc != null) {
                    loc = ((RedBlackNode)loc).getPrev();
                }
            }
            this.orderConsistencyCheck(loc, node);
            this.insertAt(loc, true, node);
            loc = node;
        }
        assert (loc != null);
        this.orderConsistencyCheck(loc, ((RedBlackNode)loc).getNext());
    }

    protected class ComparableEntries
    extends BaseRedBlackTree.Entries {
        protected ComparableEntries() {
        }

        @Override
        public boolean add(N t) {
            if (ComparableRedBlackTree.this.getRoot() == null) {
                ComparableRedBlackTree.this.insertAt(null, false, t);
                return true;
            }
            Object2IntPair locPair = ComparableRedBlackTree.this.closest(t);
            if (locPair.getValue() == 0) {
                return false;
            }
            ComparableRedBlackTree.this.insertAt((RedBlackNode)locPair.getKey(), locPair.getValue() > 0, t);
            return true;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean contains(Object o) {
            if (!(o instanceof RedBlackNode)) return false;
            if (!(o instanceof Comparable)) return false;
            if (ComparableRedBlackTree.this.find(arg_0 -> ComparableEntries.lambda$contains$0((Comparable)SneakyUtils.unsafeCast(o), arg_0)) == null) return false;
            return true;
        }

        private static /* synthetic */ int lambda$contains$0(Comparable rec$, Object x$0) {
            return rec$.compareTo(x$0);
        }
    }
}

