/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbultimine.utils;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public final class ShapeMerger {
    private static final Long2ObjectMap<Direction> BY_NORMAL = (Long2ObjectMap)Arrays.stream(Direction.values()).collect(Collectors.toMap(dir -> new BlockPos(dir.m_122436_()).m_121878_(), dir -> dir, (dir, dir2) -> {
        throw new IllegalArgumentException("Duplicate keys");
    }, Long2ObjectOpenHashMap::new));
    private double regionBuildingAxis = Double.NEGATIVE_INFINITY;
    private double faceBuildingAxis = Double.NEGATIVE_INFINITY;
    private Vec3 lastCenterPoint = null;
    private AABB currentBox;
    private final Map<Vec3, AABB> boxAssignments = Maps.newHashMap();
    private final Multimap<AABB, Vec3> mergerAssignments = HashMultimap.create();

    public double getRegionBuildingAxisValue() {
        return this.regionBuildingAxis;
    }

    public void setRegionBuildingAxisValue(double regionBuildingAxis) {
        this.regionBuildingAxis = regionBuildingAxis;
    }

    public double getFaceBuildingAxisValue() {
        return this.faceBuildingAxis;
    }

    public void setFaceBuildingAxisValue(double faceBuildingAxis) {
        this.faceBuildingAxis = faceBuildingAxis;
    }

    public AABB getCurrentBox() {
        return this.currentBox;
    }

    public void setCurrentBox(AABB currentBox, Vec3 centerPoint) {
        this.currentBox = currentBox;
        if (currentBox != null) {
            this.boxAssignments.put(centerPoint, currentBox);
            this.mergerAssignments.put((Object)currentBox, (Object)centerPoint);
        }
    }

    public Optional<AABB> getBoxFor(Vec3 target) {
        return Optional.ofNullable(this.boxAssignments.get(target));
    }

    public Optional<Vec3> getLastCenter() {
        return Optional.ofNullable(this.lastCenterPoint);
    }

    public void onNextEntry(Vec3 lastCenterPoint) {
        this.lastCenterPoint = lastCenterPoint;
    }

    public void expandCurrentBoxTowards(AABB target, Vec3 center) {
        AABB current = this.getCurrentBox();
        if (current == null) {
            throw new IllegalStateException("Can not expand current box, if current is not set.");
        }
        AABB expanded = current.m_82367_(target);
        Collection currentlyAssignedToCurrent = this.mergerAssignments.removeAll((Object)current);
        currentlyAssignedToCurrent.forEach(v -> this.boxAssignments.put((Vec3)v, expanded));
        this.mergerAssignments.putAll((Object)expanded, (Iterable)currentlyAssignedToCurrent);
        this.boxAssignments.put(center, expanded);
        this.mergerAssignments.put((Object)expanded, (Object)center);
        this.currentBox = expanded;
    }

    public Collection<AABB> getBoxes() {
        return this.mergerAssignments.keySet();
    }

    public void expandBoxAt(Vec3 neighborCenter, AABB entryData, Vec3 centerPoint) {
        AABB current = this.boxAssignments.get(neighborCenter);
        if (current == null) {
            throw new IllegalStateException(String.format("Can not expand box at: %s, if current is not set.", neighborCenter));
        }
        AABB expanded = current.m_82367_(entryData);
        Collection currentlyAssignedToCurrent = this.mergerAssignments.removeAll((Object)current);
        currentlyAssignedToCurrent.forEach(v -> this.boxAssignments.put((Vec3)v, expanded));
        this.mergerAssignments.putAll((Object)expanded, (Iterable)currentlyAssignedToCurrent);
        this.boxAssignments.put(centerPoint, expanded);
        this.mergerAssignments.put((Object)expanded, (Object)centerPoint);
    }

    public boolean mergeNeighbors(Vec3 centerPoint, AABB aabb) {
        for (Direction offsetDirection : Direction.values()) {
            AABB neighborBox;
            Vec3 neighborCenter = centerPoint.m_82549_(Vec3.m_82528_((Vec3i)offsetDirection.m_122436_()));
            Optional<AABB> potentialNeighborBox = this.getBoxFor(neighborCenter);
            if (!potentialNeighborBox.isPresent() || !ShapeMerger.areBoxesNeighbors(aabb, neighborBox = potentialNeighborBox.get(), offsetDirection)) continue;
            this.expandBoxAt(neighborCenter, aabb, centerPoint);
            return true;
        }
        return false;
    }

    public static boolean areBoxesNeighbors(AABB l, AABB r, Direction direction) {
        double startOfR;
        double endOfL = ShapeMerger.getDirectionalValue(l, direction);
        if (endOfL != (startOfR = ShapeMerger.getDirectionalValue(r, direction.m_122424_()))) {
            return false;
        }
        for (Direction d : Direction.values()) {
            if (d.m_122434_() == direction.m_122434_() || ShapeMerger.getDirectionalValue(l, d) == ShapeMerger.getDirectionalValue(r, d)) continue;
            return false;
        }
        return true;
    }

    public static double getDirectionalValue(AABB bb, Direction direction) {
        return direction.m_122421_() == Direction.AxisDirection.POSITIVE ? bb.m_82374_(direction.m_122434_()) : bb.m_82340_(direction.m_122434_());
    }

    public static Collection<AABB> merge(Collection<BlockPos> positions, BlockPos origin) {
        ShapeMerger merger = new ShapeMerger();
        positions.stream().map(pos -> pos.m_121996_((Vec3i)origin)).sorted().map(AABB::new).forEachOrdered(aabb -> {
            if (merger.getRegionBuildingAxisValue() != aabb.f_82288_) {
                merger.setCurrentBox(null, null);
            }
            merger.setRegionBuildingAxisValue(aabb.f_82288_);
            if (merger.getFaceBuildingAxisValue() != aabb.f_82289_) {
                merger.setCurrentBox(null, null);
            }
            merger.setFaceBuildingAxisValue(aabb.f_82289_);
            Optional<Vec3> previousCenterPoint = merger.getLastCenter();
            Vec3 centerPoint = aabb.m_82399_();
            merger.onNextEntry(centerPoint);
            Optional<Direction> moveNext = previousCenterPoint.map(v -> {
                Vec3 w = centerPoint.m_82546_(v);
                BlockPos onPos = BlockPos.m_274446_((Position)w);
                return ShapeMerger.dirFromNormal(onPos.m_123341_(), onPos.m_123342_(), onPos.m_123343_());
            });
            if (merger.getCurrentBox() != null && moveNext.map(dir -> ShapeMerger.areBoxesNeighbors(merger.getCurrentBox(), aabb, dir)).orElse(false).booleanValue()) {
                merger.expandCurrentBoxTowards((AABB)aabb, centerPoint);
                if (merger.mergeNeighbors(centerPoint, merger.getCurrentBox())) {
                    return;
                }
                return;
            }
            if (merger.mergeNeighbors(centerPoint, (AABB)aabb)) {
                return;
            }
            merger.setCurrentBox((AABB)aabb, centerPoint);
        });
        return merger.getBoxes();
    }

    private static Direction dirFromNormal(int pX, int pY, int pZ) {
        return (Direction)BY_NORMAL.get(BlockPos.m_121882_((int)pX, (int)pY, (int)pZ));
    }
}

