/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbchunks.net;

import dev.architectury.networking.NetworkManager;
import dev.architectury.networking.simple.BaseC2SMessage;
import dev.architectury.networking.simple.MessageType;
import dev.ftb.mods.ftbchunks.net.FTBChunksNet;
import dev.ftb.mods.ftbteams.api.FTBTeamsAPI;
import dev.ftb.mods.ftbteams.api.Team;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.core.GlobalPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.ChatType;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.OutgoingChatMessage;
import net.minecraft.network.chat.PlayerChatMessage;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.players.PlayerList;
import net.minecraft.world.entity.Entity;

public class ShareWaypointPacket
extends BaseC2SMessage {
    private final String name;
    private final GlobalPos globalPos;
    private final ShareType shareType;
    private final List<UUID> targets;

    public ShareWaypointPacket(String name, GlobalPos globalPos, ShareType shareType, List<UUID> targets) {
        this.name = name;
        this.globalPos = globalPos;
        this.shareType = shareType;
        this.targets = targets;
    }

    public ShareWaypointPacket(FriendlyByteBuf buf) {
        this.name = buf.m_130277_();
        this.globalPos = buf.m_236872_();
        this.shareType = (ShareType)buf.m_130066_(ShareType.class);
        int size = buf.readInt();
        ArrayList<UUID> targets = new ArrayList<UUID>();
        for (int i = 0; i < size; ++i) {
            targets.add(buf.m_130259_());
        }
        this.targets = targets;
    }

    public MessageType getType() {
        return FTBChunksNet.SHARE_WAYPOINT;
    }

    public void write(FriendlyByteBuf buf) {
        buf.m_130070_(this.name);
        buf.m_236814_(this.globalPos);
        buf.m_130068_((Enum)this.shareType);
        buf.writeInt(this.targets.size());
        for (UUID target : this.targets) {
            buf.m_130077_(target);
        }
    }

    public void handle(NetworkManager.PacketContext context) {
        context.queue(() -> {
            ServerPlayer serverPlayer = (ServerPlayer)context.getPlayer();
            PlayerList playerList = serverPlayer.m_20194_().m_6846_();
            ChatType.Bound bound2 = ChatType.m_240980_((ResourceKey)ChatType.f_130598_, (Entity)serverPlayer).m_241018_(serverPlayer.m_5446_());
            List<ServerPlayer> playersToSend = switch (this.shareType) {
                default -> throw new IncompatibleClassChangeError();
                case ShareType.SERVER -> playerList.m_11314_();
                case ShareType.PARTY -> {
                    Optional teamForPlayer = FTBTeamsAPI.api().getManager().getTeamForPlayer(serverPlayer);
                    if (teamForPlayer.isPresent()) {
                        Team team = (Team)teamForPlayer.get();
                        yield team.getMembers().stream().map(arg_0 -> ((PlayerList)playerList).m_11259_(arg_0)).filter(Objects::nonNull).toList();
                    }
                    yield List.of(serverPlayer);
                }
                case ShareType.PLAYER -> this.targets.stream().map(arg_0 -> ((PlayerList)playerList).m_11259_(arg_0)).filter(Objects::nonNull).toList();
            };
            for (ServerPlayer playerListPlayer : playersToSend) {
                String cords = this.globalPos.m_122646_().m_123341_() + " " + this.globalPos.m_122646_().m_123342_() + " " + this.globalPos.m_122646_().m_123343_();
                String dim = this.globalPos.m_122640_().m_135782_().toString();
                MutableComponent waypointText = Component.m_237113_((String)this.name).m_130938_(style -> style.m_131140_(ChatFormatting.AQUA).m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)Component.m_237113_((String)(dim + " " + cords)))));
                playerListPlayer.m_245069_(OutgoingChatMessage.m_247282_((PlayerChatMessage)PlayerChatMessage.m_247306_((String)"").m_241956_((Component)Component.m_237110_((String)"ftbchunks.waypoint.shared", (Object[])new Object[]{waypointText}).m_130938_(style -> style.m_131142_(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/ftbchunks waypoint add-dim " + this.name + " " + cords + " " + dim + " white true"))))), false, bound2);
            }
        });
    }

    public static enum ShareType {
        SERVER,
        PARTY,
        PLAYER;

    }
}

