/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.flavorimmerseddaily.network;

import java.util.HashMap;
import java.util.function.Supplier;
import net.mcreator.flavorimmerseddaily.FlavorImmersedDailyMod;
import net.mcreator.flavorimmerseddaily.procedures.Bookguito2Procedure;
import net.mcreator.flavorimmerseddaily.procedures.Bookguito3Procedure;
import net.mcreator.flavorimmerseddaily.procedures.Bookguito4Procedure;
import net.mcreator.flavorimmerseddaily.procedures.Bookguito5Procedure;
import net.mcreator.flavorimmerseddaily.procedures.Bookguito6Procedure;
import net.mcreator.flavorimmerseddaily.world.inventory.BookGui01Menu;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.network.NetworkEvent;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class BookGui01ButtonMessage {
    private final int buttonID;
    private final int x;
    private final int y;
    private final int z;

    public BookGui01ButtonMessage(FriendlyByteBuf buffer) {
        this.buttonID = buffer.readInt();
        this.x = buffer.readInt();
        this.y = buffer.readInt();
        this.z = buffer.readInt();
    }

    public BookGui01ButtonMessage(int buttonID, int x, int y, int z) {
        this.buttonID = buttonID;
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public static void buffer(BookGui01ButtonMessage message, FriendlyByteBuf buffer) {
        buffer.writeInt(message.buttonID);
        buffer.writeInt(message.x);
        buffer.writeInt(message.y);
        buffer.writeInt(message.z);
    }

    public static void handler(BookGui01ButtonMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            ServerPlayer entity = context.getSender();
            int buttonID = message.buttonID;
            int x = message.x;
            int y = message.y;
            int z = message.z;
            BookGui01ButtonMessage.handleButtonAction((Player)entity, buttonID, x, y, z);
        });
        context.setPacketHandled(true);
    }

    public static void handleButtonAction(Player entity, int buttonID, int x, int y, int z) {
        Level world = entity.m_9236_();
        HashMap<String, Object> guistate = BookGui01Menu.guistate;
        if (!world.m_46805_(new BlockPos(x, y, z))) {
            return;
        }
        if (buttonID == 0) {
            Bookguito2Procedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 1) {
            Bookguito5Procedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 2) {
            Bookguito3Procedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 3) {
            Bookguito4Procedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 4) {
            Bookguito6Procedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
    }

    @SubscribeEvent
    public static void registerMessage(FMLCommonSetupEvent event) {
        FlavorImmersedDailyMod.addNetworkMessage(BookGui01ButtonMessage.class, BookGui01ButtonMessage::buffer, BookGui01ButtonMessage::new, BookGui01ButtonMessage::handler);
    }
}

