/*
 * Decompiled with CFR 0.152.
 */
package teamdraco.finsandstails.common.items;

import java.util.List;
import java.util.function.Supplier;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.LiquidBlockContainer;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.event.ForgeEventFactory;
import org.jetbrains.annotations.Nullable;
import teamdraco.finsandstails.common.entities.WherbleEntity;
import teamdraco.finsandstails.common.items.FinsPotItem;
import teamdraco.finsandstails.registry.FTEntities;

public class WherblingPotItem
extends FinsPotItem {
    private final Supplier<? extends EntityType<?>> entityTypeSupplier;
    private final Supplier<? extends Fluid> fluid;

    public WherblingPotItem(Supplier<? extends EntityType<?>> entityType, Supplier<? extends Fluid> fluid, Item.Properties builder) {
        super(entityType, fluid, builder);
        this.entityTypeSupplier = entityType;
        this.fluid = fluid;
    }

    @Override
    public InteractionResultHolder<ItemStack> m_7203_(Level worldIn, Player playerIn, InteractionHand handIn) {
        BlockHitResult result;
        ItemStack itemstack = playerIn.m_21120_(handIn);
        InteractionResultHolder ret = ForgeEventFactory.onBucketUse((Player)playerIn, (Level)worldIn, (ItemStack)itemstack, (HitResult)(result = WherblingPotItem.m_41435_((Level)worldIn, (Player)playerIn, (ClipContext.Fluid)ClipContext.Fluid.NONE)));
        if (ret != null) {
            return ret;
        }
        if (result.m_6662_() == HitResult.Type.MISS) {
            return InteractionResultHolder.m_19098_((Object)itemstack);
        }
        if (result.m_6662_() != HitResult.Type.BLOCK) {
            return InteractionResultHolder.m_19098_((Object)itemstack);
        }
        BlockPos blockpos = result.m_82425_();
        Direction direction = result.m_82434_();
        BlockPos blockpos1 = blockpos.m_121945_(direction);
        if (worldIn.m_7966_(playerIn, blockpos) && playerIn.m_36204_(blockpos1, direction, itemstack)) {
            BlockState blockstate = worldIn.m_8055_(blockpos);
            BlockPos blockpos2 = blockstate.m_60734_() instanceof LiquidBlockContainer && ((LiquidBlockContainer)blockstate.m_60734_()).m_6044_((BlockGetter)worldIn, blockpos, blockstate, this.fluid.get()) ? blockpos : blockpos1;
            this.m_142073_(playerIn, worldIn, blockpos2, result);
            if (worldIn instanceof ServerLevel) {
                this.placeEntity((ServerLevel)worldIn, itemstack, blockpos2);
            }
            if (playerIn instanceof ServerPlayer) {
                CriteriaTriggers.f_10591_.m_285767_((ServerPlayer)playerIn, blockpos2, itemstack);
            }
            playerIn.m_36246_(Stats.f_12982_.m_12902_((Object)this));
            return InteractionResultHolder.m_19092_((Object)this.getEmptyItem(itemstack, playerIn), (boolean)worldIn.m_5776_());
        }
        return InteractionResultHolder.m_19100_((Object)itemstack);
    }

    @Override
    public void m_7373_(ItemStack stack, @Nullable Level world, List<Component> tooltip, TooltipFlag flag) {
    }

    private void placeEntity(ServerLevel worldIn, ItemStack stack, BlockPos pos) {
        Entity entity = this.entityTypeSupplier.get().m_20592_(worldIn, stack, null, pos, MobSpawnType.BUCKET, true, false);
        if (entity != null && entity instanceof WherbleEntity) {
            if (!stack.m_41782_()) {
                ((WherbleEntity)entity).m_146762_(-24000);
                ((WherbleEntity)entity).setVariant(worldIn.f_46441_.m_188503_(4));
            } else {
                ((WherbleEntity)entity).m_146762_(stack.m_41783_().m_128451_("Age"));
                ((WherbleEntity)entity).setVariant(stack.m_41783_().m_128451_("Variant"));
            }
        }
    }

    private ItemStack getEmptyItem(ItemStack stack, Player player) {
        if (this.entityTypeSupplier == FTEntities.WHERBLE) {
            return !player.m_7500_() ? new ItemStack((ItemLike)Items.f_42618_) : stack;
        }
        return !player.m_7500_() ? new ItemStack((ItemLike)Items.f_42446_) : stack;
    }
}

