/*
 * Decompiled with CFR 0.152.
 */
package teamdraco.finsandstails.common.entities;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.stats.Stats;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.LookAtTradingPlayerGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.TradeWithPlayerGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.trading.Merchant;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.item.trading.MerchantOffers;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.HitResult;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;
import teamdraco.finsandstails.registry.FTItems;
import teamdraco.finsandstails.registry.FTSounds;

public class WanderingSailorEntity
extends AbstractVillager
implements Merchant,
GeoEntity {
    public static final Int2ObjectMap<VillagerTrades.ItemListing[]> TRADES = WanderingSailorEntity.toIntMap((ImmutableMap<Integer, VillagerTrades.ItemListing[]>)ImmutableMap.of((Object)1, (Object)new VillagerTrades.ItemListing[]{new ItemsForItemsTrade(new ItemStack((ItemLike)FTItems.SPINDLY_EMERALD.get()), new ItemStack((ItemLike)FTItems.BANDED_REDBACK_SHRIMP_BUCKET.get()), 3, 3, 30.0f), new ItemsForItemsTrade(new ItemStack((ItemLike)FTItems.SPINDLY_RUBY.get(), 4), new ItemStack((ItemLike)FTItems.GOPJET_JET.get()), 3, 3, 30.0f), new ItemsForItemsTrade(new ItemStack((ItemLike)FTItems.SPINDLY_AMBER.get(), 4), new ItemStack((ItemLike)FTItems.FWIN.get(), 1), 3, 3, 30.0f), new ItemsForItemsTrade(new ItemStack((ItemLike)FTItems.SPINDLY_EMERALD.get(), 2), new ItemStack((ItemLike)FTItems.WHITE_BULL_CRAB_CLAW.get(), 2), 3, 3, 30.0f)}, (Object)2, (Object)new VillagerTrades.ItemListing[]{new ItemsForItemsTrade(new ItemStack((ItemLike)FTItems.SPINDLY_SAPPHIRE.get()), new ItemStack((ItemLike)FTItems.NIGHT_LIGHT_SQUID_TENTACLE.get(), 5), 3, 3, 30.0f), new ItemsForItemsTrade(new ItemStack((ItemLike)FTItems.SPINDLY_PEARL.get()), new ItemStack((ItemLike)FTItems.PAPA_WEE_BUCKET.get()), 3, 3, 30.0f)}));
    private final AnimatableInstanceCache factory = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);

    public WanderingSailorEntity(EntityType<? extends AbstractVillager> type, Level worldIn) {
        super(type, worldIn);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new PanicGoal((PathfinderMob)this, 1.75));
        this.f_21345_.m_25352_(2, (Goal)new TradeWithPlayerGoal((AbstractVillager)this));
        this.f_21345_.m_25352_(2, (Goal)new LookAtTradingPlayerGoal((AbstractVillager)this));
        this.f_21345_.m_25352_(3, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(4, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 3.0f, 1.0f));
        this.f_21345_.m_25352_(5, (Goal)new LookAtPlayerGoal((Mob)this, Mob.class, 8.0f));
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 20.0).m_22268_(Attributes.f_22279_, (double)0.2f);
    }

    public int m_8100_() {
        return 480;
    }

    public boolean m_6040_() {
        return true;
    }

    public MobType m_6336_() {
        return MobType.f_21644_;
    }

    protected float m_6431_(Pose poseIn, EntityDimensions sizeIn) {
        return 1.2f;
    }

    public InteractionResult m_6071_(Player p_230254_1_, InteractionHand p_230254_2_) {
        ItemStack itemstack = p_230254_1_.m_21120_(p_230254_2_);
        if (this.m_6084_() && !this.m_35306_() && !this.m_6162_()) {
            if (p_230254_2_ == InteractionHand.MAIN_HAND) {
                p_230254_1_.m_36220_(Stats.f_12940_);
            }
            if (this.m_6616_().isEmpty()) {
                return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
            }
            if (!this.m_9236_().f_46443_) {
                this.m_7189_(p_230254_1_);
                this.m_45301_(p_230254_1_, this.m_5446_(), 0);
            }
            return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
        }
        return super.m_6071_(p_230254_1_, p_230254_2_);
    }

    public ItemStack getPickedResult(HitResult target) {
        return null;
    }

    protected void m_7604_() {
        VillagerTrades.ItemListing[] trade1 = (VillagerTrades.ItemListing[])TRADES.get(1);
        VillagerTrades.ItemListing[] trade2 = (VillagerTrades.ItemListing[])TRADES.get(2);
        if (trade1 != null && trade2 != null) {
            MerchantOffers offers = this.m_6616_();
            this.m_35277_(offers, trade1, 2);
            int i = this.f_19796_.m_188503_(trade2.length);
            VillagerTrades.ItemListing villagertrades$itrade = trade2[i];
            MerchantOffer merchantoffer = villagertrades$itrade.m_213663_((Entity)this, this.f_19796_);
            if (merchantoffer != null) {
                offers.add((Object)merchantoffer);
            }
        }
    }

    protected void m_8058_(MerchantOffer offer) {
        if (offer.m_45383_()) {
            int i = 3 + this.f_19796_.m_188503_(4);
            this.m_9236_().m_7967_((Entity)new ExperienceOrb(this.m_9236_(), this.m_20185_(), this.m_20186_() + 0.5, this.m_20189_(), i));
        }
    }

    protected SoundEvent m_7515_() {
        return this.m_35306_() ? (SoundEvent)FTSounds.WANDERING_SAILOR_TRADE.get() : (SoundEvent)FTSounds.WANDERING_SAILOR_AMBIENT.get();
    }

    protected SoundEvent m_7975_(DamageSource damageSourceIn) {
        return (SoundEvent)FTSounds.WANDERING_SAILOR_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)FTSounds.WANDERING_SAILOR_DEATH.get();
    }

    protected SoundEvent m_6068_(boolean p_213721_1_) {
        return p_213721_1_ ? (SoundEvent)FTSounds.WANDERING_SAILOR_YES.get() : (SoundEvent)FTSounds.WANDERING_SAILOR_NO.get();
    }

    public SoundEvent m_7596_() {
        return (SoundEvent)FTSounds.WANDERING_SAILOR_YES.get();
    }

    @Nullable
    public AgeableMob m_142606_(ServerLevel p_241840_1_, AgeableMob p_241840_2_) {
        return null;
    }

    private static Int2ObjectMap<VillagerTrades.ItemListing[]> toIntMap(ImmutableMap<Integer, VillagerTrades.ItemListing[]> p_221238_0_) {
        return new Int2ObjectOpenHashMap(p_221238_0_);
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        controllerRegistrar.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 5, this::predicate)});
    }

    private <E extends GeoEntity> PlayState predicate(AnimationState<E> event) {
        if (event.isMoving()) {
            event.getController().setAnimation(RawAnimation.begin().thenLoop("animation.wandering_sailor.walk"));
        } else {
            event.getController().setAnimation(RawAnimation.begin().thenLoop("animation.wandering_sailor.idle"));
        }
        return PlayState.CONTINUE;
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.factory;
    }

    private static class ItemsForItemsTrade
    implements VillagerTrades.ItemListing {
        private final ItemStack buying1;
        private final ItemStack buying2;
        private final ItemStack selling;
        private final int maxUses;
        private final int xp;
        private final float priceMultiplier;
        public static final Map<Integer, ItemStack> GEMS = (Map)Util.m_137469_((Object)Maps.newHashMap(), hashMap -> {
            hashMap.put(0, new ItemStack((ItemLike)FTItems.SPINDLY_EMERALD.get()));
            hashMap.put(1, new ItemStack((ItemLike)FTItems.SPINDLY_AMBER.get()));
            hashMap.put(2, new ItemStack((ItemLike)FTItems.SPINDLY_PEARL.get()));
            hashMap.put(3, new ItemStack((ItemLike)FTItems.SPINDLY_RUBY.get()));
            hashMap.put(4, new ItemStack((ItemLike)FTItems.SPINDLY_SAPPHIRE.get()));
        });

        public ItemsForItemsTrade(ItemStack buying1, ItemStack buying2, ItemStack selling, int maxUses, int xp, float priceMultiplier) {
            this.buying1 = buying1;
            this.buying2 = buying2;
            this.selling = selling;
            this.maxUses = maxUses;
            this.xp = xp;
            this.priceMultiplier = priceMultiplier;
        }

        public ItemsForItemsTrade(ItemStack buying1, ItemStack selling, int maxUses, int xp, float priceMultiplier) {
            this(buying1, ItemStack.f_41583_, selling, maxUses, xp, priceMultiplier);
        }

        @Nullable
        public MerchantOffer m_213663_(Entity trader, RandomSource rand) {
            ItemStack stack = GEMS.get(rand.m_188503_(GEMS.size()));
            return new MerchantOffer(this.buying1, this.buying2, this.selling, this.maxUses, this.xp, this.priceMultiplier);
        }
    }
}

