/*
 * Decompiled with CFR 0.152.
 */
package teamdraco.finsandstails.common.entities;

import java.util.function.Predicate;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.SmoothSwimmingLookControl;
import net.minecraft.world.entity.ai.control.SmoothSwimmingMoveControl;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.RandomSwimmingGoal;
import net.minecraft.world.entity.ai.goal.TryFindWaterGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.Squid;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;
import teamdraco.finsandstails.common.entities.BandedRedbackShrimpEntity;
import teamdraco.finsandstails.common.entities.OrnateBugfishEntity;
import teamdraco.finsandstails.common.entities.RedBullCrabEntity;
import teamdraco.finsandstails.common.entities.SpindlyGemCrabEntity;
import teamdraco.finsandstails.common.entities.WhiteBullCrabEntity;
import teamdraco.finsandstails.common.entities.ai.control.GroundAndSwimmerNavigator;
import teamdraco.finsandstails.common.entities.ai.goals.WaterJumpGoal;
import teamdraco.finsandstails.registry.FTEntities;
import teamdraco.finsandstails.registry.FTItems;
import teamdraco.finsandstails.registry.FTSounds;
import teamdraco.finsandstails.registry.FTTags;

public class RubberBellyGliderEntity
extends Animal
implements GeoEntity {
    private static final EntityDataAccessor<Boolean> PUFFED = SynchedEntityData.m_135353_(RubberBellyGliderEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDimensions PUFFED_SIZE = EntityDimensions.m_20395_((float)0.7f, (float)0.5f);
    private final AnimatableInstanceCache factory = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private int puffTimer;
    private static final Predicate<Entity> ENEMY_MATCHER = entity -> {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            return !player.m_7500_() && !player.m_5833_();
        }
        return entity instanceof OrnateBugfishEntity;
    };

    public RubberBellyGliderEntity(EntityType<? extends RubberBellyGliderEntity> type, Level world) {
        super(type, world);
        this.f_21342_ = new SmoothSwimmingMoveControl((Mob)this, 85, 10, 0.02f, 1.0f, true){

            public void m_8126_() {
                super.m_8126_();
                if (this.f_24974_.m_20069_()) {
                    this.f_24974_.m_20256_(this.f_24974_.m_20184_().m_82520_(0.0, -0.0025, 0.0));
                }
            }
        };
        this.f_21365_ = new SmoothSwimmingLookControl((Mob)this, 30);
        this.m_21441_(BlockPathTypes.WATER, 0.0f);
    }

    public float m_274421_() {
        return 1.0f;
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new PuffGoal(this));
        this.f_21345_.m_25352_(0, (Goal)new TryFindWaterGoal((PathfinderMob)this));
        this.f_21345_.m_25352_(0, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, true));
        this.f_21345_.m_25352_(1, (Goal)new AvoidEntityGoal((PathfinderMob)this, OrnateBugfishEntity.class, 8.0f, 1.6, 1.4, EntitySelector.f_20408_::test));
        this.f_21345_.m_25352_(1, (Goal)new AvoidEntityGoal((PathfinderMob)this, Player.class, 8.0f, 1.6, 1.4, EntitySelector.f_20408_::test));
        this.f_21345_.m_25352_(1, (Goal)new BreedGoal((Animal)this, 2.0));
        this.f_21345_.m_25352_(2, (Goal)new PanicGoal((PathfinderMob)this, 2.0));
        this.f_21345_.m_25352_(2, (Goal)new RandomSwimmingGoal((PathfinderMob)this, 1.0, 1){

            public boolean m_8036_() {
                return super.m_8036_() && RubberBellyGliderEntity.this.m_20069_();
            }
        });
        this.f_21345_.m_25352_(2, (Goal)new RandomStrollGoal((PathfinderMob)this, 1.0, 15){

            public boolean m_8036_() {
                return !this.f_25725_.m_20069_() && super.m_8036_();
            }
        });
        this.f_21345_.m_25352_(3, (Goal)new WaterJumpGoal((PathfinderMob)this, 10));
        this.f_21345_.m_25352_(4, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(0, (Goal)new NearestAttackableTargetGoal((Mob)this, SpindlyGemCrabEntity.class, 90, true, false, null));
        this.f_21346_.m_25352_(1, (Goal)new NearestAttackableTargetGoal((Mob)this, Mob.class, 10, true, false, RubberBellyGliderEntity::isEntityPrey));
    }

    public static AttributeSupplier.Builder registerRBGAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22281_, 1.0).m_22268_(Attributes.f_22276_, 25.0).m_22268_(Attributes.f_22279_, 0.12);
    }

    private static boolean isEntityPrey(Entity entity) {
        return entity instanceof Squid || entity instanceof BandedRedbackShrimpEntity || entity instanceof WhiteBullCrabEntity || entity instanceof RedBullCrabEntity;
    }

    public boolean m_6040_() {
        return true;
    }

    public MobType m_6336_() {
        return MobType.f_21644_;
    }

    public void m_6075_() {
        super.m_6075_();
        this.m_20301_(300);
    }

    public boolean m_6063_() {
        return false;
    }

    public boolean m_6573_(Player player) {
        return true;
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(PUFFED, (Object)false);
    }

    public boolean isPuffed() {
        return (Boolean)this.f_19804_.m_135370_(PUFFED);
    }

    public void setPuffed(boolean p_203714_1_) {
        this.f_19804_.m_135381_(PUFFED, (Object)p_203714_1_);
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128379_("Puffed", this.isPuffed());
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.setPuffed(compound.m_128471_("Puffed"));
    }

    public void m_7350_(EntityDataAccessor<?> key) {
        if (PUFFED.equals(key)) {
            this.m_6210_();
        }
        super.m_7350_(key);
    }

    protected PathNavigation m_6037_(Level worldIn) {
        return new GroundAndSwimmerNavigator((PathfinderMob)this, this.m_9236_());
    }

    public void m_7023_(Vec3 travelVector) {
        if (this.m_21515_() && !this.m_20069_()) {
            float speedMod = this.m_5448_() != null && this.m_5448_().m_6084_() ? 2.5f : 1.0f;
            this.m_7910_((float)this.m_21133_(Attributes.f_22279_) * speedMod);
        }
        if (this.m_21515_() && this.m_20069_()) {
            this.m_19920_(0.1f, travelVector);
            this.m_6478_(MoverType.SELF, this.m_20184_());
            this.m_20256_(this.m_20184_().m_82490_(0.9));
        } else {
            super.m_7023_(travelVector);
        }
    }

    public int m_8100_() {
        return 500;
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.isPuffed() && ++this.puffTimer >= 100) {
            this.m_5496_(SoundEvents.f_12290_, this.m_6121_(), this.m_6100_());
            this.setPuffed(false);
            this.puffTimer = 0;
        }
    }

    public ItemStack getPickedResult(HitResult target) {
        return new ItemStack((ItemLike)FTItems.RUBBER_BELLY_GLIDER_SPAWN_EGG.get());
    }

    public AgeableMob m_142606_(ServerLevel serverWorld, AgeableMob ageableEntity) {
        return (AgeableMob)((EntityType)FTEntities.RUBBER_BELLY_GLIDER.get()).m_20615_(this.m_9236_());
    }

    public void m_6123_(Player entityIn) {
        if (entityIn instanceof ServerPlayer && this.isPuffed()) {
            entityIn.m_6469_(this.m_9236_().m_269111_().m_269333_((LivingEntity)this), 2.0f);
            entityIn.m_7292_(new MobEffectInstance(MobEffects.f_19614_, 200, 0));
        }
    }

    protected SoundEvent m_7515_() {
        return (SoundEvent)FTSounds.RUBBER_BELLY_GLIDER_AMBIENT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)FTSounds.RUBBER_BELLY_GLIDER_DEATH.get();
    }

    protected SoundEvent m_7975_(DamageSource damageSourceIn) {
        return (SoundEvent)FTSounds.RUBBER_BELLY_GLIDER_HURT.get();
    }

    protected float m_6431_(Pose poseIn, EntityDimensions sizeIn) {
        return this.m_6162_() ? 0.05f : 0.15f;
    }

    protected float m_6121_() {
        return 0.4f;
    }

    public EntityDimensions m_6972_(Pose poseIn) {
        return this.isPuffed() ? PUFFED_SIZE : super.m_6972_(poseIn);
    }

    public boolean m_6898_(ItemStack stack) {
        return stack.m_204117_(FTTags.SPINDLY_GEM_CRABS);
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        controllerRegistrar.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 5, this::predicate)});
    }

    private <E extends GeoEntity> PlayState predicate(AnimationState<E> event) {
        if (event.isMoving() && this.m_20069_()) {
            if (this.isPuffed()) {
                event.setAnimation(RawAnimation.begin().thenLoop("animation.rubber_belly_glider.swim_puffed"));
            } else {
                event.setAnimation(RawAnimation.begin().thenLoop("animation.rubber_belly_glider.swim"));
            }
        } else if (!event.isMoving() && this.m_20069_()) {
            if (this.isPuffed()) {
                event.setAnimation(RawAnimation.begin().thenLoop("animation.rubber_belly_glider.idle_puffed"));
            } else {
                event.setAnimation(RawAnimation.begin().thenLoop("animation.rubber_belly_glider.idle"));
            }
        } else if (!this.m_20069_()) {
            boolean walking;
            boolean bl = walking = !(event.getLimbSwingAmount() > -0.1f) || !(event.getLimbSwingAmount() < 0.1f);
            if (walking) {
                event.setAnimation(RawAnimation.begin().thenLoop("animation.rubber_belly_glider.walk"));
                event.getController().setAnimationSpeed((double)1.45f);
            } else {
                event.setAnimation(RawAnimation.begin().thenLoop("animation.rubber_belly_glider.idle_land"));
            }
        }
        return PlayState.CONTINUE;
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.factory;
    }

    static class PuffGoal
    extends Goal {
        private final RubberBellyGliderEntity glider;

        public PuffGoal(RubberBellyGliderEntity glider) {
            this.glider = glider;
        }

        public boolean m_8036_() {
            return this.glider.m_20069_() && !this.glider.isPuffed() && !this.glider.m_9236_().m_6249_((Entity)this.glider, this.glider.m_20191_().m_82400_(2.5), ENEMY_MATCHER).isEmpty();
        }

        public void m_8056_() {
            this.glider.m_5496_(SoundEvents.f_12291_, this.glider.m_6121_(), this.glider.m_6100_());
            this.glider.setPuffed(true);
        }
    }
}

