/*
 * Decompiled with CFR 0.152.
 */
package teamdraco.finsandstails.common.entities;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.control.SmoothSwimmingLookControl;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.RandomSwimmingGoal;
import net.minecraft.world.entity.ai.goal.SitWhenOrderedToGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.Bucketable;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.BedBlock;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.ForgeEventFactory;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;
import teamdraco.finsandstails.common.entities.BandedRedbackShrimpEntity;
import teamdraco.finsandstails.common.entities.BluWeeEntity;
import teamdraco.finsandstails.common.entities.HighFinnedBlueEntity;
import teamdraco.finsandstails.common.entities.PapaWeeEntity;
import teamdraco.finsandstails.common.entities.PeaWeeEntity;
import teamdraco.finsandstails.common.entities.WeeWeeEntity;
import teamdraco.finsandstails.common.entities.ai.control.GroundAndSwimmerNavigator;
import teamdraco.finsandstails.registry.FTItems;
import teamdraco.finsandstails.registry.FTSounds;

public class PenglilEntity
extends TamableAnimal
implements Bucketable,
GeoEntity {
    private static final EntityDataAccessor<Integer> VARIANT = SynchedEntityData.m_135353_(PenglilEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> IS_LYING = SynchedEntityData.m_135353_(PenglilEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> RELAX_STATE_ONE = SynchedEntityData.m_135353_(PenglilEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> FROM_BUCKET = SynchedEntityData.m_135353_(PenglilEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private final AnimatableInstanceCache factory = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);

    public PenglilEntity(EntityType<? extends PenglilEntity> type, Level world) {
        super(type, world);
        this.f_21342_ = new MoveHelperController(this);
        this.f_21365_ = new SmoothSwimmingLookControl((Mob)this, 45);
    }

    public float m_274421_() {
        return 1.0f;
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new SitWhenOrderedToGoal((TamableAnimal)this));
        this.f_21345_.m_25352_(1, (Goal)new PanicGoal((PathfinderMob)this, 1.5));
        this.f_21345_.m_25352_(1, (Goal)new AvoidEntityGoal((PathfinderMob)this, PapaWeeEntity.class, 8.0f, 1.6, 1.4));
        this.f_21345_.m_25352_(1, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21345_.m_25352_(2, (Goal)new RandomStrollGoal((PathfinderMob)this, 1.0, 10){

            public boolean m_8036_() {
                return !PenglilEntity.this.m_21825_() && !this.f_25725_.m_20069_() && super.m_8036_();
            }
        });
        this.f_21345_.m_25352_(2, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, true));
        this.f_21345_.m_25352_(2, (Goal)new RandomSwimmingGoal((PathfinderMob)this, 1.0, 1){

            public boolean m_8036_() {
                return !PenglilEntity.this.m_21825_() && super.m_8036_() && PenglilEntity.this.m_20069_();
            }
        });
        this.f_21345_.m_25352_(3, (Goal)new MorningGiftGoal(this));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, PeaWeeEntity.class, true));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, BluWeeEntity.class, true));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, BandedRedbackShrimpEntity.class, true));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, HighFinnedBlueEntity.class, true));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, WeeWeeEntity.class, true));
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 10.0).m_22268_(Attributes.f_22281_, 1.0).m_22268_(Attributes.f_22279_, 0.15);
    }

    protected PathNavigation m_6037_(Level worldIn) {
        return new GroundAndSwimmerNavigator((PathfinderMob)this, this.m_9236_());
    }

    public boolean m_6040_() {
        return true;
    }

    public boolean m_6063_() {
        return false;
    }

    public static boolean canPenglilSpawn(EntityType<? extends TamableAnimal> penglil, LevelAccessor worldIn, MobSpawnType reason, BlockPos pos, RandomSource random) {
        return worldIn.m_8055_(pos.m_7495_()).m_60734_() == Blocks.f_49992_ && worldIn.m_45524_(pos, 0) > 8;
    }

    public void m_7105_(boolean tamed) {
        super.m_7105_(tamed);
        if (tamed) {
            this.m_21051_(Attributes.f_22276_).m_22100_(20.0);
            this.m_21153_(20.0f);
        } else {
            this.m_21051_(Attributes.f_22276_).m_22100_(10.0);
        }
    }

    public boolean m_27487_() {
        return (Boolean)this.f_19804_.m_135370_(FROM_BUCKET);
    }

    public void m_27497_(boolean fromBucket) {
        this.f_19804_.m_135381_(FROM_BUCKET, (Object)fromBucket);
    }

    @Nonnull
    public ItemStack m_28282_() {
        return new ItemStack((ItemLike)FTItems.PENGLIL_BUCKET.get());
    }

    @Nonnull
    public SoundEvent m_142623_() {
        return SoundEvents.f_12013_;
    }

    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        ItemStack heldItem = player.m_21120_(hand);
        Item item = heldItem.m_41720_();
        ItemStack itemstack1 = new ItemStack((ItemLike)FTItems.PENGLIL_BUCKET.get());
        InteractionResult actionresulttype = super.m_6071_(player, hand);
        if (this.m_9236_().m_5776_()) {
            return InteractionResult.CONSUME;
        }
        if (heldItem.m_41720_() == Items.f_42446_ && this.m_6084_() && !this.m_21827_()) {
            this.m_5496_(this.m_142623_(), 1.0f, 1.0f);
            heldItem.m_41774_(1);
            this.m_6872_(itemstack1);
            if (!this.m_9236_().f_46443_) {
                CriteriaTriggers.f_10576_.m_38772_((ServerPlayer)player, itemstack1);
            }
            if (heldItem.m_41619_()) {
                player.m_21008_(hand, itemstack1);
            } else if (!player.m_150109_().m_36054_(itemstack1)) {
                player.m_36176_(itemstack1, false);
            }
            this.m_146870_();
            return InteractionResult.SUCCESS;
        }
        float maxHealth = this.m_21233_();
        float health = this.m_21223_();
        if (heldItem.m_41720_() == FTItems.BLU_WEE.get() && health < maxHealth) {
            if (!player.m_7500_()) {
                heldItem.m_41774_(1);
            }
            this.m_5634_(2.0f);
            double d0 = this.f_19796_.m_188583_() * 0.02;
            double d1 = this.f_19796_.m_188583_() * 0.02;
            double d2 = this.f_19796_.m_188583_() * 0.02;
            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123750_, this.m_20208_(1.0), this.m_20187_() + 0.5, this.m_20262_(1.0), d0, d1, d2);
            return InteractionResult.SUCCESS;
        }
        if (item == FTItems.HIGH_FINNED_BLUE.get() && !this.m_21824_()) {
            if (!player.m_150110_().f_35937_) {
                heldItem.m_41774_(1);
            }
            if (this.f_19796_.m_188503_(3) == 0 && !ForgeEventFactory.onAnimalTame((Animal)this, (Player)player)) {
                this.m_21828_(player);
                this.f_21344_.m_26573_();
                this.m_6710_(null);
                this.m_21839_(!this.m_20069_());
                this.m_9236_().m_7605_((Entity)this, (byte)7);
            } else {
                this.m_9236_().m_7605_((Entity)this, (byte)6);
            }
            return InteractionResult.SUCCESS;
        }
        if (this.m_21830_((LivingEntity)player) && item != FTItems.HIGH_FINNED_BLUE.get() && !this.m_20069_()) {
            this.m_21839_(!this.m_21827_());
            this.f_20899_ = false;
            this.f_21344_.m_26573_();
            return InteractionResult.SUCCESS;
        }
        return actionresulttype;
    }

    public int m_8100_() {
        return 480;
    }

    public void m_6872_(ItemStack bucket) {
        CompoundTag compoundnbt = bucket.m_41784_();
        compoundnbt.m_128405_("Variant", this.getVariant());
        if (this.m_21824_()) {
            compoundnbt.m_128362_("Owner", this.m_21805_());
        }
        if (this.m_8077_()) {
            bucket.m_41714_(this.m_7770_());
        }
    }

    public void m_142278_(CompoundTag compoundTag) {
        this.setVariant(compoundTag.m_128451_("Variant"));
        if (compoundTag.m_128441_("Owner")) {
            this.m_21816_(compoundTag.m_128342_("Owner"));
        }
    }

    public void m_7023_(Vec3 travelVector) {
        if (this.m_21825_() && !this.m_20069_()) {
            if (this.m_21573_().m_26570_() != null) {
                this.m_21573_().m_26573_();
            }
            travelVector = Vec3.f_82478_;
        } else {
            if (this.m_21515_() && !this.m_20069_()) {
                float speedMod = this.m_5448_() != null && this.m_5448_().m_6084_() ? 2.5f : 1.0f;
                this.m_7910_((float)this.m_21133_(Attributes.f_22279_) * speedMod);
            }
            if (this.m_21515_() && this.m_20069_() && !this.m_21825_()) {
                this.m_19920_(0.1f, travelVector);
                this.m_6478_(MoverType.SELF, this.m_20184_());
                this.m_20256_(this.m_20184_().m_82490_(0.9));
            }
        }
        super.m_7023_(travelVector);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(VARIANT, (Object)0);
        this.f_19804_.m_135372_(IS_LYING, (Object)false);
        this.f_19804_.m_135372_(RELAX_STATE_ONE, (Object)false);
        this.f_19804_.m_135372_(FROM_BUCKET, (Object)false);
    }

    public int getVariant() {
        return (Integer)this.f_19804_.m_135370_(VARIANT);
    }

    private void setVariant(int variant) {
        this.f_19804_.m_135381_(VARIANT, (Object)variant);
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128405_("Variant", this.getVariant());
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.setVariant(compound.m_128451_("Variant"));
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor worldIn, DifficultyInstance difficultyIn, MobSpawnType reason, @Nullable SpawnGroupData spawnDataIn, @Nullable CompoundTag dataTag) {
        spawnDataIn = super.m_6518_(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
        if (dataTag == null) {
            this.setVariant(this.f_19796_.m_188503_(8));
        } else {
            if (dataTag.m_128425_("Variant", 3)) {
                this.setVariant(dataTag.m_128451_("Variant"));
            }
            if (dataTag.m_128403_("Owner")) {
                this.m_21816_(dataTag.m_128342_("Owner"));
                this.m_7105_(true);
            }
        }
        return spawnDataIn;
    }

    @Nullable
    public AgeableMob m_142606_(ServerLevel p_241840_1_, AgeableMob p_241840_2_) {
        return null;
    }

    protected SoundEvent m_7515_() {
        return (SoundEvent)FTSounds.PENGLIL_AMBIENT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)FTSounds.PENGLIL_DEATH.get();
    }

    protected SoundEvent m_7975_(DamageSource damageSourceIn) {
        return (SoundEvent)FTSounds.PENGLIL_HURT.get();
    }

    public ItemStack getPickedResult(HitResult target) {
        return new ItemStack((ItemLike)FTItems.PENGLIL_SPAWN_EGG.get());
    }

    public boolean isLying() {
        return (Boolean)this.f_19804_.m_135370_(IS_LYING);
    }

    public void setLying(boolean p_213419_1_) {
        this.f_19804_.m_135381_(IS_LYING, (Object)p_213419_1_);
    }

    public void setRelaxStateOne(boolean p_213415_1_) {
        this.f_19804_.m_135381_(RELAX_STATE_ONE, (Object)p_213415_1_);
    }

    public boolean isRelaxStateOne() {
        return (Boolean)this.f_19804_.m_135370_(RELAX_STATE_ONE);
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.m_20069_()) {
            this.m_21839_(false);
        }
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        controllerRegistrar.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 5, this::predicate)});
    }

    private <E extends GeoEntity> PlayState predicate(AnimationState<E> event) {
        if (this.m_21825_()) {
            event.setAnimation(RawAnimation.begin().thenLoop("animation.penglil.sit"));
        } else if (!this.m_20069_()) {
            if (event.isMoving()) {
                event.setAnimation(RawAnimation.begin().thenLoop("animation.penglil.walk"));
            } else {
                event.setAnimation(RawAnimation.begin().thenLoop("animation.penglil.idle"));
            }
        } else {
            event.setAnimation(RawAnimation.begin().thenLoop("animation.penglil.swim"));
        }
        return PlayState.CONTINUE;
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.factory;
    }

    static class MoveHelperController
    extends MoveControl {
        private final PenglilEntity penglil;

        MoveHelperController(PenglilEntity penglil) {
            super((Mob)penglil);
            this.penglil = penglil;
        }

        private void updateSpeed() {
            if (this.penglil.m_20069_()) {
                this.penglil.m_20256_(this.penglil.m_20184_().m_82520_(0.0, 5.0E-4, 0.0));
                if (this.penglil.m_6162_()) {
                    this.penglil.m_7910_(Math.max(this.penglil.m_6113_() / 3.0f, 0.06f));
                }
            } else if (this.penglil.m_20096_()) {
                this.penglil.m_7910_(Math.max(this.penglil.m_6113_(), 0.06f));
            }
        }

        public void m_8126_() {
            if (this.penglil.m_21825_()) {
                return;
            }
            this.updateSpeed();
            if (this.f_24981_ == MoveControl.Operation.MOVE_TO && !this.penglil.m_21573_().m_26571_()) {
                double d0 = this.f_24975_ - this.penglil.m_20185_();
                double d1 = this.f_24976_ - this.penglil.m_20186_();
                double d2 = this.f_24977_ - this.penglil.m_20189_();
                double d3 = Mth.m_14116_((float)((float)(d0 * d0 + d1 * d1 + d2 * d2)));
                d1 /= d3;
                float f = (float)(Mth.m_14136_((double)d2, (double)d0) * 57.2957763671875) - 90.0f;
                this.penglil.m_146922_(this.m_24991_(this.penglil.m_146908_(), f, 90.0f));
                this.penglil.f_20883_ = this.penglil.m_146908_();
                float f1 = (float)(this.f_24978_ * this.penglil.m_21133_(Attributes.f_22279_));
                this.penglil.m_7910_(Mth.m_14179_((float)0.125f, (float)this.penglil.m_6113_(), (float)f1));
                this.penglil.m_20256_(this.penglil.m_20184_().m_82520_(0.0, (double)this.penglil.m_6113_() * d1 * 0.1, 0.0));
            } else {
                this.penglil.m_7910_(0.0f);
            }
        }
    }

    static class MorningGiftGoal
    extends Goal {
        private final PenglilEntity penglil;
        private Player owner;
        private BlockPos bedPos;
        private int tickCounter;

        public MorningGiftGoal(PenglilEntity catIn) {
            this.penglil = catIn;
        }

        public boolean m_8036_() {
            if (!this.penglil.m_21824_()) {
                return false;
            }
            if (this.penglil.m_21827_()) {
                return false;
            }
            LivingEntity livingentity = this.penglil.m_269323_();
            if (livingentity instanceof Player) {
                this.owner = (Player)livingentity;
                if (!livingentity.m_5803_()) {
                    return false;
                }
                if (this.penglil.m_20280_((Entity)this.owner) > 100.0) {
                    return false;
                }
                BlockPos blockpos = this.owner.m_20183_();
                BlockState blockstate = this.penglil.m_9236_().m_8055_(blockpos);
                if (blockstate.m_204336_(BlockTags.f_13038_)) {
                    this.bedPos = blockstate.m_61145_((Property)BedBlock.f_54117_).map(p_234186_1_ -> blockpos.m_121945_(p_234186_1_.m_122424_())).orElseGet(() -> new BlockPos((Vec3i)blockpos));
                    return !this.spaceIsOccupied();
                }
            }
            return false;
        }

        private boolean spaceIsOccupied() {
            for (PenglilEntity penglilentity : this.penglil.m_9236_().m_45976_(PenglilEntity.class, new AABB(this.bedPos).m_82400_(2.0))) {
                if (penglilentity == this.penglil || !penglilentity.isLying() && !penglilentity.isRelaxStateOne()) continue;
                return true;
            }
            return false;
        }

        public boolean m_8045_() {
            return this.penglil.m_21824_() && !this.penglil.m_21827_() && this.owner != null && this.owner.m_5803_() && this.bedPos != null && !this.spaceIsOccupied();
        }

        public void m_8056_() {
            if (this.bedPos != null) {
                this.penglil.m_21839_(false);
                this.penglil.m_21573_().m_26519_((double)this.bedPos.m_123341_(), (double)this.bedPos.m_123342_(), (double)this.bedPos.m_123343_(), (double)1.1f);
            }
        }

        public void m_8041_() {
            this.penglil.setLying(false);
            float f = this.penglil.m_9236_().m_46942_(1.0f);
            if (this.owner.m_36318_() >= 100 && (double)f > 0.77 && (double)f < 0.8 && (double)this.penglil.m_9236_().m_213780_().m_188501_() < 0.5) {
                this.giveMorningGift();
            }
            this.tickCounter = 0;
            this.penglil.setRelaxStateOne(false);
            this.penglil.m_21573_().m_26573_();
        }

        private void giveMorningGift() {
            RandomSource random = this.penglil.m_217043_();
            BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
            mutable.m_122190_((Vec3i)this.penglil.m_20183_());
            this.penglil.m_20984_(mutable.m_123341_() + random.m_188503_(11) - 5, mutable.m_123342_() + random.m_188503_(5) - 2, mutable.m_123343_() + random.m_188503_(11) - 5, false);
            mutable.m_122190_((Vec3i)this.penglil.m_20183_());
            LootTable loottable = this.penglil.m_9236_().m_7654_().m_278653_().m_278676_(BuiltInLootTables.f_78720_);
            LootParams.Builder lootcontext$builder = new LootParams.Builder((ServerLevel)this.penglil.m_9236_()).m_287286_(LootContextParams.f_81460_, (Object)this.penglil.m_20182_()).m_287286_(LootContextParams.f_81455_, (Object)this.penglil);
            for (ItemStack itemstack : loottable.m_287195_(lootcontext$builder.m_287235_(LootContextParamSets.f_81416_))) {
                this.penglil.m_9236_().m_7967_((Entity)new ItemEntity(this.penglil.m_9236_(), (double)mutable.m_123341_() - (double)Mth.m_14031_((float)(this.penglil.f_20883_ * ((float)Math.PI / 180))), (double)mutable.m_123342_(), (double)mutable.m_123343_() + (double)Mth.m_14089_((float)(this.penglil.f_20883_ * ((float)Math.PI / 180))), itemstack));
            }
        }

        public void m_8037_() {
            if (this.owner != null && this.bedPos != null) {
                this.penglil.m_21839_(false);
                this.penglil.m_21573_().m_26519_((double)this.bedPos.m_123341_(), (double)this.bedPos.m_123342_(), (double)this.bedPos.m_123343_(), (double)1.1f);
                if (this.penglil.m_20280_((Entity)this.owner) < 2.5) {
                    ++this.tickCounter;
                    if (this.tickCounter > 16) {
                        this.penglil.setLying(true);
                        this.penglil.setRelaxStateOne(false);
                    } else {
                        this.penglil.m_21391_((Entity)this.owner, 45.0f, 45.0f);
                        this.penglil.setRelaxStateOne(true);
                    }
                } else {
                    this.penglil.setLying(false);
                }
            }
        }
    }
}

