/*
 * Decompiled with CFR 0.152.
 */
package teamdraco.finsandstails.common.entities;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomSwimmingGoal;
import net.minecraft.world.entity.animal.AbstractSchoolingFish;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;
import teamdraco.finsandstails.registry.FTItems;

public class NightLightSquidEntity
extends AbstractSchoolingFish
implements GeoEntity {
    private static final EntityDataAccessor<Integer> VARIANT = SynchedEntityData.m_135353_(NightLightSquidEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private final AnimatableInstanceCache factory = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    public float prevSquidPitch;
    public float squidRotation;

    public NightLightSquidEntity(EntityType<? extends NightLightSquidEntity> type, Level worldIn) {
        super(type, worldIn);
        this.f_21342_ = new MoveHelperController(this);
    }

    public void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new PanicGoal((PathfinderMob)this, 2.0));
        this.f_21345_.m_25352_(2, (Goal)new RandomSwimmingGoal((PathfinderMob)this, 1.0, 1));
    }

    public static AttributeSupplier.Builder m_27495_() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 10.0);
    }

    public float m_6431_(Pose poseIn, EntityDimensions sizeIn) {
        return sizeIn.f_20378_ * 0.5f;
    }

    public SoundEvent m_7515_() {
        return SoundEvents.f_12438_;
    }

    public SoundEvent m_7975_(DamageSource damageSourceIn) {
        return SoundEvents.f_12440_;
    }

    public SoundEvent m_5592_() {
        return SoundEvents.f_12439_;
    }

    public float m_6121_() {
        return 0.4f;
    }

    public ItemStack m_28282_() {
        return new ItemStack((ItemLike)FTItems.NIGHT_LIGHT_SQUID_BUCKET.get());
    }

    public SoundEvent m_5699_() {
        return SoundEvents.f_11760_;
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor worldIn, DifficultyInstance difficultyIn, MobSpawnType reason, @Nullable SpawnGroupData spawnDataIn, @Nullable CompoundTag dataTag) {
        if (dataTag == null) {
            this.setVariant(this.f_19796_.m_188503_(4));
        } else if (dataTag.m_128425_("Variant", 3)) {
            this.setVariant(dataTag.m_128451_("Variant"));
        }
        return spawnDataIn;
    }

    public void m_6872_(ItemStack bucket) {
        CompoundTag compoundnbt = bucket.m_41784_();
        compoundnbt.m_128405_("Variant", this.getVariant());
    }

    public void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(VARIANT, (Object)0);
    }

    public int getVariant() {
        return (Integer)this.f_19804_.m_135370_(VARIANT);
    }

    public void setVariant(int variant) {
        this.f_19804_.m_135381_(VARIANT, (Object)variant);
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128405_("Variant", this.getVariant());
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.setVariant(compound.m_128451_("Variant"));
    }

    public boolean m_6469_(DamageSource source, float amount) {
        if (super.m_6469_(source, amount) && this.m_21188_() != null) {
            this.squirtInk();
            return true;
        }
        return false;
    }

    private Vec3 rotateVector(Vec3 p_207400_1_) {
        Vec3 vector3d = p_207400_1_.m_82496_(this.prevSquidPitch * ((float)Math.PI / 180));
        return vector3d.m_82524_(-this.f_20884_ * ((float)Math.PI / 180));
    }

    private void squirtInk() {
        this.m_5496_(SoundEvents.f_12441_, this.m_6121_(), this.m_6100_());
        Vec3 vector3d = this.rotateVector(new Vec3(0.0, -1.0, 0.0)).m_82520_(this.m_20185_(), this.m_20186_(), this.m_20189_());
        for (int i = 0; i < 30; ++i) {
            Vec3 vector3d1 = this.rotateVector(new Vec3((double)this.f_19796_.m_188501_() * 0.6 - 0.3, -1.0, (double)this.f_19796_.m_188501_() * 0.6 - 0.3));
            Vec3 vector3d2 = vector3d1.m_82490_(0.3 + (double)(this.f_19796_.m_188501_() * 2.0f));
            ((ServerLevel)this.m_9236_()).m_8767_((ParticleOptions)ParticleTypes.f_123765_, vector3d.f_82479_, vector3d.f_82480_ + 0.5, vector3d.f_82481_, 0, vector3d2.f_82479_, vector3d2.f_82480_, vector3d2.f_82481_, (double)0.1f);
        }
    }

    public void m_7023_(Vec3 travelVector) {
        if (this.m_21515_() && this.m_20069_()) {
            this.m_19920_(0.01f, travelVector);
            this.m_6478_(MoverType.SELF, this.m_20184_());
            this.m_20256_(this.m_20184_().m_82490_(0.9));
            if (this.m_5448_() == null) {
                this.m_20256_(this.m_20184_().m_82520_(0.0, -0.005, 0.0));
            }
        } else {
            super.m_7023_(travelVector);
        }
    }

    public static boolean checkSquidSpawnRules(EntityType<NightLightSquidEntity> entity, LevelAccessor world, MobSpawnType reason, BlockPos pos, RandomSource p_223365_4_) {
        return pos.m_123342_() < world.m_5736_() && world.m_8055_(pos.m_7494_()).m_60713_(Blocks.f_49990_);
    }

    public void m_7822_(byte id) {
        if (id == 19) {
            this.squidRotation = 0.0f;
        } else {
            super.m_7822_(id);
        }
    }

    public ItemStack getPickedResult(HitResult target) {
        return new ItemStack((ItemLike)FTItems.NIGHT_LIGHT_SQUID_SPAWN_EGG.get());
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        controllerRegistrar.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 5, this::predicate)});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.factory;
    }

    private <E extends GeoEntity> PlayState predicate(AnimationState<E> event) {
        if (event.isMoving()) {
            event.setAnimation(RawAnimation.begin().thenLoop("animation.nightlight_squid.swim"));
        } else {
            event.setAnimation(RawAnimation.begin().thenLoop("animation.nightlight_squid.idle"));
        }
        return PlayState.CONTINUE;
    }

    static class MoveHelperController
    extends MoveControl {
        private final NightLightSquidEntity fish;

        MoveHelperController(NightLightSquidEntity fish) {
            super((Mob)fish);
            this.fish = fish;
        }

        public void m_8126_() {
            if (this.fish.m_204029_(FluidTags.f_13131_)) {
                this.fish.m_20256_(this.fish.m_20184_().m_82520_(0.0, 0.005, 0.0));
            }
            if (this.f_24981_ == MoveControl.Operation.MOVE_TO && !this.fish.m_21573_().m_26571_()) {
                float f = (float)(this.f_24978_ * this.fish.m_21133_(Attributes.f_22279_));
                this.fish.m_7910_(Mth.m_14179_((float)0.125f, (float)this.fish.m_6113_(), (float)f));
                double d0 = this.f_24975_ - this.fish.m_20185_();
                double d1 = this.f_24976_ - this.fish.m_20186_();
                double d2 = this.f_24977_ - this.fish.m_20189_();
                if (d1 != 0.0) {
                    double d3 = Mth.m_14116_((float)((float)(d0 * d0 + d1 * d1 + d2 * d2)));
                    this.fish.m_20256_(this.fish.m_20184_().m_82520_(0.0, (double)this.fish.m_6113_() * (d1 / d3) * 0.1, 0.0));
                }
                if (d0 != 0.0 || d2 != 0.0) {
                    float f1 = (float)(Mth.m_14136_((double)d2, (double)d0) * 57.2957763671875) - 90.0f;
                    this.fish.m_146922_(this.m_24991_(this.fish.m_146908_(), f1, 90.0f));
                    this.fish.f_20883_ = this.fish.m_146908_();
                }
            } else {
                this.fish.m_7910_(0.0f);
            }
        }
    }
}

