/*
 * Decompiled with CFR 0.152.
 */
package teamdraco.finsandstails.common.entities;

import java.util.EnumSet;
import net.minecraft.core.BlockPos;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FollowParentGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.TargetGoal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.monster.Ghast;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;
import teamdraco.finsandstails.common.entities.ai.goals.MudhorseForageGoal;
import teamdraco.finsandstails.registry.FTEntities;
import teamdraco.finsandstails.registry.FTItems;
import teamdraco.finsandstails.registry.FTSounds;

public class MudhorseEntity
extends Animal
implements GeoEntity {
    public static final EntityDataAccessor<Boolean> FORAGING = SynchedEntityData.m_135353_(MudhorseEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private final AnimatableInstanceCache factory = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private LivingEntity commander;
    public int commanderSetTime;

    public MudhorseEntity(EntityType<? extends MudhorseEntity> type, Level worldIn) {
        super(type, worldIn);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new BreedGoal((Animal)this, 1.0));
        this.f_21345_.m_25352_(2, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.25, true));
        this.f_21345_.m_25352_(3, (Goal)new TemptGoal((PathfinderMob)this, 1.25, Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)FTItems.SWAMP_MUCKER.get()}), false));
        this.f_21345_.m_25352_(3, (Goal)new FollowParentGoal((Animal)this, 1.25));
        this.f_21345_.m_25352_(4, (Goal)new MudhorseForageGoal(this));
        this.f_21345_.m_25352_(5, (Goal)new RandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(6, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.f_21345_.m_25352_(7, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21346_.m_25352_(2, (Goal)new CommanderHurt(this));
    }

    public boolean m_6040_() {
        return true;
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 30.0).m_22268_(Attributes.f_22281_, 2.0).m_22268_(Attributes.f_22279_, 0.22);
    }

    public boolean isForaging() {
        return (Boolean)this.f_19804_.m_135370_(FORAGING);
    }

    public void setForaging(boolean p_213419_1_) {
        this.f_19804_.m_135381_(FORAGING, (Object)p_213419_1_);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(FORAGING, (Object)false);
    }

    public boolean m_7327_(Entity entityIn) {
        this.m_9236_().m_7605_((Entity)this, (byte)4);
        boolean flag = entityIn.m_6469_(this.m_9236_().m_269111_().m_269333_((LivingEntity)this), (float)this.m_21133_(Attributes.f_22281_));
        if (flag) {
            entityIn.m_20256_(entityIn.m_20184_().m_82520_(0.0, (double)0.3f, 0.0));
            this.m_19970_((LivingEntity)this, entityIn);
        }
        return flag;
    }

    public boolean m_6898_(ItemStack stack) {
        return stack.m_41720_() == FTItems.SWAMP_MUCKER.get();
    }

    protected SoundEvent m_7515_() {
        return (SoundEvent)FTSounds.MUDHORSE_AMBIENT.get();
    }

    protected SoundEvent m_7975_(DamageSource damageSourceIn) {
        return (SoundEvent)FTSounds.MUDHORSE_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)FTSounds.MUDHORSE_DEATH.get();
    }

    protected void m_7355_(BlockPos pos, BlockState blockIn) {
        this.m_5496_(SoundEvents.f_12035_, 0.15f, 1.0f);
    }

    protected float m_6121_() {
        return 0.4f;
    }

    public void m_8107_() {
        if (this.commanderSetTime > 0) {
            --this.commanderSetTime;
        } else {
            this.commander = null;
        }
        super.m_8107_();
    }

    @Nullable
    public AgeableMob m_142606_(ServerLevel world, AgeableMob ageable) {
        return (AgeableMob)((EntityType)FTEntities.MUDHORSE.get()).m_20615_((Level)world);
    }

    protected float m_6431_(Pose poseIn, EntityDimensions sizeIn) {
        return this.m_6162_() ? 0.7f : 1.4f;
    }

    public ItemStack getPickedResult(HitResult target) {
        return new ItemStack((ItemLike)FTItems.MUDHORSE_SPAWN_EGG.get());
    }

    public LivingEntity getCommander() {
        return this.commander;
    }

    public void setCommander(LivingEntity commander) {
        this.commander = commander;
        this.commanderSetTime = 600;
    }

    public boolean m_6779_(LivingEntity target) {
        return !(target instanceof MudhorseEntity) && super.m_6779_(target);
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        controllerRegistrar.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 5, this::predicate)});
        controllerRegistrar.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "miscController", 0, this::miscPredicate)});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.factory;
    }

    private <E extends GeoEntity> PlayState predicate(AnimationState<E> event) {
        if (event.isMoving()) {
            event.setAnimation(RawAnimation.begin().thenLoop("animation.mudhorse.walk"));
        } else if (this.isForaging()) {
            event.setAnimation(RawAnimation.begin().thenLoop("animation.mudhorse.grazing"));
        } else {
            event.setAnimation(RawAnimation.begin().thenLoop("animation.mudhorse.idle"));
        }
        return PlayState.CONTINUE;
    }

    private <E extends GeoEntity> PlayState miscPredicate(AnimationState<E> event) {
        if (this.commanderSetTime > 0) {
            event.setAnimation(RawAnimation.begin().thenLoop("animation.mudhorse.entranced"));
        }
        return PlayState.CONTINUE;
    }

    public void m_7023_(Vec3 p_21280_) {
        float speedMod = this.m_20069_() && this.m_5448_() != null ? 1.5f : 1.0f;
        this.m_7910_((float)this.m_21133_(Attributes.f_22279_) * speedMod);
        super.m_7023_(p_21280_);
    }

    private static class CommanderHurt
    extends TargetGoal {
        private final MudhorseEntity mudhorse;
        private LivingEntity attacker;
        private int timestamp;

        public CommanderHurt(MudhorseEntity mudhorse) {
            super((Mob)mudhorse, false);
            this.mudhorse = mudhorse;
            this.m_7021_(EnumSet.of(Goal.Flag.TARGET));
        }

        public boolean m_8036_() {
            LivingEntity livingentity = this.mudhorse.getCommander();
            if (livingentity != null) {
                this.attacker = livingentity.m_21214_();
                int i = livingentity.m_21215_();
                if (i != this.timestamp && this.m_26150_(this.attacker, TargetingConditions.f_26872_)) {
                    if (!(this.f_26137_ instanceof Creeper) && !(this.f_26137_ instanceof Ghast)) {
                        LivingEntity livingEntity = this.f_26137_;
                        if (livingEntity instanceof TamableAnimal) {
                            TamableAnimal tamable = (TamableAnimal)livingEntity;
                            return !tamable.m_21824_() || tamable.m_269323_() != livingentity;
                        }
                        if (this.f_26137_ instanceof Player && livingentity instanceof Player && !((Player)livingentity).m_7099_((Player)this.f_26137_)) {
                            return false;
                        }
                        if (this.f_26137_ instanceof AbstractHorse && ((AbstractHorse)this.f_26137_).m_30614_()) {
                            return false;
                        }
                        return !(this.f_26137_ instanceof TamableAnimal) || !((TamableAnimal)this.f_26137_).m_21824_();
                    }
                    return false;
                }
            }
            return false;
        }

        public void m_8056_() {
            this.f_26135_.m_6710_(this.attacker);
            LivingEntity livingentity = this.mudhorse.getCommander();
            if (livingentity != null) {
                this.timestamp = livingentity.m_21215_();
            }
            super.m_8056_();
        }
    }
}

