/*
 * Decompiled with CFR 0.152.
 */
package teamdraco.finsandstails.common.entities;

import java.util.List;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.control.SmoothSwimmingLookControl;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.animal.AbstractFish;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.HitResult;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;
import teamdraco.finsandstails.common.entities.TealArrowfishEntity;
import teamdraco.finsandstails.registry.FTItems;

public class GopjetEntity
extends AbstractFish
implements GeoEntity {
    private static final EntityDataAccessor<Boolean> IS_BOOSTING = SynchedEntityData.m_135353_(GopjetEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private final AnimatableInstanceCache factory = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private static final int BOOST_TIMER = 400;
    private int boostTimer = 400;

    public GopjetEntity(EntityType<? extends GopjetEntity> type, Level world) {
        super(type, world);
        this.f_21342_ = new MoveHelperController(this);
        this.f_21365_ = new SmoothSwimmingLookControl((Mob)this, 10);
    }

    public void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(1, (Goal)new AvoidEntityGoal((PathfinderMob)this, TealArrowfishEntity.class, 6.0f, 1.0, 1.5));
    }

    public static AttributeSupplier.Builder m_27495_() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 10.0).m_22268_(Attributes.f_22279_, 0.45);
    }

    public void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(IS_BOOSTING, (Object)false);
    }

    public void m_8119_() {
        List list = this.m_9236_().m_6443_(Player.class, this.m_20191_().m_82400_(2.5), EntitySelector.f_20406_);
        super.m_8119_();
        if (this.boostTimer > 0) {
            --this.boostTimer;
        }
        if (this.boostTimer == 0 || !list.isEmpty() && !this.m_27487_()) {
            this.boostTimer = 400;
            this.setBoosting(true);
            this.m_20256_(this.m_20171_(this.m_146909_(), this.m_146908_()).m_82542_(1.7, 0.0, 1.7));
        }
        if (this.boostTimer <= 350) {
            this.setBoosting(false);
        }
        this.m_9236_().m_7605_((Entity)this, (byte)38);
        if (this.isBoosting()) {
            this.m_9236_().m_7605_((Entity)this, (byte)39);
        }
    }

    public void setBoosting(boolean isBoosting) {
        this.m_20088_().m_135381_(IS_BOOSTING, (Object)isBoosting);
    }

    public boolean isBoosting() {
        return (Boolean)this.m_20088_().m_135370_(IS_BOOSTING);
    }

    public ItemStack m_28282_() {
        return new ItemStack((ItemLike)FTItems.GOPJET_BUCKET.get());
    }

    public SoundEvent m_7515_() {
        return SoundEvents.f_11758_;
    }

    public SoundEvent m_5592_() {
        return SoundEvents.f_11759_;
    }

    public SoundEvent m_7975_(DamageSource damageSourceIn) {
        return SoundEvents.f_11761_;
    }

    public SoundEvent m_5699_() {
        return SoundEvents.f_11760_;
    }

    public void m_7822_(byte id) {
        if (id == 38) {
            this.createParticles(ParticleTypes.f_123795_, 1);
        }
        if (id == 39) {
            this.createParticles(ParticleTypes.f_123795_, 4);
        } else {
            super.m_7822_(id);
        }
    }

    private void createParticles(SimpleParticleType p_208401_1_, int amount) {
        for (int i = 0; i < amount; ++i) {
            double d0 = this.f_19796_.m_188583_() * 0.056;
            double d1 = this.f_19796_.m_188583_() * 0.034;
            double d2 = this.f_19796_.m_188583_() * 0.025;
            this.m_9236_().m_7106_((ParticleOptions)p_208401_1_, this.m_20185_(), this.m_20187_(), this.m_20189_(), d0, d1, d2);
        }
    }

    public ItemStack getPickedResult(HitResult target) {
        return new ItemStack((ItemLike)FTItems.GOPJET_SPAWN_EGG.get());
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        controllerRegistrar.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 5, this::predicate)});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.factory;
    }

    private <E extends GeoEntity> PlayState predicate(AnimationState<E> event) {
        if (this.isBoosting()) {
            event.setAnimation(RawAnimation.begin().thenLoop("animation.gopjet.boost"));
        } else if (event.isMoving()) {
            event.setAnimation(RawAnimation.begin().thenLoop("animation.gopjet.swim"));
        } else {
            event.setAnimation(RawAnimation.begin().thenLoop("animation.gopjet.idle"));
        }
        return PlayState.CONTINUE;
    }

    static class MoveHelperController
    extends MoveControl {
        private final GopjetEntity gopjet;

        public MoveHelperController(GopjetEntity gopjetEntity) {
            super((Mob)gopjetEntity);
            this.gopjet = gopjetEntity;
        }

        public void m_8126_() {
            if (this.gopjet.m_20069_()) {
                this.gopjet.m_20256_(this.gopjet.m_20184_().m_82520_(0.0, 0.005, 0.0));
            }
            if (this.f_24981_ == MoveControl.Operation.MOVE_TO && !this.gopjet.m_21573_().m_26571_()) {
                double d2;
                double d1;
                double d0 = this.f_24975_ - this.gopjet.m_20185_();
                double d3 = d0 * d0 + (d1 = this.f_24976_ - this.gopjet.m_20186_()) * d1 + (d2 = this.f_24977_ - this.gopjet.m_20189_()) * d2;
                if (d3 < 2.500000277905201E-7) {
                    this.f_24974_.m_21564_(0.0f);
                } else {
                    float f = (float)(Mth.m_14136_((double)d2, (double)d0) * 57.2957763671875) - 90.0f;
                    this.gopjet.m_146922_(this.m_24991_(this.gopjet.m_146908_(), f, 10.0f));
                    this.gopjet.f_20883_ = this.gopjet.m_146908_();
                    this.gopjet.f_20885_ = this.gopjet.m_146908_();
                    float f1 = (float)(this.f_24978_ * this.gopjet.m_21133_(Attributes.f_22279_));
                    if (this.gopjet.m_20069_()) {
                        this.gopjet.m_7910_(f1 * 0.02f);
                        float f2 = -((float)(Mth.m_14136_((double)d1, (double)Mth.m_14116_((float)((float)(d0 * d0 + d2 * d2)))) * 57.2957763671875));
                        f2 = Mth.m_14036_((float)Mth.m_14177_((float)f2), (float)-85.0f, (float)85.0f);
                        this.gopjet.m_146926_(this.m_24991_(this.gopjet.m_146909_(), f2, 5.0f));
                        float f3 = Mth.m_14089_((float)(this.gopjet.m_146909_() * ((float)Math.PI / 180)));
                        float f4 = Mth.m_14031_((float)(this.gopjet.m_146909_() * ((float)Math.PI / 180)));
                        this.gopjet.f_20902_ = f3 * f1;
                        this.gopjet.f_20901_ = -f4 * f1;
                    } else {
                        this.gopjet.m_7910_(f1 * 0.1f);
                    }
                }
            } else {
                this.gopjet.m_7910_(0.0f);
                this.gopjet.m_21570_(0.0f);
                this.gopjet.m_21567_(0.0f);
                this.gopjet.m_21564_(0.0f);
            }
        }
    }
}

