/*
 * Decompiled with CFR 0.152.
 */
package teamdraco.finsandstails.common.entities;

import javax.annotation.Nullable;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.animal.WaterAnimal;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import teamdraco.finsandstails.common.entities.RedBullCrabEntity;
import teamdraco.finsandstails.registry.FTSounds;

public class GoliathGardenCrabEntity
extends WaterAnimal {
    private int attackAnimationTick;

    public GoliathGardenCrabEntity(EntityType<? extends GoliathGardenCrabEntity> type, Level world) {
        super(type, world);
        this.f_21342_ = new MoveHelperController(this);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new AvoidEntityGoal((PathfinderMob)this, RedBullCrabEntity.class, 8.0f, 2.2, 2.2));
        this.f_21345_.m_25352_(0, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, false));
        this.f_21345_.m_25352_(1, (Goal)new RandomStrollGoal((PathfinderMob)this, 1.0, 1500));
        this.f_21345_.m_25352_(2, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.f_21345_.m_25352_(2, (Goal)new LookAtPlayerGoal((Mob)this, Villager.class, 6.0f));
        this.f_21346_.m_25352_(0, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
    }

    protected PathNavigation m_6037_(Level world) {
        return new GroundPathNavigation((Mob)this, world);
    }

    protected float m_6108_() {
        return 0.9f;
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 100.0).m_22268_(Attributes.f_22279_, 0.1).m_22268_(Attributes.f_22278_, 0.8).m_22268_(Attributes.f_22281_, 10.0);
    }

    private float getAttackDamage() {
        return (float)this.m_21133_(Attributes.f_22281_);
    }

    public boolean m_7327_(Entity p_70652_1_) {
        this.attackAnimationTick = 10;
        this.m_9236_().m_7605_((Entity)this, (byte)4);
        float f = this.getAttackDamage();
        float f1 = (int)f > 0 ? f / 2.0f + (float)this.f_19796_.m_188503_((int)f) : f;
        boolean flag = p_70652_1_.m_6469_(this.m_9236_().m_269111_().m_269333_((LivingEntity)this), f1);
        if (flag) {
            p_70652_1_.m_20256_(p_70652_1_.m_20184_().m_82520_(0.0, (double)0.4f, 0.0));
            this.m_19970_((LivingEntity)this, p_70652_1_);
        }
        this.m_5496_(SoundEvents.f_12057_, 1.0f, 1.0f);
        return flag;
    }

    public void m_8107_() {
        super.m_8107_();
        if (this.attackAnimationTick > 0) {
            --this.attackAnimationTick;
        }
    }

    public void m_7822_(byte p_70103_1_) {
        if (p_70103_1_ == 4) {
            this.attackAnimationTick = 20;
            this.m_5496_(SoundEvents.f_12057_, 1.0f, 1.0f);
        } else {
            super.m_7822_(p_70103_1_);
        }
    }

    public int getAttackAnimationTick() {
        return this.attackAnimationTick;
    }

    @Nullable
    protected SoundEvent m_7975_(DamageSource damageSourceIn) {
        return SoundEvents.f_12529_;
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)FTSounds.CRAB_DEATH.get();
    }

    protected SoundEvent getFlopSound() {
        return SoundEvents.f_12528_;
    }

    protected void m_6229_(int p_209207_1_) {
    }

    static class MoveHelperController
    extends MoveControl {
        private final GoliathGardenCrabEntity crab;

        MoveHelperController(GoliathGardenCrabEntity crab) {
            super((Mob)crab);
            this.crab = crab;
        }

        public void m_8126_() {
            if (this.crab.m_204029_(FluidTags.f_13131_)) {
                this.crab.m_20256_(this.crab.m_20184_().m_82520_(0.0, 0.0, 0.0));
            }
            if (this.f_24981_ == MoveControl.Operation.MOVE_TO && !this.crab.m_21573_().m_26571_()) {
                double d0 = this.f_24975_ - this.crab.m_20185_();
                double d1 = this.f_24976_ - this.crab.m_20186_();
                double d2 = this.f_24977_ - this.crab.m_20189_();
                double d3 = Mth.m_14116_((float)((float)(d0 * d0 + d1 * d1 + d2 * d2)));
                d1 /= d3;
                float f = (float)(Mth.m_14136_((double)d2, (double)d0) * 57.2957763671875) - 90.0f;
                this.crab.m_146922_(this.m_24991_(this.crab.m_146908_(), f, 90.0f));
                this.crab.f_20883_ = this.crab.m_146908_();
                float f1 = (float)(this.f_24978_ * this.crab.m_21133_(Attributes.f_22279_));
                this.crab.m_7910_(Mth.m_14179_((float)0.125f, (float)this.crab.m_6113_(), (float)f1));
                this.crab.m_20256_(this.crab.m_20184_().m_82520_(0.0, (double)this.crab.m_6113_() * d1 * 0.1, 0.0));
            } else {
                this.crab.m_7910_(0.0f);
            }
        }
    }
}

